/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.border.Border;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class JIconTextField
extends JTextField {
    private Insets dummyInsets;
    private Border originalBorder;
    private ArrayList iconListeners = new ArrayList();
    private ArrayList paintIcons = new ArrayList();
    private Insets insets = new ScaledInsets(0, 0, 0, 0);

    public JIconTextField() {
        this.originalBorder = this.getBorder();
        JTextField dummy = new JTextField();
        this.dummyInsets = this.originalBorder.getBorderInsets(dummy);
        this.addMouseMotionListener(new InterceptListener());
    }

    protected void notifyIconListeners(String id, MouseEvent event) {
        for (int i = 0; i < this.iconListeners.size(); ++i) {
            IconClickListener listener = (IconClickListener)this.iconListeners.get(i);
            listener.iconClicked(id);
        }
    }

    private PaintIcon getPaintIconAt(Point point) {
        for (int i = 0; i < this.paintIcons.size(); ++i) {
            PaintIcon icon = (PaintIcon)this.paintIcons.get(i);
            if (icon.iconBounds == null || !icon.iconBounds.contains(point)) continue;
            return icon;
        }
        return null;
    }

    public void addIconClickListener(IconClickListener listener) {
        this.iconListeners.add(listener);
    }

    public void changeIcon(Icon newIcon, String id) {
        for (int i = 0; i < this.paintIcons.size(); ++i) {
            PaintIcon icon = (PaintIcon)this.paintIcons.get(i);
            if (!icon.id.equals(id)) continue;
            icon.icon = newIcon;
            return;
        }
    }

    public void addIcon(Icon icon, boolean onRight, boolean onlyShowWhenPopulated, String id) {
        PaintIcon paintIcon = new PaintIcon();
        paintIcon.icon = icon;
        paintIcon.onRight = onRight;
        paintIcon.paintOnlyWhenPopulated = onlyShowWhenPopulated;
        paintIcon.id = id;
        this.paintIcons.add(paintIcon);
        if (onRight) {
            this.insets.right = (int)((double)this.insets.right + (2.0 + (double)icon.getIconWidth() / SimpleHelpLookAndFeel.getScalingFactor()));
        } else {
            this.insets.left = (int)((double)this.insets.left + (2.0 + (double)icon.getIconWidth() / SimpleHelpLookAndFeel.getScalingFactor()));
        }
        this.setBorder(SHBorderFactory.createCompoundBorder((Border)this.originalBorder, (Border)SHBorderFactory.createEmptyBorder((int)this.insets.top, (int)this.insets.left, (int)this.insets.bottom, (int)this.insets.right)));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int leftX = this.dummyInsets.left;
        int rightX = this.getWidth() - this.dummyInsets.right;
        for (int i = 0; i < this.paintIcons.size(); ++i) {
            boolean shouldPaint;
            PaintIcon icon = (PaintIcon)this.paintIcons.get(i);
            boolean bl = shouldPaint = !icon.paintOnlyWhenPopulated || this.getText().length() > 0;
            if (shouldPaint) {
                int x;
                int y = (this.getHeight() - icon.icon.getIconHeight()) / 2;
                if (!icon.onRight) {
                    x = leftX;
                    icon.icon.paintIcon(this, g, leftX, y);
                    leftX += 2;
                    leftX += icon.icon.getIconWidth();
                } else {
                    x = rightX -= icon.icon.getIconWidth();
                    icon.icon.paintIcon(this, g, rightX, y);
                    rightX -= 2;
                }
                if (icon.iconBounds == null) {
                    icon.iconBounds = new Rectangle();
                }
                icon.iconBounds.x = x;
                icon.iconBounds.y = y;
                icon.iconBounds.width = icon.icon.getIconWidth();
                icon.iconBounds.height = icon.icon.getIconHeight();
                continue;
            }
            icon.iconBounds = null;
        }
    }

    static {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                MouseEvent event;
                JIconTextField textField;
                PaintIcon icon;
                if (e.getSource() instanceof JIconTextField && (icon = (textField = (JIconTextField)e.getSource()).getPaintIconAt((event = (MouseEvent)e).getPoint())) != null) {
                    event.consume();
                    textField.notifyIconListeners(icon.id, event);
                }
            }
        }, 16L);
    }

    public static interface IconClickListener {
        public void iconClicked(String var1);
    }

    class InterceptListener
    extends MouseAdapter
    implements MouseMotionListener {
        InterceptListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (JIconTextField.this.iconListeners.size() == 0) {
                return;
            }
            PaintIcon icon = JIconTextField.this.getPaintIconAt(e.getPoint());
            if (icon != null) {
                JIconTextField.this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                JIconTextField.this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    class PaintIcon {
        boolean paintOnlyWhenPopulated;
        boolean onRight;
        Icon icon;
        public String id;
        Rectangle iconBounds;

        PaintIcon() {
        }
    }
}

