/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.border.Border;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.switches.oem.OEMSwitches;

public class FadedBorder
implements Border {
    private Color startColor = !OEMSwitches.DARK_THEME ? new Color(250, 250, 250) : SHStyle.PANEL_BACKGROUND_DARK;
    private Color middleColor = !OEMSwitches.DARK_THEME ? new Color(180, 180, 180) : new Color(50, 50, 50);
    private boolean drawBottom = true;
    private boolean drawTop = true;

    public FadedBorder(boolean drawTop, boolean drawBottom) {
        this.drawTop = drawTop;
        this.drawBottom = drawBottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        try {
            GradientPaint horizontalPaint = new GradientPaint(0.0f, 0.0f, this.startColor, width / 2, 0.0f, this.middleColor, true);
            g2d.setPaint(horizontalPaint);
            if (this.drawTop) {
                g2d.drawLine(x, y + 1, x + width, y + 1);
            }
            if (this.drawBottom) {
                g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, height / 2, this.middleColor, true);
        }
        finally {
            g2d.setPaint(oldPaint);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new ScaledInsets(3, 3, 3, 3);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

