/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color.colorpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import utils.swing.SwingUtil;
import utils.swing.color.colorpicker.ColorPickerPanel;
import utils.swing.color.colorpicker.ColorPickerSliderUI;
import utils.swing.color.colorpicker.ColorSwatch;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class ColorPicker
extends GbPanel {
    private static final long serialVersionUID = 3L;
    protected static ResourceBundle strings;
    public static final String SELECTED_COLOR_PROPERTY = "selected color";
    public static final String MODE_CONTROLS_VISIBLE_PROPERTY = "mode controls visible";
    public static final String OPACITY_PROPERTY = "opacity";
    public static final String MODE_PROPERTY = "mode";
    public static final int HUE = 0;
    public static final int BRI = 1;
    public static final int SAT = 2;
    public static final int RED = 3;
    public static final int GREEN = 4;
    public static final int BLUE = 5;
    private JSlider slider = new JSlider(1, 0, 100, 0);
    private int currentRed = 0;
    private int currentGreen = 0;
    private int currentBlue = 0;
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (ColorPicker.this.hue.contains(src) || ColorPicker.this.sat.contains(src) || ColorPicker.this.bri.contains(src)) {
                if (ColorPicker.this.adjustingSpinners > 0) {
                    return;
                }
                ColorPicker.this.setHSB(ColorPicker.this.hue.getFloatValue() / 360.0f, ColorPicker.this.sat.getFloatValue() / 100.0f, ColorPicker.this.bri.getFloatValue() / 100.0f);
            } else if (ColorPicker.this.red.contains(src) || ColorPicker.this.green.contains(src) || ColorPicker.this.blue.contains(src)) {
                if (ColorPicker.this.adjustingSpinners > 0) {
                    return;
                }
                ColorPicker.this.setRGB(ColorPicker.this.red.getIntValue(), ColorPicker.this.green.getIntValue(), ColorPicker.this.blue.getIntValue());
            } else if (src == ColorPicker.this.colorPanel) {
                if (ColorPicker.this.adjustingColorPanel > 0) {
                    return;
                }
                int mode = ColorPicker.this.getMode();
                if (mode == 0 || mode == 1 || mode == 2) {
                    float[] hsb = ColorPicker.this.colorPanel.getHSB();
                    ColorPicker.this.setHSB(hsb[0], hsb[1], hsb[2]);
                } else {
                    int[] rgb = ColorPicker.this.colorPanel.getRGB();
                    ColorPicker.this.setRGB(rgb[0], rgb[1], rgb[2]);
                }
            } else if (src == ColorPicker.this.slider) {
                if (ColorPicker.this.adjustingSlider > 0) {
                    return;
                }
                int v = ColorPicker.this.slider.getValue();
                Option option = ColorPicker.this.getSelectedOption();
                option.setValue(v);
            } else if (ColorPicker.this.alpha.contains(src)) {
                if (ColorPicker.this.adjustingOpacity > 0) {
                    return;
                }
                int v = ColorPicker.this.alpha.getIntValue();
                ColorPicker.this.setOpacity(v);
            } else if (src == ColorPicker.this.opacitySlider) {
                if (ColorPicker.this.adjustingOpacity > 0) {
                    return;
                }
                ColorPicker.this.setOpacity(ColorPicker.this.opacitySlider.getValue());
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
        }
    };
    private Option alpha;
    private Option hue;
    private Option sat;
    private Option bri;
    private Option red;
    private Option green;
    private Option blue;
    private JLabel hexLabel;
    private ColorSwatch preview = new ColorSwatch(50);
    private JTextField hexField = new JTextField("000000");
    private int adjustingSpinners = 0;
    private int adjustingSlider = 0;
    private int adjustingColorPanel = 0;
    private int adjustingHexField = 0;
    private int adjustingOpacity = 0;
    private GbPanel expertControls = new GbPanel();
    private ColorPickerPanel colorPanel = new ColorPickerPanel();
    private JSlider opacitySlider = new JSlider(0, 255, 255);
    private JLabel opacityLabel;
    private int lastOpacity = 255;

    private Option getSelectedOption() {
        int mode = this.getMode();
        if (mode == 0) {
            return this.hue;
        }
        if (mode == 2) {
            return this.sat;
        }
        if (mode == 1) {
            return this.bri;
        }
        if (mode == 3) {
            return this.red;
        }
        if (mode == 4) {
            return this.green;
        }
        return this.blue;
    }

    public ColorPicker(ResourceBundle lang) {
        this(lang, true, false);
    }

    public ColorPicker(ResourceBundle lang, boolean showExpertControls, boolean includeOpacity) {
        strings = lang;
        this.opacityLabel = new JLabel(strings.getString("OPACITY"));
        this.alpha = new Option(strings.getString("ALPHA"), 255);
        this.hue = new Option(strings.getString("HUE"), 360);
        this.sat = new Option(strings.getString("SATURATION"), 100);
        this.bri = new Option(strings.getString("BRIGHTNESS"), 100);
        this.red = new Option(strings.getString("RED"), 255);
        this.green = new Option(strings.getString("GREEN"), 255);
        this.blue = new Option(strings.getString("BLUE"), 255);
        this.hexLabel = new JLabel(strings.getString("HEX"));
        ScaledInsets normalInsets = new ScaledInsets(3, 3, 3, 3);
        GbPanel options = new GbPanel(normalInsets);
        Option[] optionsArray = new Option[]{this.hue, this.sat, this.bri, this.red, this.green, this.blue};
        Insets topBorderInsets = new Insets(normalInsets.top + SimpleHelpLookAndFeel.scale((int)10), normalInsets.left, normalInsets.bottom, normalInsets.right);
        int optionsY = 0;
        for (int a = 0; a < optionsArray.length; ++a) {
            Insets rowInsets = a == 3 || a == 6 ? topBorderInsets : normalInsets;
            options.add((Component)optionsArray[a].label, 0, optionsY, 1, 1, 1, 1, 13, 0, rowInsets);
            options.add((Component)optionsArray[a].field, 1, optionsY++, 1, 1, 1, 1, 17, 2, rowInsets);
        }
        options.add((Component)this.hexLabel, 0, optionsY, 1, 1, 1, 1, 13, 0, topBorderInsets);
        options.add((Component)this.hexField, 1, optionsY++, 1, 1, 1, 1, 17, 2, topBorderInsets);
        options.add((Component)this.alpha.label, 0, optionsY, 1, 1, 1, 1, 13, 0, (Insets)normalInsets);
        options.add((Component)this.alpha.field, 1, optionsY++, 1, 1, 1, 1, 17, 2, (Insets)normalInsets);
        this.add(this.colorPanel, 0, 0, 2, 1, 1, 1, 13, 1, (Insets)normalInsets);
        this.add(this.slider, 2, 0, 1, 1, 0, 0, 10, 3, (Insets)normalInsets);
        this.add((Component)this.expertControls, 3, 0, 1, 1, 0, 0, 10, 0, (Insets)normalInsets);
        this.add(this.opacityLabel, 0, 1, 1, 1, 0, 0, 10, 0, (Insets)normalInsets);
        this.add(this.opacitySlider, 1, 1, 2, 1, 1, 0, 10, 2, (Insets)normalInsets);
        this.expertControls.add((Component)this.preview, 0, 0, 1, 1, 1, 0, 10, 1, new Insets(normalInsets.top, normalInsets.left + SimpleHelpLookAndFeel.scale((int)8), normalInsets.bottom + SimpleHelpLookAndFeel.scale((int)10), normalInsets.right + SimpleHelpLookAndFeel.scale((int)8)));
        this.expertControls.add((Component)options, 0, 1, 1, 1, 1, 0, 10, 1, new Insets(normalInsets.top, normalInsets.left, 0, normalInsets.right));
        this.expertControls.add((Component)new JPanel(), 0, 2, 1, 1, 1, 1, 10, 1);
        SwingUtil.setWidth((JComponent)this.expertControls, (int)(this.expertControls.getPreferredSize().width + 5));
        this.preview.setOpaque(true);
        this.slider.addChangeListener(this.changeListener);
        this.colorPanel.addChangeListener(this.changeListener);
        this.slider.setUI(new ColorPickerSliderUI(this.slider, this));
        HexDocumentListener hexDocListener = new HexDocumentListener();
        this.hexField.getDocument().addDocumentListener(hexDocListener);
        this.setMode(1);
        this.setExpertControlsVisible(showExpertControls);
        this.setOpacityVisible(includeOpacity);
        this.opacitySlider.addChangeListener(this.changeListener);
        this.setOpacity(255);
        ColorPicker.setOpaque((JComponent)((Object)this), false);
        this.preview.setForeground(this.getColor());
    }

    private static void setOpaque(JComponent jc, boolean opaque) {
        if (jc instanceof JTextField) {
            return;
        }
        jc.setOpaque(false);
        if (jc instanceof JSpinner) {
            return;
        }
        for (int a = 0; a < jc.getComponentCount(); ++a) {
            JComponent child = (JComponent)jc.getComponent(a);
            ColorPicker.setOpaque(child, opaque);
        }
    }

    public void setHexControlsVisible(boolean b) {
        this.hexLabel.setVisible(b);
        this.hexField.setVisible(b);
    }

    public void setPreviewSwatchVisible(boolean b) {
        this.preview.setVisible(b);
    }

    public void setExpertControlsVisible(boolean b) {
        this.expertControls.setVisible(b);
    }

    public float[] getHSB() {
        return new float[]{this.hue.getFloatValue() / 360.0f, this.sat.getFloatValue() / 100.0f, this.bri.getFloatValue() / 100.0f};
    }

    public int[] getRGB() {
        return new int[]{this.currentRed, this.currentGreen, this.currentBlue};
    }

    public float getOpacity() {
        return (float)this.opacitySlider.getValue() / 255.0f;
    }

    public void setOpacity(int v) {
        if (v < 0 || v > 255) {
            throw new IllegalArgumentException("The opacity (" + v + ") must be between 0 and 255.");
        }
        ++this.adjustingOpacity;
        try {
            this.opacitySlider.setValue(v);
            this.alpha.setValue(v);
            if (this.lastOpacity != v) {
                this.firePropertyChange(OPACITY_PROPERTY, new Integer(this.lastOpacity), new Integer(v));
                Color c = this.preview.getForeground();
                this.preview.setForeground(new Color(c.getRed(), c.getGreen(), c.getBlue(), v));
            }
            this.lastOpacity = v;
        }
        finally {
            --this.adjustingOpacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (mode != 0 && mode != 2 && mode != 1 && mode != 3 && mode != 4 && mode != 5) {
            throw new IllegalArgumentException("mode must be HUE, SAT, BRI, REd, GREEN, or BLUE");
        }
        this.putClientProperty(MODE_PROPERTY, mode);
        this.colorPanel.setMode(mode);
        ++this.adjustingSlider;
        try {
            this.slider.setValue(0);
            Option option = this.getSelectedOption();
            this.slider.setInverted(mode == 0);
            int max = option.getMaximum();
            this.slider.setMaximum(max);
            this.slider.setValue(option.getIntValue());
            this.slider.repaint();
            if (mode == 0 || mode == 2 || mode == 1) {
                this.setHSB(this.hue.getFloatValue() / 360.0f, this.sat.getFloatValue() / 100.0f, this.bri.getFloatValue() / 100.0f);
            } else {
                this.setRGB(this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue());
            }
        }
        finally {
            --this.adjustingSlider;
        }
    }

    public void setModeControlsVisible(boolean b) {
        this.putClientProperty(MODE_CONTROLS_VISIBLE_PROPERTY, b);
    }

    public int getMode() {
        Integer i = (Integer)this.getClientProperty(MODE_PROPERTY);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setColor(Color c) {
        this.setRGB(c.getRed(), c.getGreen(), c.getBlue());
        this.setOpacity(c.getAlpha());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("The red value (" + r + ") must be between [0,255].");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("The green value (" + g + ") must be between [0,255].");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("The blue value (" + b + ") must be between [0,255].");
        }
        Color lastColor = this.getColor();
        boolean updateRGBSpinners = this.adjustingSpinners == 0;
        ++this.adjustingSpinners;
        ++this.adjustingColorPanel;
        int alpha = this.alpha.getIntValue();
        try {
            if (updateRGBSpinners) {
                this.red.setValue(r);
                this.green.setValue(g);
                this.blue.setValue(b);
            }
            this.preview.setForeground(new Color(r, g, b, alpha));
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            this.hue.setValue((int)(hsb[0] * 360.0f + 0.49f));
            this.sat.setValue((int)(hsb[1] * 100.0f + 0.49f));
            this.bri.setValue((int)(hsb[2] * 100.0f + 0.49f));
            this.colorPanel.setRGB(r, g, b);
            this.updateHexField();
            this.updateSlider();
        }
        finally {
            --this.adjustingSpinners;
            --this.adjustingColorPanel;
        }
        this.currentRed = r;
        this.currentGreen = g;
        this.currentBlue = b;
        Color newColor = this.getColor();
        if (!lastColor.equals(newColor)) {
            this.firePropertyChange(SELECTED_COLOR_PROPERTY, lastColor, newColor);
        }
    }

    public Color getColor() {
        int[] i = this.getRGB();
        return new Color(i[0], i[1], i[2], this.opacitySlider.getValue());
    }

    private void updateSlider() {
        ++this.adjustingSlider;
        try {
            int mode = this.getMode();
            if (mode == 0) {
                this.slider.setValue(this.hue.getIntValue());
            } else if (mode == 2) {
                this.slider.setValue(this.sat.getIntValue());
            } else if (mode == 1) {
                this.slider.setValue(this.bri.getIntValue());
            } else if (mode == 3) {
                this.slider.setValue(this.red.getIntValue());
            } else if (mode == 4) {
                this.slider.setValue(this.green.getIntValue());
            } else if (mode == 5) {
                this.slider.setValue(this.blue.getIntValue());
            }
        }
        finally {
            --this.adjustingSlider;
        }
        this.slider.repaint();
    }

    public JPanel getExpertControls() {
        return this.expertControls;
    }

    public void setRGBControlsVisible(boolean b) {
        this.red.setVisible(b);
        this.green.setVisible(b);
        this.blue.setVisible(b);
    }

    public void setHSBControlsVisible(boolean b) {
        this.hue.setVisible(b);
        this.sat.setVisible(b);
        this.bri.setVisible(b);
    }

    public void setOpacityVisible(boolean b) {
        this.opacityLabel.setVisible(b);
        this.opacitySlider.setVisible(b);
        this.alpha.label.setVisible(b);
        this.alpha.field.setVisible(b);
    }

    public ColorPickerPanel getColorPanel() {
        return this.colorPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHSB(float h, float s, float b) {
        if (Float.isInfinite(h) || Float.isNaN(h)) {
            throw new IllegalArgumentException("The hue value (" + h + ") is not a valid number.");
        }
        while (h < 0.0f) {
            h += 1.0f;
        }
        while (h > 1.0f) {
            h -= 1.0f;
        }
        if (s < 0.0f || s > 1.0f) {
            throw new IllegalArgumentException("The saturation value (" + s + ") must be between [0,1]");
        }
        if (b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("The brightness value (" + b + ") must be between [0,1]");
        }
        Color lastColor = this.getColor();
        boolean updateHSBSpinners = this.adjustingSpinners == 0;
        ++this.adjustingSpinners;
        ++this.adjustingColorPanel;
        try {
            if (updateHSBSpinners) {
                this.hue.setValue((int)(h * 360.0f + 0.49f));
                this.sat.setValue((int)(s * 100.0f + 0.49f));
                this.bri.setValue((int)(b * 100.0f + 0.49f));
            }
            Color c = new Color(Color.HSBtoRGB(h, s, b));
            int alpha = this.alpha.getIntValue();
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            this.preview.setForeground(c);
            this.currentRed = c.getRed();
            this.currentGreen = c.getGreen();
            this.currentBlue = c.getBlue();
            this.red.setValue(this.currentRed);
            this.green.setValue(this.currentGreen);
            this.blue.setValue(this.currentBlue);
            this.colorPanel.setHSB(h, s, b);
            this.updateHexField();
            this.updateSlider();
            this.slider.repaint();
        }
        finally {
            --this.adjustingSpinners;
            --this.adjustingColorPanel;
        }
        Color newColor = this.getColor();
        if (!lastColor.equals(newColor)) {
            this.firePropertyChange(SELECTED_COLOR_PROPERTY, lastColor, newColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHexField() {
        ++this.adjustingHexField;
        try {
            int r = this.red.getIntValue();
            int g = this.green.getIntValue();
            int b = this.blue.getIntValue();
            int i = (r << 16) + (g << 8) + b;
            StringBuilder s = new StringBuilder(Integer.toHexString(i).toUpperCase());
            while (s.length() < 6) {
                s.insert(0, "0");
            }
            if (!this.hexField.getText().equalsIgnoreCase(s.toString())) {
                this.hexField.setText(s.toString());
            }
        }
        finally {
            --this.adjustingHexField;
        }
    }

    public class RestrictedNumberDocumentFilter
    extends DocumentFilter {
        private double min;
        private double max;

        public RestrictedNumberDocumentFilter(double min, double max) {
            if (max < min) {
                double temp = max;
                max = min;
                min = temp;
            }
            this.min = min;
            this.max = max;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int off, String str, AttributeSet attr) throws BadLocationException {
            StringBuilder sb = new StringBuilder(fb.getDocument().getText(0, fb.getDocument().getLength()));
            if (this.test(sb.toString())) {
                fb.insertString(off, str, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int off, int len, String str, AttributeSet attr) throws BadLocationException {
            StringBuilder sb = new StringBuilder(fb.getDocument().getText(0, fb.getDocument().getLength()));
            sb.replace(off, off + len, str);
            if (this.test(sb.toString())) {
                fb.replace(off, len, str, attr);
            }
        }

        private boolean test(String val) {
            try {
                double d = Double.parseDouble(val);
                return d >= this.min && d <= this.max;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    class Option
    implements KeyListener {
        private final int max;
        private JTextField field = new JTextField();
        private JLabel label;

        public Option(String text, int max) {
            this.field.setText(Integer.toString(max));
            this.max = max;
            this.label = new JLabel(text);
            AbstractDocument doc = (AbstractDocument)this.field.getDocument();
            doc.setDocumentFilter(new RestrictedNumberDocumentFilter(0.0, max));
            this.field.addKeyListener(this);
        }

        public void setValue(int i) {
            this.field.setText(Integer.toString(i));
            this.notifyChange(this.field);
        }

        public int getMaximum() {
            return this.max;
        }

        public boolean contains(Object src) {
            return src == this.label || src == this.field;
        }

        public float getFloatValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            return Integer.parseInt(this.field.getText());
        }

        public boolean isVisible() {
            return this.label.isVisible();
        }

        public void setVisible(boolean b) {
            this.label.setVisible(b);
            this.field.setVisible(b);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.notifyChange(e.getSource());
        }

        private void notifyChange(Object source) {
            ChangeEvent ee = new ChangeEvent(source);
            try {
                ColorPicker.this.changeListener.stateChanged(ee);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class HexDocumentListener
    implements DocumentListener {
        int DELAY = 1500;
        String uncommittedText = null;
        Timer delayedUpdater = new Timer(this.DELAY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HexDocumentListener.this.uncommittedText != null) {
                    int pos = ColorPicker.this.hexField.getCaretPosition();
                    pos = Math.min(pos, HexDocumentListener.this.uncommittedText.length());
                    ColorPicker.this.hexField.setText(HexDocumentListener.this.uncommittedText);
                    ColorPicker.this.hexField.setCaretPosition(pos);
                }
            }
        });

        HexDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (ColorPicker.this.adjustingHexField > 0) {
                return;
            }
            String hexFieldText = ColorPicker.this.hexField.getText();
            StringBuilder s = new StringBuilder(this.stripToHex(hexFieldText, 6));
            boolean delay = false;
            if (s.length() < 6) {
                delay = true;
                while (s.length() < 6) {
                    s.append("0");
                }
            }
            try {
                int i = Integer.parseInt(s.toString(), 16);
                int red = i >> 16 & 0xFF;
                int green = i >> 8 & 0xFF;
                int blue = i & 0xFF;
                if (delay) {
                    this.delayedUpdater.setRepeats(false);
                    this.delayedUpdater.restart();
                    this.uncommittedText = s.toString();
                } else {
                    this.delayedUpdater.stop();
                    SwingUtilities.invokeLater(new SetRGBRunnable(red, green, blue));
                    this.uncommittedText = null;
                }
                return;
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
                return;
            }
        }

        private String stripToHex(String s, int charLimit) {
            s = s.toUpperCase();
            StringBuilder returnValue = new StringBuilder(6);
            for (int a = 0; a < s.length() && returnValue.length() < charLimit; ++a) {
                char c = s.charAt(a);
                if (!Character.isDigit(c) && (c < 'A' || c > 'F')) continue;
                returnValue.append(c);
            }
            return returnValue.toString();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }

    class SetRGBRunnable
    implements Runnable {
        final int red;
        final int green;
        final int blue;

        SetRGBRunnable(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        @Override
        public void run() {
            int pos = ColorPicker.this.hexField.getCaretPosition();
            ColorPicker.this.setRGB(this.red, this.green, this.blue);
            pos = Math.min(pos, ColorPicker.this.hexField.getText().length());
            ColorPicker.this.hexField.setCaretPosition(pos);
        }
    }
}

