/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    public static String pickServerFromURL(String urlstr, boolean includePort) {
        return URLUtil.pickServerFromURL(urlstr, includePort, urlstr);
    }

    public static String pickServerFromURL(String urlstr, boolean includePort, String def) {
        try {
            URL url;
            try {
                url = new URL(urlstr);
            }
            catch (MalformedURLException x) {
                int proto = urlstr.indexOf(58);
                urlstr = "http" + urlstr.substring(proto);
                url = new URL(urlstr);
            }
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String key = host;
            if (includePort) {
                key = key + ":" + port;
            }
            return key;
        }
        catch (Exception x) {
            System.out.println("Unable to parse URL: " + urlstr + " - " + x);
            return def;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(URLUtil.pickServerFromURL("https://sh.com:8008", false));
        System.out.println(URLUtil.pickServerFromURL("https://sh.com:8008", true));
        System.out.println(URLUtil.pickServerFromURL("udp://sh.com:8008", false));
        System.out.println(URLUtil.pickServerFromURL("udp://sh.com:8008", true));
        System.out.println(URLUtil.pickServerFromURL("http://sh.com:8008", false));
        System.out.println(URLUtil.pickServerFromURL("http://sh.com:8008", true));
        System.out.println(URLUtil.pickServerFromURL("rubbish://sh.com:8008", false));
        System.out.println(URLUtil.pickServerFromURL("rubbish://sh.com:8008", true));
        System.out.println(URLUtil.pickServerFromURL("rubbish://sh.com:8008/%^&6s5456dsfagd", false));
        System.out.println(URLUtil.pickServerFromURL("rubbish://sh.com:8008/%^&6s5456dsfagd", true));
    }
}

