/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedCpuOutputStream
extends FilterOutputStream {
    OutputStream out;
    double PERCENT;
    double FACTOR;

    public LimitedCpuOutputStream(OutputStream out) {
        this(out, 0.25);
    }

    public LimitedCpuOutputStream(OutputStream out, double percentCpu) {
        super(out);
        this.out = out;
        this.PERCENT = percentCpu;
        this.FACTOR = (1.0 - this.PERCENT) / this.PERCENT;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int N = 10000;
        while (len > N) {
            long t = System.currentTimeMillis();
            this.out.write(b, off, N);
            t = System.currentTimeMillis() - t;
            if (this.PERCENT < 1.0) {
                try {
                    long tfac = (long)(this.FACTOR * (double)t);
                    Thread.sleep(tfac);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            off += N;
            len -= N;
            if (t >= 30L) continue;
            N *= 2;
        }
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        long t = System.currentTimeMillis();
        this.out.write(b);
        t = System.currentTimeMillis() - t;
        if (this.PERCENT < 1.0) {
            try {
                System.out.println("sleeping " + t);
                Thread.sleep(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

