/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;

public class IpQuery {
    public static ArrayList getAllIPAddresses(boolean ipv4, boolean ipv6) throws IOException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> ips = ni.getInetAddresses();
            while (ips.hasMoreElements()) {
                InetAddress addr = ips.nextElement();
                if (addr.getAddress().length == 4) {
                    if (!ipv4) continue;
                    list.add(addr);
                    continue;
                }
                if (!ipv6) continue;
                list.add(addr);
            }
        }
        return list;
    }

    public static ArrayList getAllLanIPs(boolean ipv4, boolean ipv6) throws IOException {
        ArrayList list = IpQuery.getAllIPAddresses(ipv4, ipv6);
        for (int i = 0; i < list.size(); ++i) {
            InetAddress addr = (InetAddress)list.get(i);
            if (!addr.isLoopbackAddress()) continue;
            list.remove(i--);
        }
        return list;
    }

    public static InetAddress getOneLanIP() throws IOException {
        ArrayList list = IpQuery.getAllLanIPs(true, false);
        if (list.size() == 0) {
            return null;
        }
        return (InetAddress)list.get(0);
    }

    public static String getHostnameForOneLanIP() throws IOException {
        InetAddress addr = IpQuery.getOneLanIP();
        return addr.getCanonicalHostName();
    }

    public static InetAddress getLoopback() throws IOException {
        return InetAddress.getByName(null);
    }

    public static void main(String[] args) throws Exception {
        ArrayList list = IpQuery.getAllLanIPs(true, false);
        for (int i = 0; i < list.size(); ++i) {
            System.out.println(list.get(i));
        }
        System.out.println("getLocalHost: " + InetAddress.getLocalHost());
    }
}

