/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

public class FixedBandwidthLimiter {
    int kbsec = 0;
    long cumulativeTime = 0L;
    long cumulativeBytes = 0L;
    int SEC_FACTOR = 20;

    public void setKBsec(int kbsec) {
        this.kbsec = kbsec;
    }

    public void didWrite(long nanos, long bytes) {
        if (this.kbsec == 0) {
            this.cumulativeTime = 0L;
            this.cumulativeBytes = 0L;
            return;
        }
        this.cumulativeTime += nanos;
        this.cumulativeBytes += bytes;
        long millis = this.cumulativeTime / 1000000L;
        int bpersec = this.kbsec * 1024;
        if (this.cumulativeBytes > (long)(bpersec / this.SEC_FACTOR)) {
            double expectedMillis = 1000.0 / (double)this.SEC_FACTOR * ((double)this.cumulativeBytes / (double)(bpersec / this.SEC_FACTOR));
            long sleepFor = (long)expectedMillis - millis;
            if (sleepFor > 0L) {
                try {
                    Thread.sleep(sleepFor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cumulativeTime = 0L;
            this.cumulativeBytes = 0L;
        }
    }
}

