/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import utils.message.Message;

public class KeyStoreUtility {
    static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore openKeystore(File file, String storePassword, String keyPassword) throws CertificateException, UnrecoverableKeyException, IOException {
        System.out.println("[KeyStoreUtility] Attempting to load keystore as JKS");
        KeyStore keyStore = null;
        try {
            try {
                keyStore = KeyStore.getInstance("JKS");
                try (FileInputStream fin = new FileInputStream(file);){
                    keyStore.load(fin, storePassword.toCharArray());
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        catch (IOException badFormatException) {
            if (badFormatException.getCause() != null && badFormatException.getCause() instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)badFormatException.getCause();
            }
            if (!badFormatException.getMessage().equals("Invalid keystore format")) {
                badFormatException.printStackTrace();
            }
            try {
                System.out.println("[KeyStoreUtility] Opening as a JKS failed. Attempting PKCS12");
                try {
                    keyStore = KeyStore.getInstance("PKCS12");
                    keyStore.load(new FileInputStream(file), storePassword.toCharArray());
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException t) {
                t.printStackTrace();
                if (t.getCause() != null && t.getCause() instanceof UnrecoverableKeyException) {
                    throw (UnrecoverableKeyException)t.getCause();
                }
                throw badFormatException;
            }
        }
        return keyStore;
    }

    public static PKIXParameters getCACertsTrustedAnchors() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, InvalidAlgorithmParameterException {
        KeyStore caCerts = KeyStore.getInstance("JKS");
        String javaHome = System.getProperty("java.home");
        caCerts.load(new FileInputStream(javaHome + "/lib/security/cacerts"), "changeit".toCharArray());
        PKIXParameters anchors = new PKIXParameters(caCerts);
        X509Certificate root = KeyStoreUtility.loadCertificate(new File("lib/le_certificates/IdenTrust/root.crt"));
        if (root == null) {
            return anchors;
        }
        HashSet<TrustAnchor> newAnchors = new HashSet<TrustAnchor>(anchors.getTrustAnchors());
        newAnchors.add(new TrustAnchor(root, null));
        anchors.setTrustAnchors(newAnchors);
        return anchors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(File file) throws CertificateException {
        X509Certificate x509Certificate;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream in = new FileInputStream(file);
        try {
            x509Certificate = (X509Certificate)cf.generateCertificate(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
        try {
            ((InputStream)in).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return x509Certificate;
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException sigEx) {
            return false;
        }
        catch (InvalidKeyException keyEx) {
            return false;
        }
    }

    public static KeystoreValidationResult validateKeystore(KeyStore keystore) throws KeyStoreException, UnableToLoadCACertsException {
        KeystoreValidationResult result = new KeystoreValidationResult();
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            try {
                PKIXParameters caCertsTrustedAnchors;
                String alias = aliases.nextElement();
                CertificateChainSummary summary = new CertificateChainSummary();
                System.out.println("[KeyStoreUtility] Alias: " + alias);
                Certificate[] certificateChain = keystore.getCertificateChain(alias);
                ArrayList<Certificate> mylist = new ArrayList<Certificate>();
                if (certificateChain != null) {
                    for (Certificate c : certificateChain) {
                        mylist.add(c);
                        if (c instanceof X509Certificate) {
                            X509Certificate cert = (X509Certificate)c;
                            if (certificateChain.length == 1) {
                                try {
                                    if (KeyStoreUtility.isSelfSigned(cert)) {
                                        summary.isSelfSigned = true;
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            CertificateSummary certSummary = new CertificateSummary();
                            certSummary.dateFrom = DATE_FORMAT.format(cert.getNotBefore());
                            certSummary.dateTo = DATE_FORMAT.format(cert.getNotAfter());
                            certSummary.issuer = KeyStoreUtility.getCN(cert.getIssuerX500Principal().toString());
                            certSummary.subject = KeyStoreUtility.getCN(cert.getSubjectX500Principal().toString());
                            summary.certificates.add(certSummary);
                            continue;
                        }
                        summary.contansUnknownCertificateTypes = true;
                    }
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                CertPath cp = cf.generateCertPath(mylist);
                try {
                    caCertsTrustedAnchors = KeyStoreUtility.getCACertsTrustedAnchors();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new UnableToLoadCACertsException();
                }
                caCertsTrustedAnchors.setRevocationEnabled(false);
                try {
                    summary.isChainValidate = false;
                    CertPathValidatorResult validationResult = CertPathValidator.getInstance("PKIX").validate(cp, caCertsTrustedAnchors);
                    PKIXCertPathValidatorResult v = (PKIXCertPathValidatorResult)validationResult;
                    summary.isChainValidate = true;
                }
                catch (InvalidAlgorithmParameterException ex) {
                    ex.printStackTrace();
                }
                catch (NoSuchAlgorithmException ex) {
                    ex.printStackTrace();
                }
                catch (CertPathValidatorException ex) {
                    summary.validateError = ex.getCause() != null ? ex.getMessage() + " (" + ex.getCause().getMessage() + ")" : ex.getMessage();
                    ex.printStackTrace();
                }
                result.aliasToChain.put(alias, summary);
            }
            catch (CertificateException certificateException) {}
        }
        return result;
    }

    private static String getCN(String dn) {
        int start = dn.indexOf("CN=");
        start = start != -1 ? (start += 3) : dn.indexOf("=") + 1;
        int end = dn.indexOf(44, start);
        if (end > start) {
            return dn.substring(start, end);
        }
        return dn.substring(start);
    }

    public static KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        try {
            return KeyManagerFactory.getInstance("SunX509");
        }
        catch (Throwable t) {
            System.out.println("[SSLCertificate] No Sun SSL Provider found.");
            try {
                return KeyManagerFactory.getInstance("IbmX509");
            }
            catch (Throwable tt) {
                System.out.println("[SSLCertificate] No IBM SSL Provider found.");
                try {
                    return KeyManagerFactory.getInstance("X.509");
                }
                catch (Throwable ttt) {
                    System.out.println("[SSLCertificate] No Generic X.509 Provider found.");
                    return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
            }
        }
    }

    public static long getExpiryDate(KeyStore store) throws KeyStoreException {
        long earliestExpiry = 0L;
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = store.getCertificate(alias);
            if (!certificate.getType().equals("X.509")) continue;
            long expiry = ((X509Certificate)store.getCertificate(alias)).getNotAfter().getTime();
            if (earliestExpiry == 0L) {
                earliestExpiry = expiry;
            }
            earliestExpiry = Math.min(earliestExpiry, earliestExpiry);
        }
        return earliestExpiry;
    }

    public static long getExpiryDate(KeyStore store, String alias) throws KeyStoreException {
        long earliestExpiry = 0L;
        try {
            Certificate certificate = store.getCertificate(alias);
            if (certificate.getType().equals("X.509")) {
                return ((X509Certificate)store.getCertificate(alias)).getNotAfter().getTime();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return 0L;
    }

    public static String getCertificateDNSName(KeyStore store) throws KeyStoreException, IOException, CertificateParsingException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = store.getCertificate(alias);
            if (!certificate.getType().equals("X.509")) continue;
            X509Certificate x509cert = (X509Certificate)store.getCertificate(alias);
            Collection subjectAlternativeNames = X509ExtensionUtil.getSubjectAlternativeNames(x509cert);
            for (Object altName : subjectAlternativeNames) {
                ArrayList oo;
                if (!(altName instanceof ArrayList) || (oo = (ArrayList)altName).size() <= 1) continue;
                int tag = (Integer)oo.get(0);
                String value = (String)oo.get(1);
                if (tag != 2) continue;
                return value;
            }
        }
        return null;
    }

    public static class UnableToLoadCACertsException
    extends Exception {
    }

    public static class CertificateSummary {
        public String issuer;
        public String subject;
        public String dateFrom;
        public String dateTo;

        public Message toMessage() {
            Message m = new Message();
            m.append(this.issuer);
            m.append(this.subject);
            m.append(this.dateFrom);
            m.append(this.dateTo);
            return m;
        }

        public void loadFrom(Message m) {
            this.issuer = m.getNextString();
            this.subject = m.getNextString();
            this.dateFrom = m.getNextString();
            this.dateTo = m.getNextString();
        }
    }

    public static class CertificateChainSummary {
        public ArrayList<CertificateSummary> certificates = new ArrayList();
        public boolean isSelfSigned = false;
        public boolean isChainValidate = true;
        public boolean contansUnknownCertificateTypes = false;
        public String validateError;

        public Message toMessage() {
            Message m = new Message();
            m.append(this.isSelfSigned);
            m.append(this.isChainValidate);
            m.append(this.contansUnknownCertificateTypes);
            m.append(this.validateError);
            m.append(this.certificates.size());
            for (CertificateSummary summary : this.certificates) {
                m.append(summary.toMessage());
            }
            return m;
        }

        public void loadFrom(Message m) {
            this.isSelfSigned = m.getNextBoolean();
            this.isChainValidate = m.getNextBoolean();
            this.contansUnknownCertificateTypes = m.getNextBoolean();
            this.validateError = m.getNextString();
            int size = m.getNextInt();
            for (int i = 0; i < size; ++i) {
                CertificateSummary summary = new CertificateSummary();
                summary.loadFrom(m.getNextMessage());
                this.certificates.add(summary);
            }
        }
    }

    public static class KeystoreValidationResult {
        public HashMap<String, CertificateChainSummary> aliasToChain = new HashMap();

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (String alias : this.aliasToChain.keySet()) {
                CertificateChainSummary certificateChainSummary = this.aliasToChain.get(alias);
                result.append("Alias: " + alias + "\t(validCertChain=" + certificateChainSummary.isChainValidate + ") (isSelfSigned=" + certificateChainSummary.isSelfSigned + ") (containsUnknownCerts=" + certificateChainSummary.contansUnknownCertificateTypes + ")\n");
                ArrayList<CertificateSummary> certs = certificateChainSummary.certificates;
                for (int i = 0; i < certs.size(); ++i) {
                    if (i > 0) {
                        result.append("\t  ||\n\t  \\/\n");
                    }
                    result.append("\tSubject: " + certs.get((int)i).subject).append("\n");
                    result.append("\tIssuer:  " + certs.get((int)i).issuer).append("\n");
                    result.append("\tValidity:" + certs.get((int)i).dateFrom + " -> " + certs.get((int)i).dateTo).append("\n");
                }
            }
            return result.toString();
        }

        public Message toMessage() {
            Set<String> keySet = this.aliasToChain.keySet();
            Message message = new Message();
            message.append(keySet.size());
            for (String alias : keySet) {
                message.append(alias);
                message.append(this.aliasToChain.get(alias).toMessage());
            }
            return message;
        }

        public void loadFrom(Message m) {
            this.aliasToChain.clear();
            int size = m.getNextInt();
            for (int i = 0; i < size; ++i) {
                String alias = m.getNextString();
                CertificateChainSummary summary = new CertificateChainSummary();
                summary.loadFrom(m.getNextMessage());
                this.aliasToChain.put(alias, summary);
            }
        }
    }
}

