/*
 * Decompiled with CFR 0.152.
 */
package utils.sound.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayQueue {
    private byte[] array;
    private int offset = 0;
    private int length = 0;
    private final Object QUEUE_LOCK = new Object();

    public ByteArrayQueue() {
        this(32);
    }

    public ByteArrayQueue(int capacity) {
        this.array = new byte[capacity];
    }

    public byte[] array() {
        return this.array;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.QUEUE_LOCK;
        synchronized (object) {
            this.offset = 0;
            this.length = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        Object object = this.QUEUE_LOCK;
        synchronized (object) {
            byte[] newArray = new byte[Math.max(capacity, this.length)];
            System.arraycopy(this.array, this.offset, newArray, 0, this.length);
            this.array = newArray;
            this.offset = 0;
        }
    }

    public void add(byte[] b) {
        this.add(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] b, int off, int len) {
        Object object = this.QUEUE_LOCK;
        synchronized (object) {
            int newLength = this.length + len;
            if (newLength > this.array.length) {
                this.setCapacity(Math.max(this.array.length << 1, newLength));
            } else if (this.offset + newLength > this.array.length) {
                System.arraycopy(this.array, this.offset, this.array, 0, this.length);
                this.offset = 0;
            }
            System.arraycopy(b, off, this.array, this.offset + this.length, len);
            this.length = newLength;
            this.QUEUE_LOCK.notify();
        }
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                ByteArrayQueue.this.add(b, off, len);
            }
        };
    }

    public void remove(byte[] b) {
        this.remove(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] b, int off, int len) {
        Object object = this.QUEUE_LOCK;
        synchronized (object) {
            System.arraycopy(this.array, this.offset, b, off, len);
            this.remove(len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int len) {
        Object object = this.QUEUE_LOCK;
        synchronized (object) {
            this.offset += len;
            this.length -= len;
            if (this.length == 0 && this.array.length > 1024) {
                this.array = new byte[32];
                this.offset = 0;
            }
        }
    }

    public InputStream getInputStream() {
        return new InputStream(){
            private int markedLength;
            private int markedOffset;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read() {
                Object object = ByteArrayQueue.this.QUEUE_LOCK;
                synchronized (object) {
                    byte[] b = new byte[1];
                    if (this.read(b, 0, 1) == -1) {
                        return -1;
                    }
                    return b[0] & 0xFF;
                }
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void reset() {
                Object object = ByteArrayQueue.this.QUEUE_LOCK;
                synchronized (object) {
                    ByteArrayQueue.this.offset = this.markedOffset;
                    ByteArrayQueue.this.length = this.markedLength;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void mark(int readlimit) {
                Object object = ByteArrayQueue.this.QUEUE_LOCK;
                synchronized (object) {
                    this.markedOffset = ByteArrayQueue.this.offset;
                    this.markedLength = ByteArrayQueue.this.length;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) {
                Object object = ByteArrayQueue.this.QUEUE_LOCK;
                synchronized (object) {
                    int bytesToRead = Math.min(len, ByteArrayQueue.this.length());
                    while (bytesToRead == 0) {
                        try {
                            ByteArrayQueue.this.QUEUE_LOCK.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        bytesToRead = Math.min(len, ByteArrayQueue.this.length());
                    }
                    ByteArrayQueue.this.remove(b, off, bytesToRead);
                    return bytesToRead;
                }
            }

            @Override
            public int available() throws IOException {
                return ByteArrayQueue.this.length();
            }
        };
    }

    public String toString() {
        return new String(this.array, this.offset, this.length);
    }

    public String toString(String charSet) throws UnsupportedEncodingException {
        return new String(this.array, this.offset, this.length, charSet);
    }
}

