/*
 * Decompiled with CFR 0.152.
 */
package utils.software.types.category;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import utils.message.Message;
import utils.software.types.AbstractApplication;
import utils.software.types.AbstractUpdate;
import utils.software.types.Application;
import utils.software.windows.WindowsHotFix;

public class SoftwareCategory<T extends Application> {
    public String title;
    private ArrayList<T> applications = new ArrayList();
    private ArrayList<SoftwareCategory<T>> childCategories = new ArrayList();
    private Class<T> persistentClass;
    private int recursiveApplicationCount = 0;

    public SoftwareCategory(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public void saveToMessage(Message m) {
        m.append(this.title);
        if (this.applications == null) {
            m.append(0);
        } else {
            m.append(this.applications.size());
            for (Application application : this.applications) {
                Message appMessage = application.toMessage();
                m.append(appMessage);
            }
        }
        if (this.childCategories == null) {
            m.append(0);
        } else {
            m.append(this.childCategories.size());
            for (SoftwareCategory softwareCategory : this.childCategories) {
                Message categoryMessage = new Message();
                softwareCategory.saveToMessage(categoryMessage);
                m.append(categoryMessage);
            }
        }
    }

    public void addApplication(T app) {
        this.applications.add(app);
        ++this.recursiveApplicationCount;
    }

    public ArrayList<T> getApplications() {
        return this.applications;
    }

    public void loadFromMessage(Message m, byte version) {
        int i;
        this.recursiveApplicationCount = 0;
        this.title = m.getNextString();
        int size = m.getNextInt();
        this.applications.clear();
        for (i = 0; i < size; ++i) {
            Message appMessage = m.getNextMessage();
            Application newApp = AbstractUpdate.class.isAssignableFrom(this.persistentClass) ? AbstractUpdate.fromMessage(appMessage, version) : (AbstractApplication.class.isAssignableFrom(this.persistentClass) ? AbstractApplication.fromMessage(appMessage, version) : WindowsHotFix.fromMessage(appMessage, version));
            this.applications.add(newApp);
        }
        this.recursiveApplicationCount += this.applications.size();
        size = m.getNextInt();
        this.childCategories.clear();
        for (i = 0; i < size; ++i) {
            Message categoryMessage = m.getNextMessage();
            SoftwareCategory<T> newCat = new SoftwareCategory<T>(this.persistentClass);
            newCat.loadFromMessage(categoryMessage, version);
            this.childCategories.add(newCat);
            this.recursiveApplicationCount += newCat.getRecursiveApplicationCount();
        }
    }

    public int getRecursiveApplicationCount() {
        return this.recursiveApplicationCount;
    }

    public void clear() {
        this.recursiveApplicationCount = 0;
        this.applications.clear();
        this.childCategories.clear();
    }

    public static class ApplicationsIterator<T extends Application>
    implements Iterable<T>,
    Iterator<T> {
        private LinkedList<SoftwareCategory<T>> queue = new LinkedList();
        private SoftwareCategory<T> current;
        private int currentIndex;

        public ApplicationsIterator(SoftwareCategory<T> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                ++this.currentIndex;
            }
            if (this.current == null || this.currentIndex >= this.current.getApplications().size()) {
                if (this.queue.size() == 0) {
                    return false;
                }
                this.current = this.queue.removeFirst();
                if (((SoftwareCategory)this.current).childCategories != null) {
                    for (int i = ((SoftwareCategory)this.current).childCategories.size() - 1; i >= 0; --i) {
                        this.queue.addFirst((SoftwareCategory<T>)((SoftwareCategory)this.current).childCategories.get(i));
                    }
                }
                if (((SoftwareCategory)this.current).applications == null || ((SoftwareCategory)this.current).applications.size() == 0) {
                    return this.hasNext();
                }
                this.currentIndex = 0;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.current == null || ((SoftwareCategory)this.current).applications == null) {
                return null;
            }
            return (T)((Application)((SoftwareCategory)this.current).applications.get(this.currentIndex));
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

