/*
 * Decompiled with CFR 0.152.
 */
package utils.software.types;

import utils.message.Message;
import utils.software.linux.LinuxApplication;
import utils.software.macos.OSXApplication;
import utils.software.types.Application;
import utils.software.windows.WindowsApplication;

public class AbstractApplication
implements Application {
    public String applicationName;
    public String appVersion;
    public String path;
    public String vendor;
    public String description;

    public void saveToMessage(Message m) {
        m.append(this.applicationName);
        m.append(this.appVersion);
        m.append(this.path);
        m.append(this.vendor);
        m.append(this.description);
    }

    public void loadFromMessage(Message m, byte version) {
        this.applicationName = m.getNextString();
        this.appVersion = m.getNextString();
        this.path = m.getNextString();
        this.vendor = m.getNextString();
        this.description = m.getNextString();
    }

    @Override
    public Message toMessage() {
        Message m = null;
        if (this instanceof WindowsApplication) {
            m = new Message(1);
        } else if (this instanceof OSXApplication) {
            m = new Message(2);
        } else if (this instanceof LinuxApplication) {
            m = new Message(3);
        }
        this.saveToMessage(m);
        return m;
    }

    public static AbstractApplication fromMessage(Message m, byte version) {
        int type = m.getType();
        AbstractApplication app = null;
        if (type == 1) {
            app = new WindowsApplication();
        } else if (type == 2) {
            app = new OSXApplication();
        } else if (type == 3) {
            app = new LinuxApplication();
        }
        ((AbstractApplication)app).loadFromMessage(m, version);
        return app;
    }
}

