/*
 * Decompiled with CFR 0.152.
 */
package utils.site.transact;

import java.io.IOException;
import utils.message.Message;
import utils.progtools.clock.TimingClock;
import utils.site.transact.SiteTransact;
import utils.site.transact.TrialExistsException;
import utils.string.Normaliser;

public class TrialServerUtil {
    public static int OK = 0;
    public static int FAIL = 1;
    public static int R_SERVER_EXISTS = 2;
    public static int R_WAITING = 3;
    public static int R_TRIAL_FINISHED = 4;
    public static int Q_CREATE = 1000;
    public static int Q_GETINFO = 2000;
    public static int Q_DELETE = 3000;
    public static String REGION_US_WEST = "SFO1";
    public static String REGION_US_EAST = "NYC1";
    public static String REGION_UK = "LON1";
    public static String REGION_EUROPE = "FRA1";
    public static String REGION_ASIA = "SGP1";
    static String trialServerPage = "https://simple-help.com/tservbeproc";
    String email;
    String fullname;
    String companyurl;
    String clientID;
    String myServerAuthCode;
    String myServerIP;
    String myServerPass;

    public String getEmail() {
        return this.email;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getCompany() {
        return this.companyurl;
    }

    public TrialServerUtil(String email, String fullname, String companyurl) {
        this.email = email;
        this.fullname = fullname;
        this.companyurl = companyurl;
        this.clientID = Normaliser.normaliseToCharsAndDigits((String)email, (boolean)true, (boolean)false).replace('_', '-');
    }

    private Message transactCheckOK(Message m) throws IOException {
        System.out.println("[TrialServerUtil] Requesting - " + m);
        m = SiteTransact.doTransaction(trialServerPage, m);
        System.out.println("[TrialServerUtil] Response - " + m);
        if (m.getType() == FAIL) {
            String fail = m.getNextString();
            if (fail != null && fail.startsWith("com.myjeeva.digitalocean.exception.DigitalOceanException: ")) {
                String[] lines = fail.split("\n");
                fail = lines[0];
                fail = fail.substring("com.myjeeva.digitalocean.exception.DigitalOceanException: ".length());
                fail = "DO Error: " + fail;
            }
            throw new IOException(fail);
        }
        return m;
    }

    public String getServerIP() {
        return this.myServerIP;
    }

    public String getServerRootPass() {
        return this.myServerPass;
    }

    public boolean getTrialServerInfo(long mswait) throws IOException {
        Message m = new Message(Q_GETINFO);
        m.append(this.clientID);
        m.append(this.myServerAuthCode);
        System.out.println("[TrialServerUtil] Requesting server details for " + this.myServerAuthCode);
        Message ret = this.transactCheckOK(m);
        long timeout = TimingClock.currentTimeMillis() + mswait;
        while (ret.getType() == R_WAITING) {
            if (TimingClock.currentTimeMillis() > timeout) {
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            ret = this.transactCheckOK(m);
        }
        System.out.println("[TrialServerUtil] Server creds response: " + ret);
        this.myServerIP = ret.getNextString();
        this.myServerPass = ret.getNextString();
        return true;
    }

    public String recreateTrialServer(String region) throws IOException {
        System.out.println("[TrialServerUtil] Server exists already? will clear and re-request");
        Message m = new Message(Q_DELETE);
        m.append(this.clientID);
        System.out.println("[TrialServerUtil] Requesting delete...");
        m = this.transactCheckOK(m);
        System.out.println("[TrialServerUtil] Requesting re-creation...");
        long T = System.currentTimeMillis() + 300000L;
        while (System.currentTimeMillis() < T) {
            try {
                return this.requestNewTrialServer(region);
            }
            catch (TrialExistsException x) {
                try {
                    Thread.sleep(2500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("[TrialServerUtil] Server not deleted yet, requesting re-creation...");
            }
        }
        throw new IOException("Timed out recreating trial server");
    }

    public String requestNewTrialServer(String region) throws IOException, TrialExistsException {
        Message mcreate = new Message(Q_CREATE);
        mcreate.append(this.clientID);
        mcreate.append(region);
        mcreate.append(this.email);
        mcreate.append(this.fullname);
        mcreate.append(this.companyurl);
        System.out.println("[TrialServerUtil] Requesting new trial server for client:" + this.clientID + ", region:" + region);
        System.out.println("[TrialServerUtil] Email: " + this.email);
        System.out.println("[TrialServerUtil] Full name: " + this.fullname);
        System.out.println("[TrialServerUtil] Company URL: " + this.companyurl);
        Message m = this.transactCheckOK(mcreate);
        if (m.getType() == R_SERVER_EXISTS) {
            throw new TrialExistsException();
        }
        System.out.println("[TrialServerUtil] Server created OK");
        this.myServerAuthCode = m.getNextString();
        if (m.hasNext()) {
            return m.getNextString();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
    }
}

