/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.streams;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int mWritten;

    public LittleEndianDataOutputStream(OutputStream pStream) {
        super(pStream);
    }

    @Override
    public synchronized void write(int pByte) throws IOException {
        this.out.write(pByte);
        ++this.mWritten;
    }

    @Override
    public synchronized void write(byte[] pBytes, int pOffset, int pLength) throws IOException {
        this.out.write(pBytes, pOffset, pLength);
        this.mWritten += pLength;
    }

    @Override
    public void writeBoolean(boolean pBoolean) throws IOException {
        if (pBoolean) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int pByte) throws IOException {
        this.write(pByte);
    }

    @Override
    public void writeShort(int pShort) throws IOException {
        this.out.write(pShort & 0xFF);
        this.out.write(pShort >>> 8 & 0xFF);
        this.mWritten += 2;
    }

    @Override
    public void writeChar(int pChar) throws IOException {
        this.out.write(pChar & 0xFF);
        this.out.write(pChar >>> 8 & 0xFF);
        this.mWritten += 2;
    }

    @Override
    public void writeInt(int pInt) throws IOException {
        this.out.write(pInt & 0xFF);
        this.out.write(pInt >>> 8 & 0xFF);
        this.out.write(pInt >>> 16 & 0xFF);
        this.out.write(pInt >>> 24 & 0xFF);
        this.mWritten += 4;
    }

    @Override
    public void writeLong(long pLong) throws IOException {
        this.out.write((int)pLong & 0xFF);
        this.out.write((int)(pLong >>> 8) & 0xFF);
        this.out.write((int)(pLong >>> 16) & 0xFF);
        this.out.write((int)(pLong >>> 24) & 0xFF);
        this.out.write((int)(pLong >>> 32) & 0xFF);
        this.out.write((int)(pLong >>> 40) & 0xFF);
        this.out.write((int)(pLong >>> 48) & 0xFF);
        this.out.write((int)(pLong >>> 56) & 0xFF);
        this.mWritten += 8;
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String pString) throws IOException {
        int length = pString.length();
        for (int i = 0; i < length; ++i) {
            this.writeByte((byte)pString.charAt(i));
        }
        this.mWritten += length;
    }

    @Override
    public void writeChars(String pString) throws IOException {
        int length = pString.length();
        for (int i = 0; i < length; ++i) {
            this.writeChar(pString.charAt(i));
        }
        this.mWritten += length * 2;
    }

    @Override
    public void writeUTF(String pString) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.mWritten;
    }
}

