/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.collections;

import java.util.LinkedList;

public class MaxAgeLinkedList<T> {
    private LinkedList<TimeWrapper> list = new LinkedList();
    private long maxAgeMS;

    public MaxAgeLinkedList(long maxAgeMS) {
        this.maxAgeMS = maxAgeMS;
    }

    private synchronized void trimList() {
        long time = System.currentTimeMillis();
        while (this.list.size() > 0 && time - this.list.peek().time > this.maxAgeMS) {
            this.list.removeFirst();
        }
    }

    public synchronized void put(T t) {
        TimeWrapper wrapper = new TimeWrapper(t);
        this.list.add(wrapper);
    }

    public synchronized T pop() {
        this.trimList();
        if (this.list.size() == 0) {
            return null;
        }
        return this.list.removeFirst().element;
    }

    public synchronized int size() {
        this.trimList();
        return this.list.size();
    }

    public synchronized boolean isEmpty() {
        this.trimList();
        return this.list.isEmpty();
    }

    public synchronized T peek() {
        this.trimList();
        if (this.list.size() == 0) {
            return null;
        }
        return this.list.peek().element;
    }

    public synchronized boolean contains(T t) {
        this.trimList();
        for (TimeWrapper wrapper : this.list) {
            if (!wrapper.element.equals(t)) continue;
            return true;
        }
        return false;
    }

    class TimeWrapper {
        long time;
        T element;

        public TimeWrapper(T element) {
            this.element = element;
            this.time = System.currentTimeMillis();
        }
    }
}

