/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.buffers;

public class CircularByteBuffer {
    private byte[] elements;
    private int size = 0;
    private int first = 0;
    private int last = 0;
    private final Object LOCK = new Object();
    private boolean blockRead;
    private boolean blockWrite;

    public CircularByteBuffer(int capacity, boolean blockRead, boolean blockWrite) {
        this.elements = new byte[capacity];
        this.blockRead = blockRead;
        this.blockWrite = blockWrite;
    }

    public CircularByteBuffer(int capacity) {
        this(capacity, true, true);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int freeSpace() {
        return this.elements.length - this.size;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(byte b) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.blockWrite) {
                while (this.freeSpace() == 0) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.elements[this.last] = b;
            this.last = (this.last + 1) % this.elements.length;
            ++this.size;
            this.LOCK.notifyAll();
        }
    }

    public void push(byte[] data) {
        this.push(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(byte[] data, int offset, int length) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.blockWrite) {
                while (this.freeSpace() < length) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            int bytesTillEndOfBuffer = this.elements.length - this.last;
            int firstPart = Math.min(length, bytesTillEndOfBuffer);
            int remainderPart = length - firstPart;
            System.arraycopy(data, offset, this.elements, this.last, firstPart);
            this.last = (this.last + firstPart) % this.elements.length;
            this.size += firstPart;
            if (remainderPart > 0) {
                System.arraycopy(data, offset + firstPart, this.elements, this.last, remainderPart);
                this.last = (this.last + remainderPart) % this.elements.length;
                this.size += remainderPart;
            }
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.blockRead) {
                while (this.isEmpty()) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            byte item = this.elements[this.first];
            --this.size;
            this.first = (this.first + 1) % this.elements.length;
            this.LOCK.notifyAll();
            return 0xFF & item;
        }
    }

    public int pop(byte[] buffer) {
        return this.pop(buffer, 0, buffer.length);
    }

    public int popFillBuffer(byte[] buffer, int offset, int length) {
        return this.pop(buffer, offset, length, true);
    }

    public int pop(byte[] buffer, int offset, int length) {
        return this.pop(buffer, offset, length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pop(byte[] buffer, int offset, int length, boolean fillBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.blockRead) {
                if (fillBuffer) {
                    while (this.size < length) {
                        try {
                            this.LOCK.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    while (this.isEmpty()) {
                        try {
                            this.LOCK.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            int requiredBytes = Math.min(this.size, length);
            int firstPart = Math.min(this.elements.length - this.first, requiredBytes);
            int secondPart = Math.max(0, requiredBytes - firstPart);
            System.arraycopy(this.elements, this.first, buffer, offset, firstPart);
            this.size -= firstPart;
            this.first = (this.first + firstPart) % this.elements.length;
            System.arraycopy(this.elements, this.first, buffer, offset + firstPart, secondPart);
            this.size -= secondPart;
            this.first = (this.first + secondPart) % this.elements.length;
            this.LOCK.notifyAll();
            return requiredBytes;
        }
    }

    public byte[] getEntireBuffer() {
        if (this.first < this.last) {
            byte[] result = new byte[this.size];
            System.arraycopy(this.elements, this.first, result, 0, this.last - this.first);
            return result;
        }
        byte[] result = new byte[this.size];
        System.arraycopy(this.elements, this.first, result, 0, this.elements.length - this.first);
        System.arraycopy(this.elements, 0, result, this.elements.length - this.first, this.last);
        return result;
    }
}

