/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class SingleThreadNotifier {
    private static ArrayList<ScheduledTask> tasks = new ArrayList();
    private static SchedulerThread schedulerThread;

    public static void runMe(Runnable thingToRun, int delayMS, boolean repeat) {
        SingleThreadNotifier.runMe(thingToRun, delayMS, repeat, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runMe(Runnable thingToRun, int delayMS, boolean repeat, boolean onSwingThread) {
        ScheduledTask task = new ScheduledTask();
        task.thingToRun = thingToRun;
        task.delayMS = delayMS;
        task.onSwingThread = onSwingThread;
        task.repeat = repeat;
        task.nextFireTime = System.currentTimeMillis() + (long)delayMS;
        ArrayList<ScheduledTask> arrayList = tasks;
        synchronized (arrayList) {
            tasks.add(task);
            if (schedulerThread == null) {
                schedulerThread = new SchedulerThread();
                schedulerThread.start();
            } else {
                tasks.notify();
            }
        }
    }

    static class SchedulerThread
    extends Thread {
        SchedulerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ArrayList arrayList = tasks;
            synchronized (arrayList) {
                while (tasks.size() > 0) {
                    long minSleep = -1L;
                    for (int i = tasks.size() - 1; i >= 0; --i) {
                        ScheduledTask task = (ScheduledTask)tasks.get(i);
                        long timeTillFire = task.nextFireTime - System.currentTimeMillis();
                        if (timeTillFire <= 0L) {
                            if (task.onSwingThread) {
                                SwingUtilities.invokeLater(task.thingToRun);
                            } else {
                                task.thingToRun.run();
                            }
                            if (task.repeat) {
                                task.nextFireTime = System.currentTimeMillis() + (long)task.delayMS;
                                if (minSleep == -1L) {
                                    minSleep = task.delayMS;
                                    continue;
                                }
                                minSleep = Math.min((long)task.delayMS, minSleep);
                                continue;
                            }
                            tasks.remove(i);
                            continue;
                        }
                        minSleep = minSleep == -1L ? timeTillFire : Math.min(timeTillFire, minSleep);
                    }
                    if (minSleep == -1L || tasks.size() == 0) {
                        schedulerThread = null;
                        return;
                    }
                    try {
                        tasks.wait(minSleep);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
        }
    }

    static class ScheduledTask {
        public boolean onSwingThread;
        public long nextFireTime;
        public Runnable thingToRun;
        public int delayMS;
        public boolean repeat;

        ScheduledTask() {
        }
    }
}

