/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.IOException;

public class ExceptionNameStripper {
    public static String toString(Throwable t) {
        String s = "" + t;
        try {
            String cn = t.getClass().getName();
            int index = cn.lastIndexOf(46);
            s = s.substring(index + 1);
            return s;
        }
        catch (Exception x) {
            x.printStackTrace();
            return s;
        }
    }

    public static String toFriendly(Throwable t) {
        try {
            String cn = t.getClass().getName();
            int index = cn.lastIndexOf(46);
            cn = cn.substring(index + 1);
            if (cn.endsWith("Exception")) {
                cn.substring(0, cn.length() - "Exception".length());
            }
            if (t instanceof NullPointerException) {
                cn = "NPE";
            }
            if (t instanceof IOException) {
                cn = "IO";
            }
            if (t instanceof StringIndexOutOfBoundsException) {
                cn = "StringBounds";
            }
            if (t instanceof ArrayIndexOutOfBoundsException) {
                cn = "ArrayBounds";
            }
            if (t.getMessage() == null) {
                return cn;
            }
            return cn + " / " + t.getMessage();
        }
        catch (Exception x) {
            x.printStackTrace();
            return "" + t;
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            throw new IOException("WOOT");
        }
        catch (Throwable t) {
            System.out.println(ExceptionNameStripper.toString(t));
            return;
        }
    }
}

