/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.types;

import utils.message.Message;

public class SessionInfo {
    public String machineTitle;
    public String hostname;
    public String username;
    public String osNameWithBitness = "Unknown";
    public String wanip;
    public String[] localip = new String[0];

    public Message toMessage() {
        Message m = new Message();
        m.append(this.machineTitle);
        m.append(this.hostname);
        m.append(this.username);
        m.append(this.osNameWithBitness);
        m.append(this.localip.length);
        for (String s : this.localip) {
            m.append(s);
        }
        m.append(this.wanip);
        return m;
    }

    public static SessionInfo fromMessage(Message m) {
        SessionInfo result = new SessionInfo();
        result.machineTitle = m.getNextString();
        result.hostname = m.getNextString();
        result.username = m.getNextString();
        result.osNameWithBitness = m.getNextString();
        result.localip = new String[m.getNextInt()];
        for (int i = 0; i < result.localip.length; ++i) {
            result.localip[i] = m.getNextString();
        }
        result.wanip = m.getNextString();
        return result;
    }
}

