/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.ip;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.stream.StreamUtils;
import utils.string.CharStack;

public class IpStats {
    public static String[] getIpMacPairs() throws IOException {
        ArrayList<String> pairs = new ArrayList<String>();
        if (OS.isWindows()) {
            String output = IpStats.runCommand(new String[]{"ipconfig", "/all"});
            CharStack cs = new CharStack(output);
            String line = cs.popLine(true);
            String ip = null;
            String mac = null;
            String adapter = null;
            boolean last = false;
            while (!cs.isEmpty() || last) {
                CharStack csline = new CharStack(line);
                if (!line.startsWith("\t") && !line.startsWith(" ") || last) {
                    if (ip != null || mac != null) {
                        if (ip == null) {
                            ip = "";
                        }
                        if (mac == null) {
                            mac = "";
                        }
                        if (adapter == null) {
                            adapter = "";
                        }
                        mac = mac.replace('-', ':');
                        if (!ip.startsWith("127.")) {
                            pairs.add(ip + "/" + mac + "/" + adapter);
                        }
                        ip = null;
                        mac = null;
                        adapter = null;
                    }
                    if (last) break;
                    if (line.trim().length() > 0) {
                        adapter = csline.popUntil(':', true);
                    }
                } else {
                    csline.popWhitespace();
                    String name = csline.popUntil(new String[]{":", "."}, true).toLowerCase();
                    if (name.startsWith("ipv4") || name.startsWith("ip address")) {
                        csline.popUntil(':', false);
                        csline.popWhitespace();
                        ip = csline.popJavaFullClassname(true);
                    }
                    if (name.startsWith("physical")) {
                        csline.popUntil(':', false);
                        csline.popWhitespace();
                        mac = csline.popText(true);
                    }
                }
                line = cs.popLine(true);
                if (!cs.isEmpty()) continue;
                last = true;
            }
        } else if (OS.isLinux()) {
            String output = IpStats.runCommand(new String[]{"ifconfig"});
            IpStats.processLinux(output, pairs);
        } else {
            String output = IpStats.runCommand(new String[]{"ifconfig"});
            CharStack cs = new CharStack(output);
            String line = cs.popLine(true);
            String ip = null;
            String mac = null;
            String adapter = null;
            boolean last = false;
            while (!cs.isEmpty() || last) {
                CharStack csline = new CharStack(line);
                if (!line.startsWith("\t") || last) {
                    if (ip != null || mac != null) {
                        if (ip == null) {
                            ip = "";
                        }
                        if (mac == null) {
                            mac = "";
                        }
                        if (adapter == null) {
                            adapter = "";
                        }
                        mac = mac.replace('-', ':');
                        if (!ip.startsWith("127.") && ip.length() > 0) {
                            pairs.add(ip + "/" + mac + "/" + adapter);
                        }
                        ip = null;
                        mac = null;
                        adapter = null;
                    }
                    if (last) break;
                    if (line.trim().length() > 0) {
                        adapter = csline.popUntil(':', true);
                    }
                } else {
                    csline.popWhitespace();
                    String name = csline.popJavaFullClassname(true);
                    if (name.equalsIgnoreCase("ether")) {
                        csline.popWhitespace();
                        mac = csline.popText(true);
                    }
                    if (name.equalsIgnoreCase("inet")) {
                        csline.popWhitespace();
                        ip = csline.popJavaFullClassname(true);
                    }
                }
                line = cs.popLine(true);
                if (!cs.isEmpty()) continue;
                last = true;
            }
        }
        return pairs.toArray(new String[0]);
    }

    private static void processLinux(String output, ArrayList<String> pairs) {
        String[] lines = output.split("\n");
        String name = "";
        String mac = "";
        String ip = "";
        for (String line : lines) {
            int start = 0;
            String[] values = line.split("\\s+");
            if (!line.startsWith("\t") && !line.startsWith(" ")) {
                if (name.length() > 0) {
                    mac = mac.replace('-', ':');
                    if (!ip.startsWith("127.") && ip.length() > 0) {
                        pairs.add(ip + "/" + mac + "/" + name);
                        ip = "";
                        mac = "";
                    }
                }
                name = values[0];
                start = 1;
            }
            boolean containsAddr = line.contains("addr:");
            boolean startsWithEther = line.trim().startsWith("ether ");
            while (start < values.length) {
                String value = values[start].toLowerCase();
                String nextValue = null;
                if (start + 1 < values.length) {
                    nextValue = values[start + 1];
                }
                if (value.startsWith("hwaddr")) {
                    mac = values[++start];
                } else if (!containsAddr && value.equals("inet")) {
                    ip = values[++start];
                } else if (startsWithEther && value.equals("ether")) {
                    mac = values[++start];
                } else if (nextValue != null && value.equalsIgnoreCase("inet") && nextValue.startsWith("addr:") && containsAddr) {
                    ++start;
                    int colon = nextValue.indexOf(58);
                    ip = nextValue.substring(colon + 1);
                    ++start;
                }
                ++start;
            }
        }
        if (name != null) {
            mac = mac.replace('-', ':');
            if (!ip.startsWith("127.") && ip.length() > 0) {
                pairs.add(ip + "/" + mac + "/" + name);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> pairs = new ArrayList<String>();
        String output = FileUtil.readFileAsString((String)"/Users/gchristelis/Downloads/out.txt");
        IpStats.processLinux(output, pairs);
        for (String s : pairs) {
            System.out.println(s);
        }
    }

    private static String runCommand(String[] command) throws IOException {
        Process proc = Runtime.getRuntime().exec(command);
        new Ignore(proc.getErrorStream());
        return new String(StreamUtils.readAll((InputStream)proc.getInputStream()));
    }

    static class Ignore
    extends Thread {
        InputStream in;

        public Ignore(InputStream in) {
            this.in = in;
            this.start();
        }

        @Override
        public void run() {
            try {
                int n = this.in.read();
                while (n != -1) {
                    System.err.print((char)n);
                    n = this.in.read();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

