/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats;

import java.util.Iterator;
import java.util.Random;
import utils.progtools.collections.FixedSizeLinkedList;
import utils.progtools.collections.ListReverser;

public class LoadAverageUtil {
    private FixedSizeLinkedList<AverageBucket> buckets;
    private long bucketSize;
    private int max;
    private final Object LOCK = new Object();

    public LoadAverageUtil() {
        this(60000, 15);
    }

    public LoadAverageUtil(int bucketSize, int max) {
        this.bucketSize = bucketSize;
        this.max = max;
        this.buckets = new FixedSizeLinkedList(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSample(long time, double value) {
        Object object = this.LOCK;
        synchronized (object) {
            this.removeOldBuckets(time);
            this.addNewBuckets(time);
            ((AverageBucket)this.buckets.peekLast()).add(time, value);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        LoadAverageUtil util = new LoadAverageUtil(1000, 15);
        Thread.sleep(10000L);
        new ThreadTest(util).start();
        new ThreadTest(util).start();
    }

    public byte getAverage1Byte() {
        return (byte)this.getAverage1();
    }

    public byte getAverage5Byte() {
        return (byte)this.getAverage5();
    }

    public byte getAverage15Byte() {
        return (byte)this.getAverage15();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage1() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.buckets.isEmpty()) {
                return -1.0;
            }
            return this.getAverageN(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage5() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.buckets.isEmpty()) {
                return -1.0;
            }
            return this.getAverageN(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage15() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.buckets.isEmpty()) {
                return -1.0;
            }
            return this.getAverageN(15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getAverageN(int N) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.buckets.isEmpty()) {
                return -1.0;
            }
            double total = 0.0;
            int count = 0;
            Iterator it = new ListReverser(this.buckets.getList()).iterator();
            while (it.hasNext() && N > 0) {
                AverageBucket bucket = (AverageBucket)it.next();
                if (bucket.count > 0) {
                    total += bucket.getAverage();
                    ++count;
                }
                --N;
            }
            return total / (double)count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getAverage1() + " " + this.getAverage5() + " " + this.getAverage15();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewBuckets(long time) {
        Object object = this.LOCK;
        synchronized (object) {
            long bucketTime = time - time % this.bucketSize;
            while (this.buckets.size() < this.max) {
                AverageBucket bucket;
                if (this.buckets.size() == 0) {
                    bucket = new AverageBucket();
                    bucket.startTime = bucketTime - this.bucketSize * (long)(this.max - 1);
                    this.buckets.put((Object)bucket);
                    continue;
                }
                bucket = (AverageBucket)this.buckets.peekLast();
                AverageBucket newBucket = new AverageBucket();
                newBucket.startTime = bucket.startTime + this.bucketSize;
                this.buckets.put((Object)newBucket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldBuckets(long time) {
        Object object = this.LOCK;
        synchronized (object) {
            while (this.buckets.size() > 0 && time - ((AverageBucket)this.buckets.peek()).startTime >= (long)this.max * this.bucketSize) {
                this.buckets.pop();
            }
        }
    }

    private class AverageBucket {
        double total;
        int count;
        long startTime;

        private AverageBucket() {
        }

        public boolean timeInBucket(long time) {
            return this.startTime <= time && time < this.startTime + LoadAverageUtil.this.bucketSize;
        }

        public void add(long time, double value) {
            if (!this.timeInBucket(time)) {
                throw new RuntimeException();
            }
            this.total += value;
            ++this.count;
        }

        public String toString() {
            double avg = 0.0;
            if (this.count > 0) {
                avg = this.total / (double)this.count;
            }
            return "start: " + this.startTime + " avg:" + avg + " total:" + this.total + " count:" + this.count;
        }

        public double getAverage() {
            if (this.count == 0) {
                return 0.0;
            }
            return this.total / (double)this.count;
        }
    }

    static class ThreadTest
    extends Thread {
        private final LoadAverageUtil util;

        public ThreadTest(LoadAverageUtil util) {
            this.util = util;
        }

        @Override
        public void run() {
            Random r = new Random();
            while (true) {
                try {
                    Thread.sleep(r.nextInt(100));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.util.addSample(System.currentTimeMillis(), System.currentTimeMillis());
                System.out.println(this.util);
            }
        }
    }
}

