/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.MTTransactionServer;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.MessageWriter;
import utils.message.SinglesListener;
import utils.message.TrackingBoutPool;
import utils.message.TransactionListener;
import utils.message.TransactionServerListener;
import utils.progtools.BufferPool;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.StackTracer;
import utils.stream.ByteArrayPool;
import utils.stream.OpenBoutPool;

public class BasicMTTransactionServer
extends Thread
implements MTTransactionServer {
    public static final boolean DEBUG = false;
    InputStream min;
    MessageWriter mout;
    SinglesListener ml;
    TransactionListener tl;
    TransactionServerListener sl;
    Object mout_LOCK = new Object();
    OnDemandThreadPool tp;
    boolean discardWhenFull = false;
    boolean autoHandleExceptions = false;
    boolean shutdown = false;
    BufferPool bpool;
    OpenBoutPool pool;

    public void setAutoHandleExceptions(boolean b) {
        this.autoHandleExceptions = b;
    }

    public BasicMTTransactionServer(InputStream bin, OutputStream bout, TransactionListener tl, int maxThreads, int maxBuffered, boolean discardWhenFull) {
        this.min = new BufferedInputStream(bin);
        this.mout = new MessageWriter(bout);
        this.tl = tl;
        this.discardWhenFull = discardWhenFull;
        this.tp = new OnDemandThreadPool("BasicMTTransactionServerTransaction", maxThreads, maxBuffered, 5);
        this.start();
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void useHighPerformanceBytePoolAndByteArrayRefs(OpenBoutPool pool, BufferPool bpool) {
        this.pool = pool;
        this.bpool = bpool;
    }

    public void setSingleMessageListener(SinglesListener listener) {
        this.ml = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block7: while (true) {
                if (this.shutdown != false) return;
                tracking = null;
                if (this.pool != null) {
                    tracking = new TrackingBoutPool(this.pool, this.bpool);
                    m = MessageUtils.readMessageHighPerformance((InputStream)this.min, (ByteArrayPool)tracking);
                } else {
                    m = MessageUtils.readMessage((InputStream)this.min);
                }
                if (this.shutdown) continue;
                while (true) {
                    if (!this.tp.runAsync((Runnable)new MessageHandler(m, tracking)) && !this.discardWhenFull) ** break;
                    continue block7;
                    try {
                        Thread.sleep(150L);
                    }
                    catch (Throwable var3_4) {}
                }
                break;
            }
            catch (IOException e) {
                // empty catch block
                return;
            }
        }
        finally {
            if (this.sl != null) {
                this.sl.serverEnding(this, this.tl);
            }
        }
    }

    public void addServerListener(TransactionServerListener listener) {
        this.sl = listener;
    }

    class MessageHandler
    implements Runnable {
        Message m;
        TrackingBoutPool tracking;

        public MessageHandler(Message m, TrackingBoutPool tracking) {
            this.m = m;
            this.tracking = tracking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                try {
                    if (this.m.getType() == -1289964772) {
                        Message incoming = this.m.getNextMessage();
                        this.m = null;
                        if (BasicMTTransactionServer.this.ml != null) {
                            BasicMTTransactionServer.this.ml.doMessage(incoming);
                        }
                        break block20;
                    }
                    if (this.m.getType() == -1524849380) {
                        Integer conv = this.m.getNextInt();
                        Message incoming = this.m.getNextMessage();
                        this.m = null;
                        Message resp = null;
                        Throwable error = null;
                        if (BasicMTTransactionServer.this.autoHandleExceptions) {
                            try {
                                resp = BasicMTTransactionServer.this.tl.doTransaction(incoming);
                            }
                            catch (Throwable t) {
                                error = t;
                            }
                        } else {
                            resp = BasicMTTransactionServer.this.tl.doTransaction(incoming);
                        }
                        try {
                            Message wrap;
                            if (error != null) {
                                wrap = new Message(-1173209);
                                wrap.append(conv);
                                wrap.append("" + error);
                                wrap.append(StackTracer.getStacktrace((Throwable)error) + "\tat (MMTransactionClient vvv <-> ^^^ MTTransactionServer)");
                            } else {
                                wrap = new Message(-1524849380);
                                wrap.append(conv);
                                wrap.append(resp);
                            }
                            incoming = null;
                            Object object = BasicMTTransactionServer.this.mout_LOCK;
                            synchronized (object) {
                                BasicMTTransactionServer.this.mout.write(wrap);
                                break block20;
                            }
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                        break block20;
                    }
                    System.out.println("[BasicMTTransactionServer] Unexpected message type " + this.m.getType());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                finally {
                    if (this.tracking != null) {
                        this.tracking.deallocateAll();
                    }
                }
            }
        }
    }
}

