/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import utils.loggingframework.events.EventRepository;
import utils.loggingframework.events.LogEvent;
import utils.swing.components.SHJTable;
import utils.swing.components.TitledListView;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.renderers.BackgroundColorCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class SelectEventTable {
    private JComponent component;
    private JTable[] tables;
    private ArrayList<SimpleList<LogEventWrapper>> eventWrapperLists = new ArrayList();
    private String[] groupTitles;
    private RemoveSelectionFocusListener removeSelectionFocusListener = new RemoveSelectionFocusListener();
    private BackgroundBooleanRenderer booleanRenderer;

    public SelectEventTable() {
        this.initList();
        this.initUI();
    }

    public void addMouseListener(MouseListener listener) {
        for (JTable table : this.tables) {
            table.addMouseListener(listener);
        }
    }

    private void initList() {
        this.groupTitles = EventRepository.INSTANCE.getGroupTitles();
        this.eventWrapperLists = new ArrayList();
        for (String title : this.groupTitles) {
            LogEvent[] events;
            SimpleList<LogEventWrapper> eventWrapperList = new SimpleList<LogEventWrapper>();
            for (LogEvent event : events = EventRepository.INSTANCE.getEventInstances(title)) {
                LogEventWrapper wrapper = new LogEventWrapper(event);
                eventWrapperList.add(wrapper);
            }
            this.eventWrapperLists.add(eventWrapperList);
        }
    }

    public JComponent getScrollPaneComponent() {
        return this.component;
    }

    private JTable createTableComponentForGroup(SimpleList eventWrapperList) {
        TableStructure ts = TableStructure.createTableStructure(LogEventWrapper.class, new String[]{"isChecked", "event"}, new String[]{"", ""}, new int[]{0, -1}, new boolean[]{true, false});
        ts.setMaxWidths(new int[]{SimpleHelpLookAndFeel.scale((int)40), -1});
        ts.setMinWidths(new int[]{SimpleHelpLookAndFeel.scale((int)40), -1});
        SimpleTableModel slm = new SimpleTableModel(eventWrapperList, ts);
        SHJTable table = new SHJTable(0, ts.getColumnCount());
        table.setTableHeader(null);
        if (table.getRowHeight() < SimpleHelpLookAndFeel.scale((int)26)) {
            table.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        }
        this.booleanRenderer = new BackgroundBooleanRenderer(table.getDefaultRenderer(Boolean.class));
        table.setDefaultRenderer(Boolean.class, this.booleanRenderer);
        table.setModel(slm);
        table.setSelectionMode(0);
        table.setBorder(SHBorderFactory.createMatteBorder((int)1, (int)0, (int)1, (int)0, (Color)UIManager.getColor("controlShadow")));
        ts.initTableDimensions(table);
        table.addFocusListener(this.removeSelectionFocusListener);
        table.setFocusable(false);
        table.setCellSelectionEnabled(false);
        return table;
    }

    public void initUI() {
        TitledListView.ListItem[] listItems = new TitledListView.ListItem[this.eventWrapperLists.size()];
        this.tables = new JTable[this.eventWrapperLists.size()];
        for (int i = 0; i < listItems.length; ++i) {
            this.tables[i] = this.createTableComponentForGroup(this.eventWrapperLists.get(i));
            listItems[i] = new TitledListView.ListItem(this.groupTitles[i], this.tables[i]);
        }
        TitledListView tlv = new TitledListView(listItems){

            @Override
            protected JComponent getTitleComponentFor(TitledListView.ListItem item) {
                JLabel label = new JLabel("  " + item.groupTitle);
                label.setFont(SHStyle.largeFont);
                label.setOpaque(true);
                label.setBorder(SHBorderFactory.createEmptyBorder((int)15, (int)0, (int)5, (int)0));
                return label;
            }
        };
        this.component = new JScrollPane(tlv.getRootComponent());
    }

    public LogEvent[] getSelectedEventInstances() {
        ArrayList<LogEvent> result = new ArrayList<LogEvent>();
        for (SimpleList<LogEventWrapper> eventWrapperList : this.eventWrapperLists) {
            for (LogEventWrapper wrapper : eventWrapperList) {
                if (!wrapper.isChecked) continue;
                result.add(wrapper.event);
            }
        }
        return result.toArray(new LogEvent[0]);
    }

    public String[] getSelectedEventIDs() {
        ArrayList<String> result = new ArrayList<String>();
        for (LogEvent event : this.getSelectedEventInstances()) {
            result.add(event.getID());
        }
        return result.toArray(new String[0]);
    }

    private void selectEvent(String id) {
        for (SimpleList<LogEventWrapper> eventWrapperList : this.eventWrapperLists) {
            for (LogEventWrapper wrapper : eventWrapperList) {
                if (!wrapper.event.getID().equals(id)) continue;
                wrapper.isChecked = true;
                return;
            }
        }
    }

    private void deselectAll() {
        for (SimpleList<LogEventWrapper> eventWrapperList : this.eventWrapperLists) {
            for (LogEventWrapper wrapper : eventWrapperList) {
                wrapper.isChecked = false;
            }
        }
    }

    public void setSelectedEvents(String[] logEventIDs) {
        this.deselectAll();
        if (logEventIDs != null) {
            for (String logID : logEventIDs) {
                this.selectEvent(logID);
            }
        }
    }

    class BackgroundBooleanRenderer
    extends BackgroundColorCellRendererWrapper {
        public BackgroundBooleanRenderer(TableCellRenderer defaultRenderer) {
            super(defaultRenderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row % 2 != 0) {
                this.setBackgroundColor(UIManager.getColor("Table.alternateRowColor"));
            } else {
                this.setBackgroundColor(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class RemoveSelectionFocusListener
    implements FocusListener {
        RemoveSelectionFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTable table = (JTable)e.getSource();
            table.getSelectionModel().clearSelection();
        }
    }

    class LogEventWrapper {
        boolean isChecked = false;
        LogEvent event;

        public LogEventWrapper(LogEvent event) {
            this.event = event;
        }
    }
}

