/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import utils.loggingframework.logmapping.LogMapping;
import utils.loggingframework.ui.LoggingIcons;
import utils.loggingframework.ui.repository.LogWizardGlassDialog;
import utils.swing.SwingStyleInterface;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;

public class LogMappingRepositoryUI
implements ListSelectionListener,
ActionListener {
    private GbPanel rootComponent = new GbPanel();
    private SimpleList mappingList;
    private SortWrapper sortedMappingList;
    private ResourceBundle bundle;
    private SHJTable mappingTable;
    private JScrollPane regpane;
    private JButton bnew;
    private JButton bdelete;
    private JButton bedit;
    private SwingStyleInterface style;
    private LogMappingsChangedListener listener;

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public LogMappingRepositoryUI(ResourceBundle bundle, LogMapping[] logMappings, SwingStyleInterface style, LogMappingsChangedListener listener) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.style = style;
        this.listener = listener;
        this.mappingList = new SimpleList();
        if (logMappings != null) {
            for (int i = 0; i < logMappings.length; ++i) {
                this.mappingList.add(logMappings[i]);
            }
        }
        this.bundle = bundle;
        this.initUI();
    }

    public void setMappings(LogMapping[] mappings) {
        this.mappingList.startBatch();
        try {
            this.mappingList.clear();
            if (mappings != null) {
                for (int i = 0; i < mappings.length; ++i) {
                    this.mappingList.add(mappings[i]);
                }
            }
        }
        finally {
            this.mappingList.endBatch();
        }
    }

    public LogMapping[] getMappings() {
        LogMapping[] result = new LogMapping[this.mappingList.size()];
        this.mappingList.toArray((X[])result);
        return result;
    }

    public void initUI() {
        this.bnew = new JButton(this.bundle.getString("NEW"), this.style.getImageIcon(LoggingIcons.LOG_SET_CREATE));
        this.bedit = new JButton(this.bundle.getString("INVITE_EDIT"), this.style.getImageIcon(LoggingIcons.LOG_SET_EDIT));
        this.bdelete = new JButton(this.bundle.getString("DELETE"), this.style.getImageIcon(LoggingIcons.LOG_SET_DELETE));
        this.bdelete.setHorizontalAlignment(2);
        this.bedit.setHorizontalAlignment(2);
        this.bnew.setHorizontalAlignment(2);
        TableStructure ts = TableStructure.createTableStructure(LogMapping.class, new String[]{"name", "getTargetSummary"}, new String[]{" " + this.bundle.getString("LOGGING_MAPPING_NAME"), " " + this.bundle.getString("LOGGING_MAPPING_TARGETNAME")});
        ts.setWidths(new int[]{200, 200});
        this.sortedMappingList = new SortWrapper(this.mappingList, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
        SimpleTableModel slm = new SimpleTableModel(this.sortedMappingList, ts);
        this.mappingTable = new SHJTable(0, ts.getColumnCount());
        this.mappingTable.setModel(slm);
        this.mappingTable.setSelectionMode(2);
        ts.initTableDimensions(this.mappingTable);
        ((DefaultTableCellRenderer)this.mappingTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        this.mappingTable.getSelectionModel().addListSelectionListener(this);
        this.regpane = new JScrollPane(this.mappingTable);
        ts.initTableDimensions(this.mappingTable);
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(5, 2, 2, 2));
        buttonsPanel.add((Component)this.bnew, 0, 0, 1, 1, 0, 0, 11, 2);
        buttonsPanel.add((Component)this.bedit, 0, 1, 1, 1, 0, 0, 11, 2);
        buttonsPanel.add((Component)this.bdelete, 0, 2, 1, 1, 0, 0, 11, 2, (Insets)new ScaledInsets(20, 2, 2, 2));
        this.rootComponent.add((Component)this.regpane, 0, 0, 1, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(5, 0, 0, 0));
        this.rootComponent.add((Component)buttonsPanel, 1, 0, 1, 1, 0, 1, 11, 0, (Insets)new ScaledInsets(22, 2, 2, 2));
        this.bdelete.setEnabled(false);
        this.bedit.setEnabled(false);
        this.bnew.addActionListener(this);
        this.bdelete.addActionListener(this);
        this.bedit.addActionListener(this);
    }

    public void setBorder(Border border) {
        this.regpane.setBorder(border);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.mappingTable.getSelectedRowCount() > 0) {
            this.bdelete.setEnabled(true);
            this.bedit.setEnabled(true);
        } else {
            this.bdelete.setEnabled(false);
            this.bedit.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.bdelete) {
            int[] selectedRows = this.mappingTable.getSelectedRows();
            Arrays.sort(selectedRows);
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int selectedRow = selectedRows[i];
                Object selectedObject = this.sortedMappingList.get(selectedRow);
                this.mappingList.remove(selectedObject);
            }
            this.listener.mappingsChanged();
        } else if (event.getSource() == this.bnew) {
            LogWizardGlassDialog logWizardGlassDialog = new LogWizardGlassDialog((RootPaneContainer)((Object)this.getRootComponent().getRootPane().getParent()), this.bundle, this.style);
            LogMapping result = logWizardGlassDialog.getResult();
            if (result != null) {
                this.mappingList.add(result);
                int index = this.sortedMappingList.indexOf(result);
                this.mappingTable.getSelectionModel().setSelectionInterval(index, index);
                this.listener.mappingsChanged();
            }
        } else if (event.getSource() == this.bedit) {
            int selectedIndex = this.mappingTable.getSelectedRow();
            LogMapping mapping = (LogMapping)this.sortedMappingList.get(selectedIndex);
            int originalIndex = this.mappingList.indexOf(mapping);
            LogWizardGlassDialog logWizardGlassDialog = new LogWizardGlassDialog((RootPaneContainer)((Object)this.getRootComponent().getRootPane().getParent()), this.bundle, this.style, mapping);
            LogMapping result = logWizardGlassDialog.getResult();
            if (result != null) {
                this.mappingList.set(originalIndex, result);
                this.listener.mappingsChanged();
            }
        }
    }

    public void addMappingsChangeListener(MappingsChangeListener adminLogging) {
    }

    public static interface MappingsChangeListener {
        public void mappingsChanged();
    }

    public static interface LogMappingsChangedListener {
        public void mappingsChanged();
    }
}

