/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.command;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.VariableUtil;
import utils.loggingframework.targets.command.CommandTargetUI;
import utils.message.Message;
import utils.progtools.ProcessPrinter;
import utils.xml.XML14Util;

public class CommandTarget
extends AbstractTarget
implements LocatableTarget {
    public String[] commandToRun;
    public boolean perMachine;
    public static final String ID = "CommandTarget";

    @Override
    public String getName() {
        return this.bundle.getString("TARGET_COMMAND_NAME");
    }

    @Override
    public String getDescription() {
        return this.bundle.getString("TARGET_COMMAND_DESCRIPTION");
    }

    @Override
    public String getTargetSummary() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        boolean hasContent = false;
        if (this.commandToRun != null) {
            for (String s : this.commandToRun) {
                if (s == null || s.trim().length() <= 0) continue;
                hasContent = true;
                break;
            }
        }
        if (hasContent) {
            result.append(" [");
            for (int i = 0; i < this.commandToRun.length; ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                result.append(this.commandToRun[i]);
            }
            result.append("]");
        }
        return result.toString();
    }

    @Override
    public void logEvent(LogEvent event) throws Exception {
        Object[] substitutedCommandToRun = new String[this.commandToRun.length];
        for (int i = 0; i < this.commandToRun.length; ++i) {
            substitutedCommandToRun[i] = VariableUtil.getSubstitutedText(this.commandToRun[i], event, true);
        }
        System.out.println("[LoggingFramework] Executing command '" + Arrays.toString(substitutedCommandToRun) + "'");
        Process exec = Runtime.getRuntime().exec((String[])substitutedCommandToRun);
        new ProcessPrinter(exec, (OutputStream)System.out, (OutputStream)System.out);
    }

    @Override
    public boolean isAvailableTarget() {
        return true;
    }

    @Override
    public TargetUI getTargetUI() {
        return new CommandTargetUI();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected void saveToXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"runPerMachine", (String)("" + this.perMachine));
        buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<commandToRun>\n");
        if (this.commandToRun != null) {
            for (String s : this.commandToRun) {
                XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 2), (String)"arrayelement", (String)s);
            }
        }
        buffer.append(XML14Util.getIndent((int)(indent + 1))).append("</commandToRun>\n");
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void loadFromXML(Element root) {
        Element commandParent = XML14Util.getChild((Element)root, (String)"commandToRun");
        if (commandParent != null) {
            ArrayList children = XML14Util.getChildren((Element)commandParent, (String)"arrayelement");
            ArrayList<String> command = new ArrayList<String>();
            for (Element e : children) {
                command.add(XML14Util.getTextContent((Node)e));
            }
            this.commandToRun = command.toArray(new String[0]);
        }
        try {
            this.perMachine = XML14Util.getChildText((Element)root, (String)"runPerMachine", null).equalsIgnoreCase("true");
        }
        catch (Throwable t) {
            this.perMachine = false;
        }
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.commandToRun);
        m.append(this.perMachine);
    }

    @Override
    public void fromMessage(byte verison, Message m) {
        this.commandToRun = m.getNextStringArray();
        if (m.hasNext()) {
            this.perMachine = m.getNextBoolean();
        }
    }

    @Override
    public boolean runPerMachineIsOptional() {
        return true;
    }

    @Override
    public boolean runPerMachine() {
        return this.perMachine;
    }

    @Override
    public void setRunPerMachine(boolean b) {
        this.perMachine = b;
    }
}

