/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.TargetUIListener;
import utils.swing.SwingStyleInterface;

public abstract class AbstractTargetUI
implements TargetUI {
    protected ResourceBundle bundle;
    protected ArrayList<TargetUIListener> listeners = new ArrayList();
    protected LogEvent[] events;
    protected SwingStyleInterface style;
    protected ChangeAllListener changedAllListener = new ChangeAllListener();

    protected abstract void initUI();

    @Override
    public void setResources(ResourceBundle bundle, SwingStyleInterface style) {
        this.bundle = bundle;
        this.style = style;
        this.initUI();
    }

    @Override
    public void setEventsToTarget(LogEvent[] events) {
        this.events = events;
    }

    @Override
    public void addTargetUIListener(TargetUIListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyComplete() {
        for (TargetUIListener listener : this.listeners) {
            if (listener == null) continue;
            listener.targetUIComplete();
        }
        this.notifyChanged();
    }

    protected void notifyIncomplete() {
        for (TargetUIListener listener : this.listeners) {
            if (listener == null) continue;
            listener.targetUIIncomplete();
        }
        this.notifyChanged();
    }

    protected void notifyChanged() {
        for (TargetUIListener listener : this.listeners) {
            if (listener == null) continue;
            listener.targetChanged();
        }
    }

    class ChangeAllListener
    extends KeyAdapter
    implements ActionListener {
        ChangeAllListener() {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            AbstractTargetUI.this.notifyChanged();
            AbstractTargetUI.this.notifyIfComplete();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTargetUI.this.notifyChanged();
            AbstractTargetUI.this.notifyIfComplete();
        }
    }
}

