/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;

public class RemoteFile {
    private File file;
    private char remoteFileSeparator;
    private char localFileSeparator;
    private boolean isWindows;

    public String toString() {
        return this.file + " [" + this.isWindows + "]";
    }

    public RemoteFile(RemoteFile dir, String path) {
        this(new File(dir.file, path), dir.isWindows);
    }

    public RemoteFile(String path, boolean isWindows) {
        this(new File(path), isWindows);
    }

    public RemoteFile(File file, boolean isWindows) {
        this.file = file;
        this.localFileSeparator = File.separatorChar;
        this.isWindows = isWindows;
        this.remoteFileSeparator = isWindows ? (char)92 : (char)47;
    }

    public String getRemotePath() {
        if (this.file == null) {
            return null;
        }
        String path = this.file.getPath();
        return path.replace(this.localFileSeparator, this.remoteFileSeparator);
    }

    public File getFile() {
        return this.file;
    }

    public int hashCode() {
        if (this.file == null) {
            return 0;
        }
        return this.file.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteFile)) {
            return false;
        }
        RemoteFile rf = (RemoteFile)o;
        if (rf.file == null && this.file == null) {
            return true;
        }
        if (rf.file == null || this.file == null) {
            return false;
        }
        return ((RemoteFile)o).file.equals(this.file);
    }

    public boolean isNull() {
        return this.file == null;
    }
}

