/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import utils.files.FileMirrorListener;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.progtools.Bag2;
import utils.progtools.Bag3;
import utils.progtools.BufferPool;
import utils.progtools.Lock;
import utils.stream.StreamUtils;
import utils.stream.VariableLengthStreamUtils;
import utils.string.Normaliser;

public class FileMirror {
    static int VER = 0;
    public static boolean DRYRUN = false;
    public static boolean VERBOSE = false;
    public static boolean NODOTDOT = false;
    public static boolean DEBUG_PATHS = false;
    static int M_END = 0;
    static int M_HASH = 1;
    static int M_DIR = 2;
    static int D_END = 0;
    static int D_DIR = 1;
    static int D_FILE = 2;
    static int D_DELETE = 3;
    static int D_FILE_CHUNK = 4;
    static int D_FILE_CHUNKS_END = 5;
    static int X_CANCELLED = 999;
    InputStream in;
    OutputStream out;
    Lock OUTLOCK = new Lock();
    int rver = 0;
    BufferPool bufferPool = new BufferPool(500);
    FileMirrorListener listener;
    boolean cancelPush = false;
    boolean cancelRequestSent = false;
    long totalDeleted = 0L;
    long totalBytesTransferred = 0L;
    long totalBytesProcessed = 0L;
    Bag3<Lock, HashMap<String, Boolean>, ArrayList<String>> hashy;
    Bag3<Long, Long, Long> stats;
    MetaPuller mpuller;
    DataPusher dpusher;
    String[] sourcePaths;
    File[] sources;
    HashMap<String, Boolean> skippy = new HashMap();
    Lock skippyLOCK = new Lock();
    MetaPusher mpusher;
    DataPuller dpuller;
    String storePath;
    File store;
    boolean NODELETE = false;
    Exception failureException;
    MessageDigest digest;

    private int readType(InputStream in) throws IOException, MirrorCancelled {
        int type = VariableLengthStreamUtils.readInt((InputStream)in);
        if (type == X_CANCELLED) {
            this.cancelTransfer();
            throw new MirrorCancelled();
        }
        return type;
    }

    private void checkCancelPush(OutputStream out) throws MirrorCancelled {
        if (this.cancelPush) {
            if (!this.cancelRequestSent) {
                System.out.println("[FileMirror] Sending cancellation request");
                this.cancelRequestSent = true;
                try {
                    VariableLengthStreamUtils.writeInt((OutputStream)out, (int)X_CANCELLED);
                    out.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new MirrorCancelled();
        }
    }

    public void cancelTransfer() {
        this.cancelPush = true;
    }

    private String getRelativePath(String canonicalParentPath, File child) throws IOException {
        String post;
        String path;
        if (DEBUG_PATHS) {
            System.out.println("Get path of " + child + " relative to " + canonicalParentPath);
        }
        if ((path = (post = child.getCanonicalPath()).substring(canonicalParentPath.length())).startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (DEBUG_PATHS) {
            System.out.println("Relative is " + path);
        }
        return path;
    }

    public boolean isFinished() {
        try {
            if (this.mpuller != null && this.mpuller.isAlive()) {
                return false;
            }
            if (this.dpusher != null && this.dpusher.isAlive()) {
                return false;
            }
            if (this.mpusher != null && this.mpusher.isAlive()) {
                return false;
            }
            if (this.dpuller != null && this.dpuller.isAlive()) {
                return false;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return true;
    }

    public void waitForFinish() {
        try {
            Thread.sleep(500L);
            if (this.mpuller != null) {
                this.mpuller.join();
            }
            if (this.dpusher != null) {
                this.dpusher.join();
            }
            if (this.mpusher != null) {
                this.mpusher.join();
            }
            if (this.dpuller != null) {
                this.dpuller.join();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void checkForFailures() throws Exception {
        if (this.failureException != null) {
            throw this.failureException;
        }
    }

    public long getTotalDeleted() {
        return this.totalDeleted;
    }

    public long getTotalBytesTransferred() {
        return this.totalBytesTransferred;
    }

    public static FileMirror mergeFolderIntoDir(InputStream in, OutputStream out, File localFile) throws IOException {
        return FileMirror.mergeFolderIntoDir(in, out, localFile, null);
    }

    public static FileMirror mergeFolderIntoDir(InputStream in, OutputStream out, File localFile, FileMirrorListener listener) throws IOException {
        if (!localFile.isDirectory()) {
            throw new IOException("Can only merge a folder into the remote folder");
        }
        return new FileMirror(in, out, new File[]{localFile}, true, listener);
    }

    public static FileMirror putFileIntoDir(InputStream in, OutputStream out, File localFile) throws IOException {
        return FileMirror.putFileIntoDir(in, out, localFile, null);
    }

    public static FileMirror putFileIntoDir(InputStream in, OutputStream out, File localFile, FileMirrorListener listener) throws IOException {
        return new FileMirror(in, out, new File[]{localFile}, false, listener);
    }

    public static FileMirror putFilesIntoDir(InputStream in, OutputStream out, File[] localFiles) throws IOException {
        return FileMirror.putFilesIntoDir(in, out, localFiles, null);
    }

    public static FileMirror putFilesIntoDir(InputStream in, OutputStream out, File[] localFiles, FileMirrorListener listener) throws IOException {
        Object[] sorted = (File[])localFiles.clone();
        for (int i = 0; i < sorted.length; ++i) {
            sorted[i] = ((File)sorted[i]).getCanonicalFile();
        }
        Arrays.sort(sorted);
        return new FileMirror(in, out, (File[])sorted, false, listener);
    }

    private FileMirror(InputStream in, OutputStream out, File[] send, boolean merge, FileMirrorListener listener) throws IOException {
        int i;
        this.in = in;
        this.out = out;
        this.sources = send;
        this.listener = listener;
        this.sourcePaths = new String[this.sources.length];
        for (i = 0; i < this.sources.length; ++i) {
            if (merge) {
                this.sourcePaths[i] = this.sources[i].getCanonicalPath();
                continue;
            }
            File absFile = this.sources[i].getAbsoluteFile();
            File parentFile = absFile.getParentFile();
            String canonicalParentPath = "";
            if (parentFile != null) {
                canonicalParentPath = parentFile.getCanonicalPath();
            }
            this.sourcePaths[i] = canonicalParentPath;
        }
        this.rver = VariableLengthStreamUtils.readInt((InputStream)in);
        if (merge) {
            StreamUtils.writeInt((OutputStream)out, (int)1);
            StreamUtils.writeStringUTF8((OutputStream)out, (String)".");
        } else {
            StreamUtils.writeInt((OutputStream)out, (int)this.sources.length);
            for (i = 0; i < this.sources.length; ++i) {
                StreamUtils.writeStringUTF8((OutputStream)out, (String)this.getRelativePath(this.sourcePaths[i], this.sources[i]));
            }
        }
        out.flush();
        this.hashy = new Bag3(new Lock(), new HashMap(), new ArrayList());
        this.stats = new Bag3<Long, Long, Long>(new Long(0L), new Long(0L), new Long(0L));
        this.mpuller = new MetaPuller();
        this.dpusher = new DataPusher();
        this.mpuller.start();
        this.dpusher.start();
    }

    public static FileMirror getFileIntoDir(InputStream in, OutputStream out, File store, boolean acceptDeletes) throws IOException {
        return FileMirror.getFileIntoDir(in, out, store, acceptDeletes, null);
    }

    public static FileMirror getFileIntoDir(InputStream in, OutputStream out, File store, boolean acceptDeletes, FileMirrorListener listener) throws IOException {
        return new FileMirror(in, out, store, acceptDeletes, listener);
    }

    private FileMirror(InputStream in, OutputStream out, File store, boolean acceptDeletes, FileMirrorListener listener) throws IOException {
        this.in = in;
        this.out = out;
        this.store = store;
        this.listener = listener;
        this.NODELETE = !acceptDeletes;
        this.storePath = store.getCanonicalPath();
        if (DRYRUN) {
            this.NODELETE = true;
        }
        VariableLengthStreamUtils.writeInt((OutputStream)out, (int)VER);
        out.flush();
        String[] hashPaths = new String[StreamUtils.readInt((InputStream)in)];
        for (int i = 0; i < hashPaths.length; ++i) {
            hashPaths[i] = StreamUtils.readStringUTF8((InputStream)in);
        }
        this.mpusher = new MetaPusher(hashPaths);
        this.dpuller = new DataPuller();
        this.mpusher.start();
        this.dpuller.start();
    }

    String readPath(InputStream in) throws IOException {
        String path = StreamUtils.readStringUTF8((InputStream)in);
        path = path.replace('\\', File.separatorChar);
        path = path.replace('/', File.separatorChar);
        if (NODOTDOT && PathUtil.containsDotDot((String)path)) {
            throw new IOException("Bad Path: " + path);
        }
        return path;
    }

    public static int readFullyIfPossible(byte[] dat, RandomAccessFile in) throws IOException {
        int n = 0;
        int tot = 0;
        while (tot < dat.length && n != -1) {
            n = in.read(dat, tot, dat.length - tot);
            if (n <= 0) continue;
            tot += n;
        }
        return tot;
    }

    public static byte[] hash(byte[] dat, int off, int len) throws IOException {
        MessageDigest digest = null;
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException alg) {
                throw new IOException("Unable to get MD5 digest");
            }
        }
        digest.update(dat, off, len);
        byte[] md5 = digest.digest();
        return md5;
    }

    public static long hashlong(byte[] md5) {
        long a = md5[0] * 256 * md5[1] + 65536 * md5[2] + 0x1000000 * md5[3];
        long b = md5[4] * 256 * md5[5] + 65536 * md5[6] + 0x1000000 * md5[7];
        long result = a ^ b;
        return result;
    }

    public boolean hequal(byte[] a, byte[] b) throws IOException {
        if (a.length != b.length) {
            throw new IOException("Hash lengths do not match!");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static long scan(String path) throws IOException {
        RandomAccessFile fin = new RandomAccessFile(path, "r");
        byte[] chunk = new byte[200000];
        long TOT = 0L;
        int N = FileMirror.readFullyIfPossible(chunk, fin);
        while (N > 0) {
            TOT += (long)N;
            N = FileMirror.readFullyIfPossible(chunk, fin);
        }
        return TOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deephash(String path) throws IOException {
        byte[] chunk = new byte[200000];
        long totread = 0L;
        try (RandomAccessFile fin = new RandomAccessFile(path, "r");){
            long start = 0L;
            int N = FileMirror.readFullyIfPossible(chunk, fin);
            while (N > 0) {
                totread += (long)N;
                byte[] hash = FileMirror.hash(chunk, 0, N);
                System.out.println("Hashed " + path + ", at " + start + " +" + N + " " + FileMirror.hashlong(hash));
                start += (long)N;
                N = FileMirror.readFullyIfPossible(chunk, fin);
            }
        }
    }

    class MetaPusher
    extends Thread {
        String[] hashPaths;
        byte[] chunk = new byte[200000];

        public MetaPusher(String[] hashPaths) {
            this.hashPaths = hashPaths;
        }

        @Override
        public void run() {
            try {
                if (VERBOSE) {
                    System.out.println("[MetaPusher] hashing " + this.hashPaths.length + " paths");
                }
                for (String hashPath : this.hashPaths) {
                    if (VERBOSE) {
                        System.out.println("[MetaPusher] hashing " + hashPath);
                    }
                    this.pushMeta(new File(FileMirror.this.store, hashPath).getCanonicalFile());
                }
                VariableLengthStreamUtils.writeInt((OutputStream)FileMirror.this.out, (int)M_END);
                FileMirror.this.out.flush();
            }
            catch (MirrorCancelled x) {
                System.out.println("[MetaPusher] Mirror cancelled");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pushMeta(File f) throws Exception {
            if (f.exists()) {
                if (f != FileMirror.this.store && FileUtil.isSymlink((File)f)) {
                    System.out.println("[MetaPusher] Skipping symlink: " + f);
                } else {
                    if (f.isDirectory()) {
                        Object[] files = f.listFiles();
                        if (files == null) {
                            files = new File[]{};
                        }
                        Arrays.sort(files);
                        long T = System.currentTimeMillis();
                        for (Object file : files) {
                            this.pushMeta((File)file);
                            if (System.currentTimeMillis() <= T + 500L) continue;
                            T = System.currentTimeMillis();
                            FileMirror.this.out.flush();
                        }
                        Lock lock = FileMirror.this.OUTLOCK;
                        synchronized (lock) {
                            FileMirror.this.checkCancelPush(FileMirror.this.out);
                            VariableLengthStreamUtils.writeInt((OutputStream)FileMirror.this.out, (int)M_DIR);
                            StreamUtils.writeStringUTF8((OutputStream)FileMirror.this.out, (String)FileMirror.this.getRelativePath(FileMirror.this.storePath, f));
                            FileMirror.this.out.flush();
                        }
                    }
                    ArrayList<Long> starts = new ArrayList<Long>();
                    ArrayList<byte[]> hashes = new ArrayList<byte[]>();
                    long l = 0L;
                    try (RandomAccessFile fin = new RandomAccessFile(f, "r");){
                        long start = 0L;
                        int N = FileMirror.readFullyIfPossible(this.chunk, fin);
                        while (N > 0) {
                            l += (long)N;
                            byte[] hash = FileMirror.hash(this.chunk, 0, N);
                            starts.add(start);
                            hashes.add(hash);
                            start += (long)N;
                            N = FileMirror.readFullyIfPossible(this.chunk, fin);
                        }
                    }
                    if (VERBOSE) {
                        System.out.println("[MetaPusher] Hashed " + f + ", len " + f.length() + ", read " + l + " " + starts.size() + " hashes");
                    }
                    FileMirror.this.checkCancelPush(FileMirror.this.out);
                    VariableLengthStreamUtils.writeInt((OutputStream)FileMirror.this.out, (int)M_HASH);
                    StreamUtils.writeStringUTF8((OutputStream)FileMirror.this.out, (String)FileMirror.this.getRelativePath(FileMirror.this.storePath, f));
                    VariableLengthStreamUtils.writeLong((OutputStream)FileMirror.this.out, (long)f.length());
                    VariableLengthStreamUtils.writeInt((OutputStream)FileMirror.this.out, (int)starts.size());
                    for (int i = 0; i < starts.size(); ++i) {
                        VariableLengthStreamUtils.writeLong((OutputStream)FileMirror.this.out, (long)((Long)starts.get(i)));
                        StreamUtils.writeBytes((OutputStream)FileMirror.this.out, (byte[])((byte[])hashes.get(i)));
                    }
                }
            }
        }
    }

    class DataPuller
    extends Thread {
        DecimalFormat df = new DecimalFormat("###,###,###,###,##0");
        DecimalFormat df1 = new DecimalFormat("###,###,###,##0.0");

        DataPuller() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    long deleted;
                    long T = System.currentTimeMillis();
                    Bag2<Long, Long> stats = this.pullData(FileMirror.this.in);
                    long transferred = (Long)stats.first / 1024000L;
                    FileMirror.this.totalDeleted = deleted = ((Long)stats.second).longValue();
                    FileMirror.this.totalBytesTransferred = (Long)stats.first;
                    T = System.currentTimeMillis() - T;
                    double secs = (double)T / 1000.0;
                    secs = (double)transferred / secs;
                    if (transferred == 0L) {
                        secs = 0.0;
                    }
                    System.out.println("[DataPuller] Transferred " + transferred + " MB, deleted " + deleted + ", " + this.df.format(T) + "ms, " + this.df1.format(secs) + " MB/s (effective)");
                }
                catch (MirrorCancelled x) {
                    System.out.println("[DataPuller] Mirror cancelled");
                }
                catch (Exception x) {
                    x.printStackTrace();
                    if (FileMirror.this.failureException != null) break block4;
                    FileMirror.this.failureException = x;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Bag2<Long, Long> pullData(InputStream in) throws Exception {
            int type;
            Bag2<Long, Long> results = new Bag2<Long, Long>(new Long(0L), new Long(0L));
            while ((type = FileMirror.this.readType(in)) != D_END) {
                String path = FileMirror.this.readPath(in);
                File myfile = new File(FileMirror.this.store, path);
                if (type == D_DELETE) {
                    if (!FileMirror.this.NODELETE) {
                        System.out.println("[DataPuller] Deleting: " + myfile);
                        if (myfile.isFile()) {
                            myfile.delete();
                        } else {
                            FileUtil.deleteDir((File)myfile);
                        }
                        System.out.println("[DataPuller] Done");
                    } else {
                        System.out.println("[DataPuller] Ignoring request to delete: " + myfile);
                    }
                    Bag2<Long, Long> bag2 = results;
                    Long l = (Long)bag2.second;
                    bag2.second = (Long)bag2.second + 1L;
                    Long l2 = bag2.second;
                    continue;
                }
                if (type == D_DIR) {
                    if (myfile.exists() && !myfile.isDirectory() && !FileMirror.this.NODELETE) {
                        myfile.delete();
                    }
                    if (!myfile.exists() && VERBOSE) {
                        System.out.println("[DataPuller] Make dir " + myfile);
                    }
                    if (DRYRUN) continue;
                    myfile.mkdirs();
                    continue;
                }
                if (type == D_FILE) {
                    double megs;
                    double mpersec;
                    double MINsecs;
                    double secs;
                    long lmod = StreamUtils.readLong((InputStream)in);
                    System.out.println("[DataPuller] Pulling " + path + " relative to " + FileMirror.this.store);
                    RandomAccessFile fout = null;
                    if (VERBOSE) {
                        System.out.println("[DataPuller] Opening file to write " + myfile);
                    }
                    if (!DRYRUN) {
                        try {
                            fout = new RandomAccessFile(myfile, "rw");
                        }
                        catch (Exception x) {
                            if (myfile.isDirectory()) {
                                FileUtil.deleteDir((File)myfile);
                            }
                            try {
                                myfile.getParentFile().mkdirs();
                                fout = new RandomAccessFile(myfile, "rw");
                            }
                            catch (Exception xx) {
                                System.out.println("Error opening file: " + xx + ", will try to reduce to alphanumeric chars only...");
                                try {
                                    String name = myfile.getName();
                                    name = Normaliser.normaliseToCharsAndDigits((String)name, (boolean)true, (boolean)true);
                                    System.out.println("Adjusted file name to: " + name + " and will retry...");
                                    fout = new RandomAccessFile(new File(myfile.getParentFile(), name), "rw");
                                }
                                catch (Exception xxx) {
                                    System.out.println("Error opening file and name normalisation failed: " + xxx);
                                    xxx.printStackTrace();
                                }
                            }
                        }
                    }
                    long Tfile = System.currentTimeMillis();
                    long total = 0L;
                    try {
                        int dmtype = FileMirror.this.readType(in);
                        while (dmtype != D_FILE_CHUNKS_END) {
                            long start = VariableLengthStreamUtils.readLong((InputStream)in);
                            byte[] dat = StreamUtils.readBytes((InputStream)in);
                            total += (long)dat.length;
                            Bag2<Long, Long> bag2 = results;
                            Long.valueOf((Long)bag2.first + (long)dat.length);
                            bag2.first = bag2.first;
                            if (FileMirror.this.listener != null) {
                                FileMirror.this.listener.processedBytes(FileMirror.this, dat.length);
                                FileMirror.this.listener.transferredBytes(FileMirror.this, dat.length);
                            }
                            if (fout != null) {
                                fout.seek(start);
                                fout.write(dat);
                            }
                            dmtype = FileMirror.this.readType(in);
                        }
                        long flen = VariableLengthStreamUtils.readLong((InputStream)in);
                        if (fout != null) {
                            if (VERBOSE) {
                                System.out.println("[DataPuller] Wrote " + path + " and length to " + flen);
                            }
                            fout.setLength(flen);
                        }
                    }
                    finally {
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    if (VERBOSE) {
                        System.out.println("[DataPuller] Closed file to write " + myfile);
                    }
                    Tfile = System.currentTimeMillis() - Tfile;
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    catch (Exception dmtype) {
                        // empty catch block
                    }
                    if (VERBOSE) {
                        System.out.println("[DataPuller] Set last modified " + path + " to " + lmod);
                    }
                    if (!DRYRUN) {
                        myfile.setLastModified(lmod);
                    }
                    if ((secs = (double)Tfile) < (MINsecs = 1.0E-4)) {
                        secs = MINsecs;
                    }
                    if ((mpersec = (megs = (double)total / 1024000.0) / (secs /= 1000.0)) > 100.0) {
                        System.out.println("[DataPuller] Done: " + this.df.format(total) + " (" + (long)mpersec + "mb/s)");
                    } else {
                        mpersec *= 100.0;
                        mpersec = (int)mpersec;
                        System.out.println("[DataPuller] Done: " + this.df.format(total) + " (" + (long)(mpersec /= 100.0) + "mb/s)");
                    }
                    if (FileMirror.this.listener == null) continue;
                    FileMirror.this.listener.fileReceived(FileMirror.this, myfile, path);
                    continue;
                }
                System.out.println("Unrecognised D_ data type: " + type);
            }
            return results;
        }
    }

    class MetaPuller
    extends Thread {
        byte[] chunk = new byte[200000];

        MetaPuller() {
        }

        @Override
        public void run() {
            try {
                this.pullMeta(FileMirror.this.in, FileMirror.this.hashy, FileMirror.this.stats);
            }
            catch (MirrorCancelled x) {
                System.out.println("[MetaPuller] Mirror cancelled");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        void pullMeta(InputStream in, Bag3<Lock, HashMap<String, Boolean>, ArrayList<String>> bag, Bag3<Long, Long, Long> results) throws Exception {
            boolean loop = true;
            while (loop) {
                Lock lock;
                void var8_13;
                File myfile;
                String path;
                int type = FileMirror.this.readType(in);
                if (type == M_END) {
                    loop = false;
                    ((Lock)bag.first).on = false;
                    continue;
                }
                if (type == M_DIR) {
                    path = FileMirror.this.readPath(in);
                    if (FileMirror.this.sources.length != 1) continue;
                    myfile = new File(FileMirror.this.sourcePaths[0], path);
                    System.out.println("Checking for M_DIR exist " + myfile + " " + myfile.exists());
                    if (myfile.exists()) continue;
                    Lock lock2 = (Lock)bag.first;
                    synchronized (lock2) {
                        System.out.println("Other Must Delete Dir: " + path);
                        ((ArrayList)bag.third).add(path);
                        Bag3<Long, Long, Long> bag3 = results;
                        Long l = (Long)bag3.second;
                        bag3.second = (Long)bag3.second + 1L;
                        Long l2 = bag3.second;
                        continue;
                    }
                }
                if (type != M_HASH) continue;
                path = FileMirror.this.readPath(in);
                myfile = null;
                for (String sourcePath : FileMirror.this.sourcePaths) {
                    myfile = new File(sourcePath, path);
                    System.out.println("[MetaPuller] Provided path " + path + ", checking " + myfile);
                    if (myfile.exists()) break;
                }
                Object var8_11 = null;
                long mylen = 0L;
                boolean same = false;
                if (myfile.exists()) {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(myfile, "r");
                    mylen = myfile.length();
                    same = true;
                }
                try {
                    long flen = VariableLengthStreamUtils.readLong((InputStream)in);
                    int size = VariableLengthStreamUtils.readInt((InputStream)in);
                    if (myfile.length() != flen) {
                        same = false;
                    }
                    if (VERBOSE) {
                        System.out.println("[MetaPuller] Opening " + myfile + " to check " + size + " hashes");
                    }
                    for (int i = 0; i < size; ++i) {
                        long start = VariableLengthStreamUtils.readLong((InputStream)in);
                        byte[] hash = StreamUtils.readNBytes((InputStream)in, (int)128);
                        if (start >= mylen) {
                            if (VERBOSE) {
                                System.out.println("[MetaPuller] Our file is too short to hash " + start);
                            }
                            same = false;
                        }
                        if (var8_13 == null) continue;
                        var8_13.seek(start);
                        int N = FileMirror.readFullyIfPossible(this.chunk, (RandomAccessFile)var8_13);
                        if (start >= mylen) continue;
                        byte[] myhash = FileMirror.hash(this.chunk, 0, N);
                        if (!FileMirror.this.hequal(hash, myhash)) {
                            if (VERBOSE) {
                                System.out.println("[MetaPuller] File " + path + " different at chunk " + start + " +" + N + " " + FileMirror.hashlong(hash) + " != " + FileMirror.hashlong(myhash));
                            }
                            same = false;
                            continue;
                        }
                        Lock lock3 = FileMirror.this.skippyLOCK;
                        synchronized (lock3) {
                            FileMirror.this.skippy.put(path + "@" + start, Boolean.TRUE);
                            continue;
                        }
                    }
                }
                finally {
                    if (var8_13 != null) {
                        var8_13.close();
                    }
                }
                if (VERBOSE) {
                    System.out.println("[MetaPuller] Closing " + myfile + " for hashing");
                }
                if (!myfile.exists()) {
                    lock = (Lock)bag.first;
                    synchronized (lock) {
                        System.out.println("Other Must Delete File: " + path);
                        ((ArrayList)bag.third).add(path);
                        Bag3<Long, Long, Long> bag3 = results;
                        Long l = (Long)bag3.second;
                        bag3.second = (Long)bag3.second + 1L;
                        Long l3 = bag3.second;
                        continue;
                    }
                }
                lock = (Lock)bag.first;
                synchronized (lock) {
                    ((HashMap)bag.second).put(path, same);
                }
            }
        }
    }

    class DataPusher
    extends Thread {
        DecimalFormat df = new DecimalFormat("###,###,###,##0");
        DecimalFormat df1 = new DecimalFormat("###,###,###,##0.0");
        byte[] chunk = new byte[200000];

        DataPusher() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    long T = System.currentTimeMillis();
                    this.pushData(FileMirror.this.out, FileMirror.this.hashy, FileMirror.this.stats);
                    T = System.currentTimeMillis() - T;
                    long transferred = (Long)FileMirror.this.stats.first / 1024000L;
                    long deleted = (Long)FileMirror.this.stats.second;
                    long processed = (Long)FileMirror.this.stats.third / 1024000L;
                    FileMirror.this.totalDeleted = deleted;
                    FileMirror.this.totalBytesTransferred = (Long)FileMirror.this.stats.first;
                    FileMirror.this.totalBytesProcessed = (Long)FileMirror.this.stats.third;
                    double secs = (double)T / 1000.0;
                    secs = (double)processed / secs;
                    if (processed == 0L) {
                        secs = 0.0;
                    }
                    System.out.println("[DataPusher] Processed " + processed + " MB, transferred " + transferred + " MB, deleted " + deleted + ", " + this.df.format(T) + "ms, " + this.df1.format(secs) + " MB/s (effective)");
                }
                catch (MirrorCancelled x) {
                    System.out.println("[DataPusher] Mirror cancelled");
                }
                catch (Exception x) {
                    x.printStackTrace();
                    if (FileMirror.this.failureException != null) break block4;
                    FileMirror.this.failureException = x;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pushData(OutputStream out, Bag3<Lock, HashMap<String, Boolean>, ArrayList<String>> bag, Bag3<Long, Long, Long> results) throws Exception {
            String[] deletes;
            for (int i = 0; i < FileMirror.this.sources.length; ++i) {
                this.pushData(FileMirror.this.sourcePaths[i], FileMirror.this.sources[i], out, bag, results);
            }
            while (((Lock)bag.first).on) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception i) {}
            }
            String[] stringArray = (String[])bag.first;
            synchronized (stringArray) {
                deletes = ((ArrayList)bag.third).toArray(new String[0]);
            }
            for (String path : deletes) {
                FileMirror.this.checkCancelPush(out);
                VariableLengthStreamUtils.writeInt((OutputStream)out, (int)D_DELETE);
                StreamUtils.writeStringUTF8((OutputStream)out, (String)path);
            }
            VariableLengthStreamUtils.writeInt((OutputStream)out, (int)D_END);
            out.flush();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pushData(String canonicalParentPath, File f, OutputStream out, Bag3<Lock, HashMap<String, Boolean>, ArrayList<String>> bag, Bag3<Long, Long, Long> results) throws Exception {
            if (!f.getPath().equals(".") && FileUtil.isSymlink((File)f)) {
                System.out.println("[DataPusher] Skipping symlink: " + f);
            } else if (f.isDirectory()) {
                Object[] files;
                String path = FileMirror.this.getRelativePath(canonicalParentPath, f);
                if (path.length() > 0) {
                    if (VERBOSE) {
                        System.out.println("[DataPusher] Processing " + path);
                    }
                    FileMirror.this.checkCancelPush(out);
                    VariableLengthStreamUtils.writeInt((OutputStream)out, (int)D_DIR);
                    StreamUtils.writeStringUTF8((OutputStream)out, (String)path);
                    out.flush();
                }
                if ((files = f.listFiles()) == null) {
                    files = new File[]{};
                }
                Arrays.sort(files);
                for (Object file : files) {
                    this.pushData(canonicalParentPath, (File)file, out, bag, results);
                }
                out.flush();
            } else {
                Object path = results;
                ((Bag3)path).third = (Long)((Bag3)path).third + f.length();
                path = FileMirror.this.getRelativePath(canonicalParentPath, f);
                if (VERBOSE) {
                    System.out.println("[DataPusher] Reviewing " + (String)path);
                }
                boolean mustSend = true;
                boolean mustWait = true;
                while (mustWait) {
                    FileMirror.this.checkCancelPush(out);
                    boolean pause = false;
                    Lock lock = (Lock)bag.first;
                    synchronized (lock) {
                        if (((HashMap)bag.second).size() > 0) {
                            mustWait = false;
                            Boolean issame = (Boolean)((HashMap)bag.second).remove(path);
                            if (issame == null) {
                                mustSend = true;
                                System.out.println("[DataPusher] Must send missing file " + (String)path);
                            } else if (issame.booleanValue()) {
                                mustSend = false;
                            } else {
                                mustSend = true;
                                System.out.println("[DataPusher] Must send different file " + (String)path);
                            }
                        } else if (!((Lock)bag.first).on) {
                            mustWait = false;
                        } else {
                            pause = true;
                        }
                    }
                    if (!pause) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                FileMirror.this.checkCancelPush(out);
                if (!mustSend) {
                    if (FileMirror.this.listener != null) {
                        FileMirror.this.listener.processedBytes(FileMirror.this, f.length());
                    }
                } else {
                    FileMirror.this.checkCancelPush(out);
                    VariableLengthStreamUtils.writeInt((OutputStream)out, (int)D_FILE);
                    StreamUtils.writeStringUTF8((OutputStream)out, (String)path);
                    StreamUtils.writeLong((OutputStream)out, (long)f.lastModified());
                    if (VERBOSE) {
                        System.out.println("[DataPusher] Opening " + (String)path + " for sending");
                    }
                    long totread = 0L;
                    try (RandomAccessFile fin = new RandomAccessFile(f, "r");){
                        long start = 0L;
                        int N = FileMirror.readFullyIfPossible(this.chunk, fin);
                        while (N > 0) {
                            totread += (long)N;
                            Boolean skip = null;
                            Object object = FileMirror.this.skippyLOCK;
                            synchronized (object) {
                                skip = FileMirror.this.skippy.remove((String)path + "@" + start);
                            }
                            if (skip == null) {
                                skip = Boolean.FALSE;
                            }
                            if (!skip.booleanValue()) {
                                if (VERBOSE) {
                                    System.out.println("[DataPusher] Sending chunk " + (String)path + "@" + start + " +" + N + " hash " + FileMirror.hashlong(FileMirror.hash(this.chunk, 0, N)));
                                }
                                FileMirror.this.checkCancelPush(out);
                                VariableLengthStreamUtils.writeInt((OutputStream)out, (int)D_FILE_CHUNK);
                                VariableLengthStreamUtils.writeLong((OutputStream)out, (long)start);
                                StreamUtils.writeBytes((OutputStream)out, (byte[])this.chunk, (int)0, (int)N);
                                if (FileMirror.this.listener != null) {
                                    FileMirror.this.listener.processedBytes(FileMirror.this, this.chunk.length);
                                    FileMirror.this.listener.transferredBytes(FileMirror.this, this.chunk.length);
                                }
                                object = results;
                                Long.valueOf((Long)((Bag3)object).first + (long)N);
                                ((Bag3)object).first = ((Bag3)object).first;
                            }
                            start += (long)N;
                            N = FileMirror.readFullyIfPossible(this.chunk, fin);
                        }
                    }
                    if (VERBOSE) {
                        System.out.println("[DataPusher] Closing " + (String)path + " for sending, " + totread + " bytes processed");
                    }
                    FileMirror.this.checkCancelPush(out);
                    VariableLengthStreamUtils.writeInt((OutputStream)out, (int)D_FILE_CHUNKS_END);
                    VariableLengthStreamUtils.writeLong((OutputStream)out, (long)f.length());
                }
            }
        }
    }

    class MirrorCancelled
    extends Exception {
        MirrorCancelled() {
        }
    }
}

