/*
 * Decompiled with CFR 0.152.
 */
package utils.email;

import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.SearchTerm;
import javax.mail.util.ByteArrayDataSource;
import utils.email.CommonEmailer;
import utils.email.DummySSLSocketFactory;
import utils.email.IMAPProcessor;

public class IMAPUtil {
    private static final String DRAFTS = "[Gmail]/Drafts";
    private static final String DRAFTS2 = "Drafts";
    private Session session;

    private Folder getDrafts(Store store, String mailBox) throws Exception {
        Folder folder = store.getDefaultFolder();
        Folder inboxFolder = folder.getFolder(mailBox);
        try {
            inboxFolder.open(2);
        }
        catch (MessagingException ex) {
            inboxFolder.open(1);
        }
        if (!inboxFolder.exists()) {
            throw new Exception("The inbox '" + mailBox + "' does not exist");
        }
        return inboxFolder;
    }

    private Folder getDrafts2(Store store) throws Exception {
        Folder folder = store.getDefaultFolder();
        Folder inboxFolder = folder.getFolder("[Google Mail]");
        inboxFolder = inboxFolder.getFolder(DRAFTS2);
        try {
            inboxFolder.open(2);
        }
        catch (MessagingException ex) {
            inboxFolder.open(1);
        }
        if (!inboxFolder.exists()) {
            throw new Exception("The drafts mailbox does not exist");
        }
        return inboxFolder;
    }

    public void createDraftGmailEmail(String username, String password, String host, int port, boolean secure, String fromAddress, String toAddress, String subject, String bodyText, CommonEmailer.EmailAttachment[] attachedFiles) throws Exception {
        Store store = null;
        store = this.connectIMAP("imap.gmail.com", port, secure, username, password);
        Folder draftsFolder = null;
        try {
            draftsFolder = this.getDrafts(store, DRAFTS);
        }
        catch (Exception ex) {
            draftsFolder = this.getDrafts2(store);
        }
        MimeMessage msg = new MimeMessage(this.session);
        msg.setFrom((Address)new InternetAddress(fromAddress));
        InternetAddress[] addresses = new InternetAddress[]{new InternetAddress(toAddress)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeMultipart parts = new MimeMultipart();
        MimeBodyPart mainBody = new MimeBodyPart();
        mainBody.setText(bodyText);
        parts.addBodyPart((BodyPart)mainBody);
        if (attachedFiles != null) {
            for (CommonEmailer.EmailAttachment attachment : attachedFiles) {
                if (attachment.fileToAttach != null) {
                    MimeBodyPart attachmentBody = new MimeBodyPart();
                    attachmentBody.attachFile(attachment.fileToAttach);
                    parts.addBodyPart((BodyPart)attachmentBody);
                    continue;
                }
                String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(attachment.filename);
                ByteArrayDataSource bads = new ByteArrayDataSource(attachment.data, contentType);
                MimeBodyPart attachmentBody = new MimeBodyPart();
                attachmentBody.setDataHandler(new DataHandler((DataSource)bads));
                attachmentBody.setFileName(attachment.filename);
                attachmentBody.setDisposition("attachment");
                parts.addBodyPart((BodyPart)attachmentBody);
            }
        }
        msg.setContent((Multipart)parts);
        draftsFolder.appendMessages(new Message[]{msg});
        if (store != null) {
            this.disconnectIMAP(store);
        }
    }

    public Store connectIMAP(String imapHost, int port, boolean secure, String username, String password) throws NoSuchProviderException, MessagingException {
        Properties props = System.getProperties();
        String protocol = "imap";
        if (secure) {
            String SSL_FACTORY = DummySSLSocketFactory.class.getCanonicalName();
            props.setProperty("mail.imaps.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.imaps.socketFactory.fallback", "false");
            props.setProperty("mail.imaps.port", Integer.toString(port));
            props.setProperty("mail.imaps.socketFactory.port", Integer.toString(port));
            protocol = "imaps";
        } else {
            props.setProperty("mail.imap.port", Integer.toString(port));
            protocol = "imap";
        }
        this.session = Session.getInstance((Properties)props, null);
        Store store = this.session.getStore(protocol);
        store.connect(imapHost, port, username, password);
        return store;
    }

    public void disconnectIMAP(Store store) throws MessagingException {
        store.close();
    }

    public static void searchAndProcessMessages(Folder folder, IMAPProcessor proc, SearchTerm search, String subjectMatch, String fromMatch) throws MessagingException {
        IMAPUtil.searchAndProcessMessages(folder, proc, search, 0, subjectMatch, fromMatch);
    }

    public static void searchAndProcessMessages(Folder folder, IMAPProcessor proc, int max, String subjectMatch, String fromMatch) throws MessagingException {
        IMAPUtil.searchAndProcessMessages(folder, proc, null, max, subjectMatch, fromMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchAndProcessMessages(Folder folder, IMAPProcessor proc, SearchTerm search, int max, String subjectMatch, String fromMatch) throws MessagingException {
        folder.open(1);
        Pattern subP = Pattern.compile(subjectMatch);
        Pattern fromP = Pattern.compile(fromMatch);
        try {
            int count = folder.getMessageCount();
            long T = System.currentTimeMillis();
            System.out.println("[IMAP Search] Folder " + folder.getName() + " has " + count + " emails");
            Message[] messages = search == null ? folder.getMessages(1, Math.min(max, count)) : folder.search(search);
            for (Message msg : messages) {
                String subject = msg.getSubject();
                Address[] froms = msg.getFrom();
                boolean match = false;
                if (subject != null && subP.matcher(subject).matches()) {
                    match = true;
                }
                for (Address from : froms) {
                    if (!fromP.matcher(from.toString()).matches()) continue;
                    match = true;
                }
                if (!match) continue;
                proc.process(msg);
            }
            T = System.currentTimeMillis() - T;
            System.out.println("IMAP processing took " + T + "ms");
        }
        finally {
            folder.close(false);
        }
    }

    public static Folder getGMailAllMail(Store store) throws MessagingException {
        Folder folder = store.getFolder("[Gmail]");
        Folder allMail = folder.getFolder("All Mail");
        return allMail;
    }

    public static Folder getGMailInbox(Store store) throws MessagingException {
        Folder folder = store.getFolder("Inbox");
        return folder;
    }
}

