/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.ChunkList;
import utils.dataservice.gziplist.policies.CachePolicy;
import utils.dataservice.gziplist.policies.NullCachePolicy;
import utils.dataservice.local.datalist.TimedList;

public class BooleanList
extends TimedList {
    public BooleanList(File file, ChunkList.EncryptionKeyRepository keyRepository) throws IOException {
        super(file, BooleanList.getAggregators(), keyRepository, new NullCachePolicy());
    }

    public BooleanList(File file, ChunkHeader header, ChunkList.EncryptionKeyRepository keyRepository) throws IOException {
        super(file, BooleanList.getAggregators(), header, keyRepository, new NullCachePolicy());
    }

    public BooleanList(File file, ChunkList.EncryptionKeyRepository keyRepository, CachePolicy cachePolicy) throws IOException {
        super(file, BooleanList.getAggregators(), keyRepository, cachePolicy);
    }

    public BooleanList(File file, ChunkHeader header, ChunkList.EncryptionKeyRepository keyRepository, CachePolicy cachePolicy) throws IOException {
        super(file, BooleanList.getAggregators(), header, keyRepository, cachePolicy);
    }

    public static byte[] getAggregators() {
        byte[] validAggregators = new byte[]{10, 11, 12};
        return validAggregators;
    }

    @Override
    public Class getDataClass() {
        return Boolean.class;
    }

    @Override
    public void initializeByteContainer() {
        this.byteContainer = new byte[9];
    }

    @Override
    public int writeEventData(Object object) throws Exception {
        Boolean b = (Boolean)object;
        this.byteContainer[8] = b != false ? (byte)1 : 0;
        return this.byteContainer.length;
    }

    @Override
    public Object parseEventValue(byte[] bytes) {
        if (bytes[8] == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getBooleanValue(long index) {
        return (Boolean)this.getValue(index);
    }

    public void addBoolean(double timestamp, Boolean booleanValue) {
        this.add(timestamp, booleanValue);
    }
}

