/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.Chunk;
import utils.dataservice.gziplist.DataServiceRAFilePool;
import utils.dataservice.gziplist.IndexHelper;
import utils.dataservice.gziplist.index.IndexElement;
import utils.dataservice.gziplist.stream.RandomAccessInputStream;
import utils.dataservice.gziplist.stream.RandomAccessOutputStream;
import utils.stream.StreamUtils;

public class IndexList {
    private static final int INDEX_CHUNK_SIZE = 1024;
    protected ArrayList<IndexElement> indexElements = new ArrayList();
    protected long totalPersistedEventcount = 0L;
    protected long nextElementPointer = -1L;
    protected long chunkCountPointer = -1L;
    protected long chunkEventCount = 0L;
    protected long maxEventCount = 0L;
    protected File raFile;
    protected RandomAccessInputStream inStream;
    protected RandomAccessOutputStream outStream;
    protected boolean isFull = false;
    private Object LOCK = null;
    int count = 0;

    public static int getIndexListChunkSize() {
        return 1024;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public IndexList(File file, Object LOCK) throws IOException {
        this.LOCK = LOCK;
        this.initIndexList(file);
    }

    public void initIndexList(File file) {
        this.raFile = file;
        this.inStream = new RandomAccessInputStream(this.raFile);
        this.outStream = new RandomAccessOutputStream(this.raFile);
        this.indexElements.add(null);
    }

    public void close() throws IOException {
        this.inStream.close();
        this.outStream.close();
        DataServiceRAFilePool.getInstance().close(this.raFile);
    }

    public void readIndex(long startOffset) throws IOException {
        this.seekFilePointer(startOffset);
        long readNextChunkPointer = startOffset;
        long readChunkEventCount = -1L;
        long totalChunkCount = 1L;
        boolean chunkHeaderSuccess = false;
        do {
            long tempChunkCounterPointer = startOffset;
            try {
                readChunkEventCount = StreamUtils.readLong((InputStream)this.inStream);
                tempChunkCounterPointer = readNextChunkPointer;
                readNextChunkPointer = StreamUtils.readLong((InputStream)this.inStream);
                chunkHeaderSuccess = true;
            }
            catch (IOException ex) {
                chunkHeaderSuccess = false;
                System.err.println("Error while reading index header - skipping index block.");
                ex.printStackTrace();
            }
            if (!chunkHeaderSuccess) continue;
            this.chunkCountPointer = tempChunkCounterPointer;
            int i = 0;
            while ((long)i < readChunkEventCount) {
                IndexElement element = IndexElement.fromStream(this.inStream, totalChunkCount++);
                this.addToMemory(element);
                ++i;
            }
            this.nextElementPointer = DataServiceRAFilePool.getInstance().getFilePointer(this.raFile);
            this.chunkEventCount = readChunkEventCount;
            if (readNextChunkPointer < 0L) continue;
            this.seekFilePointer(readNextChunkPointer);
        } while (readNextChunkPointer > 0L && chunkHeaderSuccess);
        this.calculateMaxEventCount();
        this.checkIsFull();
    }

    private void calculateMaxEventCount() {
        this.maxEventCount = (long)(IndexList.getIndexListChunkSize() - 16) / IndexElement.getIndexElementSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPersistedEventCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.totalPersistedEventcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMemory(IndexElement element) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.indexElements.add(element);
            if (!IndexHelper.isAggregateChunk(element.chunkIndex)) {
                this.totalPersistedEventcount += (long)Chunk.EVENT_COUNT;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexElement removeLastElement() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            IndexElement element = this.indexElements.remove(this.indexElements.size() - 1);
            this.totalPersistedEventcount -= (long)Chunk.EVENT_COUNT;
            this.nextElementPointer -= IndexElement.getIndexElementSize();
            --this.chunkEventCount;
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIsFull() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.chunkEventCount == this.maxEventCount) {
                this.isFull = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNextElement(IndexElement element, boolean flush) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (!flush) {
                this.addToMemory(element);
            }
            this.seekFilePointer(this.nextElementPointer);
            element.toStream(this.outStream);
            this.outStream.flush();
            if (!flush) {
                this.nextElementPointer = DataServiceRAFilePool.getInstance().getFilePointer(this.raFile);
            }
            this.seekFilePointer(this.chunkCountPointer);
            if (flush) {
                StreamUtils.writeLong((OutputStream)this.outStream, (long)(this.chunkEventCount + 1L));
            } else {
                StreamUtils.writeLong((OutputStream)this.outStream, (long)(++this.chunkEventCount));
            }
            this.outStream.flush();
            if (!flush) {
                this.checkIsFull();
            }
        }
    }

    public long lookUpIndex(long eventIndex) {
        if (this.indexElements == null) {
            return -1L;
        }
        long chunkIndex = eventIndex / (long)Chunk.EVENT_COUNT;
        long numAggregates = chunkIndex / (long)(AggregateChunk.AGGREGATE_CHUNK_SPANS[0] - 1);
        return chunkIndex + numAggregates + 1L;
    }

    public IndexElement fetchIndexElement(long chunkIndex) {
        if (chunkIndex < 0L || chunkIndex >= (long)this.indexElements.size()) {
            return null;
        }
        return this.indexElements.get((int)chunkIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextPointer(long newChunkFilePointer) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.isFull = false;
            if (this.nextElementPointer != -1L) {
                this.seekFilePointer(this.chunkCountPointer + 8L);
                StreamUtils.writeLong((OutputStream)this.outStream, (long)newChunkFilePointer);
                this.outStream.flush();
            }
            this.nextElementPointer = newChunkFilePointer + 16L;
            this.chunkCountPointer = newChunkFilePointer;
            this.seekFilePointer(newChunkFilePointer);
            StreamUtils.writeLong((OutputStream)this.outStream, (long)0L);
            StreamUtils.writeLong((OutputStream)this.outStream, (long)0L);
            this.outStream.flush();
            this.chunkEventCount = 0L;
            this.calculateMaxEventCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndIndexChunkPointer() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.chunkCountPointer + 1024L;
        }
    }

    private void seekFilePointer(long fp) throws IOException {
        this.seekFilePointer(fp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekFilePointer(long fp, boolean isHeader) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            DataServiceRAFilePool.getInstance().seek(this.raFile, fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChunkCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.indexElements.size();
        }
    }

    public long getChunkForTimestamp(double timestamp) {
        return this.getChunkForTimestamp(timestamp, 1L, this.getChunkCount() - 1L);
    }

    private long getChunkForTimestamp(double timestamp, long startChunk, long endChunk) {
        if (startChunk <= endChunk) {
            long midChunk;
            IndexElement midElement;
            if (startChunk == endChunk) {
                return startChunk;
            }
            if (endChunk - startChunk <= 20L) {
                for (long i = startChunk; i <= endChunk; ++i) {
                    midElement = this.indexElements.get((int)i);
                    double end = midElement.endTime;
                    if (end > timestamp) {
                        return i;
                    }
                    if (i != endChunk) continue;
                    if (IndexHelper.isAggregateChunk(endChunk)) {
                        return endChunk - 1L;
                    }
                    return endChunk;
                }
            }
            if (IndexHelper.isAggregateChunk(midChunk = (endChunk - startChunk) / 2L + startChunk)) {
                midChunk = midChunk == endChunk ? --midChunk : ++midChunk;
            }
            midElement = this.indexElements.get((int)midChunk);
            if (timestamp > midElement.endTime) {
                if (midChunk == startChunk) {
                    return startChunk;
                }
                return this.getChunkForTimestamp(timestamp, midChunk, endChunk);
            }
            if (timestamp < midElement.startTime) {
                if (midChunk == endChunk) {
                    return endChunk;
                }
                return this.getChunkForTimestamp(timestamp, startChunk, midChunk);
            }
            return midChunk;
        }
        return startChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStartTime() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.indexElements.size() == 1) {
                return Double.NaN;
            }
            return this.indexElements.get(1).getStartTime();
        }
    }

    public double getLastElementEndTime() {
        if (this.indexElements.size() == 1) {
            return Double.NaN;
        }
        return this.indexElements.get(this.indexElements.size() - 1).getEndTime();
    }
}

