/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPrivateKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.ECUtil;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.interfaces.IESKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.BrokenKDF2BytesGenerator;
import org.bouncycastle.jce.provider.DHUtil;
import org.bouncycastle.jce.spec.IESParameterSpec;

public class JCEIESCipher
extends CipherSpi {
    private IESEngine cipher;
    private int state = -1;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private AlgorithmParameters engineParam = null;
    private IESParameterSpec engineParams = null;
    private Class[] availableSpecs = new Class[]{IESParameterSpec.class};

    public JCEIESCipher(IESEngine engine) {
        this.cipher = engine;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        if (!(key instanceof IESKey)) {
            throw new IllegalArgumentException("must be passed IE key");
        }
        IESKey ieKey = (IESKey)key;
        if (ieKey.getPrivate() instanceof DHPrivateKey) {
            DHPrivateKey k = (DHPrivateKey)ieKey.getPrivate();
            return k.getX().bitLength();
        }
        if (ieKey.getPrivate() instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)ieKey.getPrivate();
            return k.getD().bitLength();
        }
        throw new IllegalArgumentException("not an IE key!");
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (this.state == 1 || this.state == 3) {
            return this.buffer.size() + inputLen + 20;
        }
        if (this.state == 2 || this.state == 4) {
            return this.buffer.size() + inputLen - 20;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParam == null && this.engineParams != null) {
            String name = "IES";
            try {
                this.engineParam = AlgorithmParameters.getInstance(name, BouncyCastleProvider.PROVIDER_NAME);
                this.engineParam.init(this.engineParams);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParam;
    }

    @Override
    protected void engineSetMode(String mode) {
        throw new IllegalArgumentException("can't support mode " + mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException(padding + " unavailable with RSA.");
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter privKey;
        AsymmetricKeyParameter pubKey;
        if (!(key instanceof IESKey)) {
            throw new InvalidKeyException("must be passed IES key");
        }
        if (params == null && (opmode == 1 || opmode == 3)) {
            byte[] d = new byte[16];
            byte[] e = new byte[16];
            if (random == null) {
                random = new SecureRandom();
            }
            random.nextBytes(d);
            random.nextBytes(e);
            params = new IESParameterSpec(d, e, 128);
        } else if (!(params instanceof IESParameterSpec)) {
            throw new InvalidAlgorithmParameterException("must be passed IES parameters");
        }
        IESKey ieKey = (IESKey)key;
        if (ieKey.getPublic() instanceof ECPublicKey) {
            pubKey = ECUtil.generatePublicKeyParameter(ieKey.getPublic());
            privKey = ECUtil.generatePrivateKeyParameter(ieKey.getPrivate());
        } else {
            pubKey = DHUtil.generatePublicKeyParameter(ieKey.getPublic());
            privKey = DHUtil.generatePrivateKeyParameter(ieKey.getPrivate());
        }
        this.engineParams = (IESParameterSpec)params;
        IESParameters p = new IESParameters(this.engineParams.getDerivationV(), this.engineParams.getEncodingV(), this.engineParams.getMacKeySize());
        this.state = opmode;
        this.buffer.reset();
        switch (opmode) {
            case 1: 
            case 3: {
                this.cipher.init(true, (CipherParameters)privKey, (CipherParameters)pubKey, p);
                break;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, (CipherParameters)privKey, (CipherParameters)pubKey, p);
                break;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i = 0; i != this.availableSpecs.length; ++i) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineParam = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (opmode == 1 || opmode == 3) {
            try {
                this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("can't handle null parameter spec in IES");
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.buffer.write(input, inputOffset, inputLen);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.buffer.write(input, inputOffset, inputLen);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (inputLen != 0) {
            this.buffer.write(input, inputOffset, inputLen);
        }
        try {
            byte[] buf = this.buffer.toByteArray();
            this.buffer.reset();
            return this.cipher.processBlock(buf, 0, buf.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        if (inputLen != 0) {
            this.buffer.write(input, inputOffset, inputLen);
        }
        try {
            byte[] buf = this.buffer.toByteArray();
            this.buffer.reset();
            buf = this.cipher.processBlock(buf, 0, buf.length);
            System.arraycopy(buf, 0, output, outputOffset, buf.length);
            return buf.length;
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    public static class IES
    extends JCEIESCipher {
        public IES() {
            super(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest())));
        }
    }

    public static class BrokenIES
    extends JCEIESCipher {
        public BrokenIES() {
            super(new IESEngine(new DHBasicAgreement(), new BrokenKDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest())));
        }
    }

    public static class BrokenECIES
    extends JCEIESCipher {
        public BrokenECIES() {
            super(new IESEngine(new ECDHBasicAgreement(), new BrokenKDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest())));
        }
    }
}

