/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Arrays;

abstract class GCMUtil {
    GCMUtil() {
    }

    static byte[] oneAsBytes() {
        byte[] tmp = new byte[16];
        tmp[0] = -128;
        return tmp;
    }

    static int[] oneAsInts() {
        int[] tmp = new int[4];
        tmp[0] = Integer.MIN_VALUE;
        return tmp;
    }

    static byte[] asBytes(int[] ns) {
        byte[] output = new byte[16];
        Pack.intToBigEndian((int[])ns, (byte[])output, (int)0);
        return output;
    }

    static int[] asInts(byte[] bs) {
        int[] output = new int[4];
        Pack.bigEndianToInt((byte[])bs, (int)0, (int[])output);
        return output;
    }

    static void asInts(byte[] bs, int[] output) {
        Pack.bigEndianToInt((byte[])bs, (int)0, (int[])output);
    }

    static void multiply(byte[] block, byte[] val) {
        byte[] tmp = Arrays.clone((byte[])block);
        byte[] c = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byte bits = val[i];
            for (int j = 7; j >= 0; --j) {
                if ((bits & 1 << j) != 0) {
                    GCMUtil.xor(c, tmp);
                }
                boolean lsb = (tmp[15] & 1) != 0;
                GCMUtil.shiftRight(tmp);
                if (!lsb) continue;
                tmp[0] = (byte)(tmp[0] ^ 0xFFFFFFE1);
            }
        }
        System.arraycopy(c, 0, block, 0, 16);
    }

    static void multiplyP(int[] x) {
        boolean lsb = (x[3] & 1) != 0;
        GCMUtil.shiftRight(x);
        if (lsb) {
            x[0] = x[0] ^ 0xE1000000;
        }
    }

    static void multiplyP(int[] x, int[] output) {
        boolean lsb = (x[3] & 1) != 0;
        GCMUtil.shiftRight(x, output);
        if (lsb) {
            output[0] = output[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] x) {
        int lsw = x[3];
        GCMUtil.shiftRightN(x, 8);
        for (int i = 7; i >= 0; --i) {
            if ((lsw & 1 << i) == 0) continue;
            x[0] = x[0] ^ -520093696 >>> 7 - i;
        }
    }

    static void multiplyP8(int[] x, int[] output) {
        int lsw = x[3];
        GCMUtil.shiftRightN(x, 8, output);
        for (int i = 7; i >= 0; --i) {
            if ((lsw & 1 << i) == 0) continue;
            output[0] = output[0] ^ -520093696 >>> 7 - i;
        }
    }

    static void shiftRight(byte[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i] & 0xFF;
            block[i] = (byte)(b >>> 1 | bit);
            if (++i == 16) break;
            bit = (b & 1) << 7;
        }
    }

    static void shiftRight(byte[] block, byte[] output) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i] & 0xFF;
            output[i] = (byte)(b >>> 1 | bit);
            if (++i == 16) break;
            bit = (b & 1) << 7;
        }
    }

    static void shiftRight(int[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i];
            block[i] = b >>> 1 | bit;
            if (++i == 4) break;
            bit = b << 31;
        }
    }

    static void shiftRight(int[] block, int[] output) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i];
            output[i] = b >>> 1 | bit;
            if (++i == 4) break;
            bit = b << 31;
        }
    }

    static void shiftRightN(int[] block, int n) {
        int i = 0;
        int bits = 0;
        while (true) {
            int b = block[i];
            block[i] = b >>> n | bits;
            if (++i == 4) break;
            bits = b << 32 - n;
        }
    }

    static void shiftRightN(int[] block, int n, int[] output) {
        int i = 0;
        int bits = 0;
        while (true) {
            int b = block[i];
            output[i] = b >>> n | bits;
            if (++i == 4) break;
            bits = b << 32 - n;
        }
    }

    static void xor(byte[] block, byte[] val) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            block[n] = (byte)(block[n] ^ val[i]);
        }
    }

    static void xor(byte[] block, byte[] val, int off, int len) {
        while (len-- > 0) {
            int n = len;
            block[n] = (byte)(block[n] ^ val[off + len]);
        }
    }

    static void xor(byte[] block, byte[] val, byte[] output) {
        for (int i = 15; i >= 0; --i) {
            output[i] = (byte)(block[i] ^ val[i]);
        }
    }

    static void xor(int[] block, int[] val) {
        for (int i = 3; i >= 0; --i) {
            int n = i;
            block[n] = block[n] ^ val[i];
        }
    }

    static void xor(int[] block, int[] val, int[] output) {
        for (int i = 3; i >= 0; --i) {
            output[i] = block[i] ^ val[i];
        }
    }
}

