/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.EphemeralKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyParser;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class IESEngine {
    BasicAgreement agree;
    DerivationFunction kdf;
    Mac mac;
    BufferedBlockCipher cipher;
    byte[] macBuf;
    boolean forEncryption;
    CipherParameters privParam;
    CipherParameters pubParam;
    IESParameters param;
    byte[] V;
    private EphemeralKeyPairGenerator keyPairGenerator;
    private KeyParser keyParser;

    public IESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac) {
        this.agree = agree;
        this.kdf = kdf;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = null;
    }

    public IESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac, BufferedBlockCipher cipher) {
        this.agree = agree;
        this.kdf = kdf;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = cipher;
    }

    public void init(boolean forEncryption, CipherParameters privParam, CipherParameters pubParam, CipherParameters param) {
        this.forEncryption = forEncryption;
        this.privParam = privParam;
        this.pubParam = pubParam;
        this.param = (IESParameters)param;
        this.V = new byte[0];
    }

    public void init(AsymmetricKeyParameter publicKey, CipherParameters params, EphemeralKeyPairGenerator ephemeralKeyPairGenerator) {
        this.forEncryption = true;
        this.pubParam = publicKey;
        this.param = (IESParameters)params;
        this.keyPairGenerator = ephemeralKeyPairGenerator;
    }

    public void init(AsymmetricKeyParameter privateKey, CipherParameters params, KeyParser publicKeyParser) {
        this.forEncryption = false;
        this.privParam = privateKey;
        this.param = (IESParameters)params;
        this.keyParser = publicKeyParser;
    }

    public BufferedBlockCipher getCipher() {
        return this.cipher;
    }

    public Mac getMac() {
        return this.mac;
    }

    private byte[] encryptBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int len;
        byte[] C = null;
        byte[] K = null;
        byte[] K1 = null;
        byte[] K2 = null;
        if (this.cipher == null) {
            K1 = new byte[inLen];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            if (this.V.length != 0) {
                System.arraycopy(K, 0, K2, 0, K2.length);
                System.arraycopy(K, K2.length, K1, 0, K1.length);
            } else {
                System.arraycopy(K, 0, K1, 0, K1.length);
                System.arraycopy(K, inLen, K2, 0, K2.length);
            }
            C = new byte[inLen];
            for (int i = 0; i != inLen; ++i) {
                C[i] = (byte)(in[inOff + i] ^ K1[i]);
            }
            len = inLen;
        } else {
            K1 = new byte[((IESWithCipherParameters)this.param).getCipherKeySize() / 8];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            System.arraycopy(K, 0, K1, 0, K1.length);
            System.arraycopy(K, K1.length, K2, 0, K2.length);
            this.cipher.init(true, (CipherParameters)new KeyParameter(K1));
            C = new byte[this.cipher.getOutputSize(inLen)];
            len = this.cipher.processBytes(in, inOff, inLen, C, 0);
            len += this.cipher.doFinal(C, len);
        }
        byte[] P2 = this.param.getEncodingV();
        byte[] L2 = new byte[4];
        if (this.V.length != 0) {
            if (P2 == null) {
                Pack.intToBigEndian((int)0, (byte[])L2, (int)0);
            } else {
                Pack.intToBigEndian((int)(P2.length * 8), (byte[])L2, (int)0);
            }
        }
        byte[] T = new byte[this.mac.getMacSize()];
        this.mac.init((CipherParameters)new KeyParameter(K2));
        this.mac.update(C, 0, C.length);
        if (P2 != null) {
            this.mac.update(P2, 0, P2.length);
        }
        if (this.V.length != 0) {
            this.mac.update(L2, 0, L2.length);
        }
        this.mac.doFinal(T, 0);
        byte[] Output = new byte[this.V.length + len + T.length];
        System.arraycopy(this.V, 0, Output, 0, this.V.length);
        System.arraycopy(C, 0, Output, this.V.length, len);
        System.arraycopy(T, 0, Output, this.V.length + len, T.length);
        return Output;
    }

    private byte[] decryptBlock(byte[] in_enc, int inOff, int inLen) throws InvalidCipherTextException {
        int len;
        byte[] M = null;
        byte[] K = null;
        byte[] K1 = null;
        byte[] K2 = null;
        if (this.cipher == null) {
            K1 = new byte[inLen - this.V.length - this.mac.getMacSize()];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            if (this.V.length != 0) {
                System.arraycopy(K, 0, K2, 0, K2.length);
                System.arraycopy(K, K2.length, K1, 0, K1.length);
            } else {
                System.arraycopy(K, 0, K1, 0, K1.length);
                System.arraycopy(K, K1.length, K2, 0, K2.length);
            }
            M = new byte[K1.length];
            for (int i = 0; i != K1.length; ++i) {
                M[i] = (byte)(in_enc[inOff + this.V.length + i] ^ K1[i]);
            }
            len = K1.length;
        } else {
            K1 = new byte[((IESWithCipherParameters)this.param).getCipherKeySize() / 8];
            K2 = new byte[this.param.getMacKeySize() / 8];
            K = new byte[K1.length + K2.length];
            this.kdf.generateBytes(K, 0, K.length);
            System.arraycopy(K, 0, K1, 0, K1.length);
            System.arraycopy(K, K1.length, K2, 0, K2.length);
            this.cipher.init(false, (CipherParameters)new KeyParameter(K1));
            M = new byte[this.cipher.getOutputSize(inLen - this.V.length - this.mac.getMacSize())];
            len = this.cipher.processBytes(in_enc, inOff + this.V.length, inLen - this.V.length - this.mac.getMacSize(), M, 0);
            len += this.cipher.doFinal(M, len);
        }
        byte[] P2 = this.param.getEncodingV();
        byte[] L2 = new byte[4];
        if (this.V.length != 0) {
            if (P2 != null) {
                Pack.intToBigEndian((int)(P2.length * 8), (byte[])L2, (int)0);
            } else {
                Pack.intToBigEndian((int)0, (byte[])L2, (int)0);
            }
        }
        byte[] T1 = new byte[this.mac.getMacSize()];
        System.arraycopy(in_enc, inOff + inLen - T1.length, T1, 0, T1.length);
        byte[] T2 = new byte[T1.length];
        this.mac.init((CipherParameters)new KeyParameter(K2));
        this.mac.update(in_enc, inOff + this.V.length, inLen - this.V.length - T2.length);
        if (P2 != null) {
            this.mac.update(P2, 0, P2.length);
        }
        if (this.V.length != 0) {
            this.mac.update(L2, 0, L2.length);
        }
        this.mac.doFinal(T2, 0);
        if (!Arrays.areEqual((byte[])T1, (byte[])T2)) {
            throw new InvalidCipherTextException("Invalid MAC.");
        }
        byte[] Output = new byte[len];
        System.arraycopy(M, 0, Output, 0, len);
        return Output;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            if (this.keyPairGenerator != null) {
                EphemeralKeyPair ephKeyPair = this.keyPairGenerator.generate();
                this.privParam = ephKeyPair.getKeyPair().getPrivate();
                this.V = ephKeyPair.getEncodedPublicKey();
            }
        } else if (this.keyParser != null) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(in, inOff, inLen);
            try {
                this.pubParam = this.keyParser.readKey(bIn);
            }
            catch (IOException e) {
                throw new InvalidCipherTextException("unable to recover ephemeral public key: " + e.getMessage(), (Throwable)e);
            }
            int encLength = inLen - bIn.available();
            this.V = new byte[encLength];
            System.arraycopy(in, inOff, this.V, 0, this.V.length);
        }
        this.agree.init(this.privParam);
        BigInteger z = this.agree.calculateAgreement(this.pubParam);
        byte[] Z = BigIntegers.asUnsignedByteArray((int)this.agree.getFieldSize(), (BigInteger)z);
        byte[] VZ = null;
        if (this.V.length != 0) {
            VZ = new byte[this.V.length + Z.length];
            System.arraycopy(this.V, 0, VZ, 0, this.V.length);
            System.arraycopy(Z, 0, VZ, this.V.length, Z.length);
        } else {
            VZ = Z;
        }
        KDFParameters kdfParam = new KDFParameters(VZ, this.param.getDerivationV());
        this.kdf.init(kdfParam);
        return this.forEncryption ? this.encryptBlock(in, inOff, inLen) : this.decryptBlock(in, inOff, inLen);
    }
}

