/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.streamenc;

import com.aem.utils.streamenc.ChunkFilterUtils;
import com.aem.utils.streamenc.UnpairedChunkFilter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PriorityFilter
implements UnpairedChunkFilter {
    public static final long YIELD = -1L;
    long read_wt;
    long write_wt;
    int read_freq;
    int write_freq;
    int n = 0;

    public PriorityFilter(long read_wt, int read_freq, long write_wt, int write_freq) {
        this.read_wt = read_wt;
        this.write_wt = write_wt;
        this.read_freq = read_freq;
        this.write_freq = write_freq;
    }

    @Override
    public byte[] readChunk(InputStream in) throws IOException {
        --this.n;
        if (this.n <= 0) {
            this.n = this.read_freq;
            if (this.read_wt == -1L) {
                Thread.yield();
            } else {
                try {
                    Thread.sleep(this.read_wt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            return ChunkFilterUtils.readBytes(in);
        }
        catch (EOFException e) {
            return null;
        }
    }

    @Override
    public void writeChunk(byte[] dat, OutputStream out) throws IOException {
        out.write(dat);
        --this.n;
        if (this.n <= 0) {
            this.n = this.write_freq;
            if (this.write_wt == -1L) {
                Thread.yield();
            } else {
                try {
                    Thread.sleep(this.write_wt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

