/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.gui.verifiers;

import java.text.DecimalFormat;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DigitDocument
extends PlainDocument {
    boolean commaSeparated;
    boolean includeDecimals = false;
    private DecimalFormat df;

    public DigitDocument(boolean commaSeparated, boolean includeDecimals) {
        this.commaSeparated = commaSeparated;
        this.includeDecimals = includeDecimals;
        this.df = new DecimalFormat();
    }

    public DigitDocument(boolean commaSeparated) {
        this(commaSeparated, false);
    }

    public DigitDocument() {
        this(false, false);
    }

    private boolean isDecimalSeparator(char c) {
        return this.df.getDecimalFormatSymbols().getDecimalSeparator() == c || c == '.' || c == ',';
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        char[] addedFigures = str.toCharArray();
        for (int i = addedFigures.length; i > 0; --i) {
            char c = addedFigures[i - 1];
            boolean includeDecimalPoint = false;
            if (this.includeDecimals && this.isDecimalSeparator(c)) {
                String text = this.getText(0, this.getLength());
                int firstIndex = text.indexOf(c);
                if (firstIndex != -1) {
                    int nextIndex = text.indexOf(c, firstIndex);
                    if (nextIndex == -1) {
                        includeDecimalPoint = true;
                    }
                } else {
                    includeDecimalPoint = true;
                }
            }
            if (!Character.isDigit(c) && (!this.commaSeparated || c != ',') && !includeDecimalPoint) continue;
            super.insertString(offs, new String(new Character(c).toString()), a);
        }
    }
}

