/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JFrame;
import utils.swing.SwingUtil;

public class FullFrame
extends JFrame {
    public static final int EXCLUSIVE = 0;
    public static final int FULL = 1;
    public static final int DECORATED = 2;
    private GraphicsDevice defaultDevice = null;
    private int mode = 0;
    GraphicsDevice fullScreenDevice = null;

    public FullFrame() {
        this("");
    }

    public FullFrame(String title) {
        this(title, 0, true);
    }

    public FullFrame(String title, int mode, boolean setVisible) {
        super(title);
        this.fullframe_setup(mode, setVisible);
        this.setBackColor(Color.black);
    }

    public FullFrame(GraphicsConfiguration gc) {
        this("", gc);
    }

    public FullFrame(String title, GraphicsConfiguration gc) {
        this(title, 0, gc);
    }

    public FullFrame(String title, int mode, GraphicsConfiguration gc) {
        super(title, gc);
        this.fullframe_setup(mode, true);
        this.setBackColor(Color.black);
    }

    private void fullframe_setup(int mode, boolean setVisible) {
        this.setDefaultCloseOperation(3);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.defaultDevice = env.getDefaultScreenDevice();
        this.setMode(mode, setVisible);
    }

    public void setBackColor(Color c) {
        this.getContentPane().setBackground(c);
        this.setBackground(c);
    }

    public boolean isFullScreenCapable() {
        try {
            return this.defaultDevice.isFullScreenSupported();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void setMode(int mode) {
        this.setMode(mode, true);
    }

    public void setMode(int mode, boolean setVisible) {
        try {
            boolean isDisp = this.isDisplayable();
            this.mode = mode;
            switch (mode) {
                case 0: {
                    if (isDisp) {
                        this.dispose();
                    }
                    try {
                        this.fullScreenDevice = SwingUtil.getGraphicsDeviceFor((Component)this);
                        if (this.fullScreenDevice != null) {
                            if (this.fullScreenDevice.isFullScreenSupported()) {
                                this.setUndecorated(true);
                                this.setResizable(false);
                                System.out.println("[FullFrame] Setting " + this + " to be full screen on " + this.fullScreenDevice + " / " + this.fullScreenDevice.getDefaultConfiguration());
                                this.fullScreenDevice.setFullScreenWindow(this);
                                break;
                            }
                            System.out.println("[FullFrame] Full screen is NOT SUPPORTED on " + this.fullScreenDevice + " / " + this.fullScreenDevice.getDefaultConfiguration());
                            break;
                        }
                        System.out.println("[FullFrame] GraphicsDevice returned from SwingUtil was NULL");
                    }
                    catch (Throwable t) {
                        System.out.println("full screen mode failed " + t);
                    }
                    break;
                }
                case 1: {
                    if (isDisp) {
                        this.dispose();
                    }
                    try {
                        this.setUndecorated(true);
                        this.setResizable(false);
                        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
                        this.setLocation(screenInsets.left, screenInsets.top);
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        this.setSize(new Dimension(screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom));
                        if (setVisible) {
                            this.setVisible(true);
                        }
                        this.mode = 1;
                        break;
                    }
                    catch (Throwable t) {
                        System.out.println("fake full screen mode failed " + t);
                    }
                }
                case 2: {
                    try {
                        if (this.fullScreenDevice != null) {
                            this.fullScreenDevice.setFullScreenWindow(null);
                        }
                        if (isDisp) {
                            this.dispose();
                        }
                        this.setUndecorated(false);
                        if (setVisible) {
                            this.setVisible(true);
                        }
                    }
                    catch (Throwable t) {
                        System.out.println("decorated mode failed " + t);
                    }
                    this.setResizable(true);
                }
            }
            if (isDisp) {
                this.validate();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int getMode() {
        return this.mode;
    }
}

