/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.authentication;

import com.aem.utils.authentication.LDAPProperties;
import com.aem.utils.authentication.LDAPSSlSocketFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.TrustManager;

public class LDAPAuthenticator {
    private final LDAPAttributeMappingProvider mappingProvider;
    private final TrustManager[] trustManagers;
    private String ldapHost = "localhost";
    private int ldapPort = 389;
    private Hashtable<String, String> env = new Hashtable();
    private String ldapManagerPassword;
    private String ldapManagerUsername;
    private static final Object LOCK = new Object();
    private String groupClass;
    private String loginAttribute;
    private String memberAttribute;

    public LDAPAuthenticator(String hostname, int port, String ldapAuthenticationMechanism, boolean ssl, String ldapManagerUsername, String ldapManagerPassword, String groupClass, String loginAttribute, String memberAttribute, boolean followReferralLinks, LDAPAttributeMappingProvider mappingProvider, TrustManager[] trustManagers, boolean isTestConnection) {
        this.trustManagers = trustManagers;
        this.groupClass = groupClass;
        this.loginAttribute = loginAttribute;
        this.memberAttribute = memberAttribute;
        this.mappingProvider = mappingProvider;
        System.out.println("[LDAPAuthenticator] Initialising " + hostname + "," + port + "," + ldapAuthenticationMechanism + "," + ssl);
        if (hostname != null && hostname.startsWith("ldap://")) {
            hostname = hostname.substring("ldap://".length(), hostname.length());
        }
        if (hostname != null && hostname.startsWith("ldaps://")) {
            hostname = hostname.substring("ldaps://".length(), hostname.length());
        }
        if (hostname != null && hostname.endsWith("/")) {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        this.ldapHost = hostname;
        this.ldapPort = port;
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (ssl) {
            this.env.put("java.naming.provider.url", "ldaps://" + this.ldapHost + ":" + this.ldapPort);
        } else {
            this.env.put("java.naming.provider.url", "ldap://" + this.ldapHost + ":" + this.ldapPort);
        }
        if (followReferralLinks) {
            this.env.put("java.naming.referral", "follow");
        } else {
            this.env.put("java.naming.referral", "ignore");
        }
        if (isTestConnection) {
            this.env.put("com.sun.jndi.ldap.read.timeout", "10000");
            this.env.put("com.sun.jndi.ldap.connect.timeout", "10000");
        } else {
            this.env.put("com.sun.jndi.ldap.read.timeout", "30000");
            this.env.put("com.sun.jndi.ldap.connect.timeout", "30000");
        }
        if (trustManagers != null && ssl) {
            LDAPSSlSocketFactory.trustManagers = trustManagers;
            this.env.put("java.naming.ldap.factory.socket", "com.aem.utils.authentication.LDAPSSlSocketFactory");
        }
        this.ldapManagerUsername = ldapManagerUsername;
        this.ldapManagerPassword = ldapManagerPassword;
        System.out.println("[LDAPAuthenticator] Using Security Principal: " + ldapManagerUsername);
        if (ldapAuthenticationMechanism != null) {
            if (ldapAuthenticationMechanism.trim().toLowerCase().equals("none")) {
                this.env.put("java.naming.security.authentication", "simple");
            } else {
                this.env.put("java.naming.security.authentication", ldapAuthenticationMechanism);
            }
        }
        if (ssl) {
            this.env.put("java.naming.security.protocol", "ssl");
        }
    }

    private static int getErrorCode(String msg) {
        if (msg == null) {
            return -1;
        }
        int start = msg.indexOf("error code") + 10;
        if (start == -1) {
            return -1;
        }
        int end = msg.indexOf(45, start);
        if (end == -1) {
            return -1;
        }
        String subString = msg.substring(start, end);
        try {
            return Integer.parseInt(subString.trim());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static String getErrorFromException(Throwable tt) {
        String msg = null;
        if (tt instanceof NamingException) {
            msg = LDAPAuthenticator.getFriendlyError((NamingException)tt);
            if (msg == null) {
                msg = tt.getCause() != null ? tt.getCause().getMessage() : tt.getMessage();
            }
        } else {
            msg = tt.getMessage();
        }
        if (msg == null) {
            msg = "Unknown";
        }
        return msg;
    }

    public static String getFriendlyError(NamingException ex) {
        int errorCode = -1;
        Throwable t = ex.getRootCause();
        if (t != null) {
            errorCode = LDAPAuthenticator.getErrorCode(t.getMessage());
        }
        if (errorCode == -1) {
            errorCode = LDAPAuthenticator.getErrorCode(ex.getMessage());
        }
        if (errorCode == -1 && ex.getCause() != null) {
            errorCode = LDAPAuthenticator.getErrorCode(ex.getCause().getMessage());
        }
        switch (errorCode) {
            case 0: {
                return "Success";
            }
            case 1: {
                return "An operations error occurred";
            }
            case 2: {
                return "A communications error has occurred due to a protocol error";
            }
            case 3: {
                return "Time limit exceeded.";
            }
            case 4: {
                return "Size limit exceeded.";
            }
            case 7: {
                return "Authentication method not supported.";
            }
            case 8: {
                return "Strong authentication required.";
            }
            case 9: {
                return "Partial results being returned.";
            }
            case 11: {
                return "Administrative limit exceeded.";
            }
            case 12: {
                return "Unavailable critical extension requested.";
            }
            case 13: {
                return "Confidentiality required.";
            }
            case 14: {
                return "SASL bind in progress.";
            }
            case 16: {
                return "No such attribute exists.";
            }
            case 17: {
                return "An undefined attribute type.";
            }
            case 18: {
                return "Inappropriate matching";
            }
            case 19: {
                return "A constraint violation.";
            }
            case 20: {
                return "An attribute or value already in use.";
            }
            case 21: {
                return "An invalid attribute syntax.";
            }
            case 32: {
                return "No such object exists.";
            }
            case 33: {
                return "Alias problem";
            }
            case 34: {
                return "An invalid DN syntax.";
            }
            case 36: {
                return "Alias dereferencing problem";
            }
            case 48: {
                return "Inappropriate authentication";
            }
            case 49: {
                return "Invalid authentication credentials";
            }
            case 50: {
                return "Insufficient access rights";
            }
            case 53: {
                return "Operation not supported";
            }
            case 54: {
                return "Loop detected.";
            }
            case 64: {
                return "Naming violation";
            }
            case 65: {
                return "Object class violation";
            }
            case 66: {
                return "Not allowed on non-leaf.";
            }
            case 67: {
                return "Not allowed on RDN.";
            }
            case 68: {
                return "Entry already exists.";
            }
            case 69: {
                return "Object class modifications prohibited.";
            }
            case 71: {
                return "Affects multiple DSAs.";
            }
        }
        return null;
    }

    private String processNamingException(NamingException ex) {
        String error;
        Throwable root = ex.getRootCause();
        String explanation = ex.getExplanation();
        String friendlyError = LDAPAuthenticator.getFriendlyError(ex);
        if (friendlyError != null) {
            error = "Unable to establish connection to LDAP directory due to '" + friendlyError;
            error = error + "\n\tCause: " + ex;
        } else {
            error = "Unable to establish connection to LDAP directory due to " + ex;
        }
        if (root != null) {
            error = error + "\n\tRoot Cause: " + root;
        }
        if (explanation != null) {
            error = error + "\n\tExplanation: " + explanation;
        }
        return error;
    }

    public DirContext openConnectionToServer() throws Exception {
        return this.connectToServer(this.ldapManagerUsername, this.ldapManagerPassword);
    }

    public void closeConnectionToServer(DirContext dir) {
        if (dir != null) {
            LDAPAuthenticator.disconnect(dir);
        }
    }

    public boolean testConnectToServer() throws Exception {
        DirContext dir = null;
        try {
            dir = this.openConnectionToServer();
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeConnectionToServer(dir);
        }
    }

    public LDAPUser authenticate(String username, String pwd, LDAPProperties props) throws Exception {
        long start = System.currentTimeMillis();
        if (pwd == null || pwd.length() == 0) {
            System.out.println("[LDAPAuthenticator] Cannot authenticate users with an empty password.");
            throw new Exception("Empty passwords not allowed.");
        }
        System.out.println("[LDAPAuthenticator] Performing LDAP authentication for user " + username);
        System.out.println("[LDAPAuthenticator] Identifying all matching LDAP usernames according to searchForUsers filter");
        ArrayList<LDAPUser> usernames = this.getMatchingLDAPUsernames(username, props);
        if (usernames == null || usernames.size() == 0) {
            System.out.println("[LDAPAuthenticator] No matching ldap users found.");
            throw new Exception("No matching user found.");
        }
        for (int i = 0; i < usernames.size(); ++i) {
            LDAPUser user = usernames.get(i);
            DirContext dir = null;
            try {
                System.out.println("[LDAPAuthenticator] Attempting login for LDAP user " + (i + 1));
                dir = this.connectToServer(user.nameInNameSpace, pwd);
                LDAPAuthenticator.disconnect(dir);
                System.out.println("[LDAPAuthenticator] Login succesful. Total LDAP authentication time was " + (System.currentTimeMillis() - start) + "ms");
                return user;
            }
            catch (Exception e) {
                LDAPAuthenticator.disconnect(dir);
                continue;
            }
        }
        System.out.println("[LDAPAuthenticator] None of the " + usernames.size() + " usernames were authenticated sucessfully.");
        return null;
    }

    private ArrayList<LDAPUser> getMatchingLDAPUsernames(String username, LDAPProperties props) throws Exception {
        LDAPProperties ldapProperties = (LDAPProperties)props.clone();
        String filter = ldapProperties.filter;
        if (ldapProperties.isSimple()) {
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append("(").append(this.loginAttribute).append("=").append(username).append(")");
            if (props.groups != null && props.groups.length > 0) {
                filterBuilder.insert(0, "(&");
                for (String group : props.groups) {
                    filterBuilder.append("(").append(this.memberAttribute).append("=").append(group).append(")");
                }
                filterBuilder.append(")");
            }
            filter = filterBuilder.toString();
        } else if (filter != null && filter.trim().length() != 0) {
            filter = filter.replaceAll("\\$\\{Username\\}", username);
        }
        DirContext dir = null;
        try {
            String[] stringArray;
            if (this.ldapManagerUsername == null || this.ldapManagerPassword == null) {
                stringArray = new ArrayList();
                return stringArray;
            }
            dir = this.connectToServer(this.ldapManagerUsername, this.ldapManagerPassword);
            stringArray = this.searchForUsers(dir, ldapProperties.baseDN, filter);
            LDAPAuthenticator.disconnect(dir);
            return stringArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            LDAPAuthenticator.disconnect(dir);
        }
    }

    public static String[] getBaseDNs(DirContext dir) {
        try {
            ArrayList<String> children = new ArrayList<String>();
            Attributes attributes = dir.getAttributes("", new String[]{"namingContexts"});
            Attribute attribute = attributes.get("namingContexts");
            NamingEnumeration<?> all = attribute.getAll();
            while (all.hasMore()) {
                String next = (String)all.next();
                children.add(next);
            }
            return children.toArray(new String[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public ArrayList<LDAPUser> getAllMatchingLDAPUsernames(LDAPProperties props) {
        LDAPProperties ldapProperties = (LDAPProperties)props.clone();
        if (ldapProperties.filter != null && ldapProperties.filter.trim().length() != 0) {
            ldapProperties.filter = ldapProperties.filter.replaceAll("\\$\\{Username\\}", "*");
        }
        DirContext dir = null;
        try {
            dir = this.connectToServer(this.ldapManagerUsername, this.ldapManagerPassword);
            ArrayList<LDAPUser> sampleUsernames = this.searchForUsers(dir, ldapProperties.baseDN, ldapProperties.filter);
            LDAPAuthenticator.disconnect(dir);
            return sampleUsernames;
        }
        catch (Exception e) {
            e.printStackTrace();
            LDAPAuthenticator.disconnect(dir);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disconnect(DirContext ctx) {
        Object object = LOCK;
        synchronized (object) {
            if (ctx != null) {
                try {
                    System.out.println("[LDAPAuthenticator] Closing connection to LDAP Directory");
                    ctx.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private DirContext connectToServer(String username, String password) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            InitialDirContext ctx = null;
            try {
                this.env.put("java.naming.security.principal", username);
                this.env.put("java.naming.security.credentials", password);
                System.out.println("[LDAPAuthenticator] Opening directory context");
                ctx = new InitialDirContext(this.env);
                return ctx;
            }
            catch (Exception t) {
                if (t instanceof NamingException) {
                    System.out.println("[LDAPAuthenticator] Connecting to LDAP Directory FAILED: " + this.processNamingException((NamingException)t));
                } else {
                    t.printStackTrace();
                }
                if (ctx != null) {
                    LDAPAuthenticator.disconnect(ctx);
                }
                throw t;
            }
        }
    }

    public static LDAPSearchResult[] search(DirContext dir, String baseDN, String filter) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setReturningObjFlag(true);
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = dir.search(baseDN, filter, constraints);
        int answerCount = 0;
        ArrayList<LDAPSearchResult> results = new ArrayList<LDAPSearchResult>();
        while (answer.hasMoreElements()) {
            SearchResult result = answer.next();
            ++answerCount;
            LDAPSearchResult searchResult = new LDAPSearchResult();
            searchResult.CN = String.valueOf(result.getAttributes().get("cn").get());
            searchResult.DN = result.getNameInNamespace();
            results.add(searchResult);
        }
        System.out.println("[LDAPAuthenticator] LDAP directory search produced " + answerCount + " results.");
        return results.toArray(new LDAPSearchResult[0]);
    }

    private ArrayList<LDAPUser> searchForUsers(DirContext dir, String baseDN, String filter) throws Exception {
        System.out.println("[LDAPAuthenticator] Searching LDAP directory...");
        long start = System.currentTimeMillis();
        SearchControls constraints = new SearchControls();
        constraints.setReturningObjFlag(true);
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = dir.search(baseDN, filter, constraints);
        ArrayList<LDAPUser> returnList = new ArrayList<LDAPUser>();
        while (answer.hasMoreElements()) {
            SearchResult result = answer.next();
            LDAPUser user = this.extractLDAPUserDetails(result);
            returnList.add(user);
        }
        long diff = System.currentTimeMillis() - start;
        System.out.println("[LDAPAuthenticator] Found " + returnList.size() + " users (searchForUsers took " + diff + "ms).");
        return returnList;
    }

    private LDAPUser extractLDAPUserDetails(SearchResult result) {
        String[] keys;
        Attributes atts = result.getAttributes();
        LDAPUser user = new LDAPUser();
        user.nameInNameSpace = result.getNameInNamespace();
        String[] stringArray = keys = this.mappingProvider != null ? this.mappingProvider.getLDAPAttributeMappingFor("name") : null;
        if (keys == null) {
            keys = new String[]{"displayName"};
        }
        user.displayName = LDAPAuthenticator.getAttributeAsString(atts, keys);
        String[] stringArray2 = keys = this.mappingProvider != null ? this.mappingProvider.getLDAPAttributeMappingFor("email") : null;
        if (keys == null) {
            keys = new String[]{"mail", "targetAddress"};
        }
        user.emailAddress = LDAPAuthenticator.getAttributeAsString(atts, keys);
        user.emailAddress = LDAPAuthenticator.removeEmailName(user.emailAddress);
        String[] stringArray3 = keys = this.mappingProvider != null ? this.mappingProvider.getLDAPAttributeMappingFor("photo") : null;
        if (keys == null) {
            keys = new String[]{"jpegPhoto", "thumbnailPhoto", "photo"};
        }
        user.avatar = LDAPAuthenticator.getAttributeAsBlob(atts, keys);
        return user;
    }

    private static String removeEmailName(String emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        int start = emailAddress.indexOf(60);
        int end = emailAddress.lastIndexOf(62);
        if (start == -1 || end == -1) {
            return emailAddress;
        }
        return emailAddress.substring(start + 1, end);
    }

    private static String getAttributeAsString(Attributes atts, String string) {
        return LDAPAuthenticator.getAttributeAsString(atts, new String[]{string});
    }

    private static byte[] getAttributeAsBlob(Attributes atts, String[] strings) {
        for (String string : strings) {
            NamingEnumeration<? extends Attribute> attributes = atts.getAll();
            while (attributes.hasMoreElements()) {
                Attribute nextAttribute = (Attribute)attributes.nextElement();
                if (!nextAttribute.getID().toLowerCase().equals(string.toLowerCase())) continue;
                try {
                    Object object = nextAttribute.get();
                    if (!(object instanceof byte[])) continue;
                    return (byte[])object;
                }
                catch (Throwable t) {
                    System.out.println("[Warning] [LDAPAuthentication] Error processing attribute " + nextAttribute);
                }
            }
        }
        return null;
    }

    private static String getAttributeAsString(Attributes atts, String[] searchStrings) {
        for (String searchString : searchStrings) {
            if (searchString == null) continue;
            String regexPattern = null;
            int regexIndex = searchString.indexOf(":::");
            if (regexIndex != -1) {
                regexPattern = searchString.substring(regexIndex + 3);
                searchString = searchString.substring(0, regexIndex);
            }
            Attribute attribute = atts.get(searchString);
            try {
                Object object;
                if (attribute == null || (object = attribute.get()) == null) continue;
                String result = object.toString();
                if (regexPattern != null) {
                    try {
                        Pattern compiledPattern = Pattern.compile(regexPattern);
                        Matcher matcher = compiledPattern.matcher(result);
                        if (matcher.find()) {
                            result = matcher.group();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                return result;
            }
            catch (Throwable t) {
                System.out.println("[Warning] [LDAPAuthentication] Error processing attribute " + attribute);
            }
        }
        return null;
    }

    private static void printAttributes(SearchResult result) {
        Attributes attrs = result.getAttributes();
        NamingEnumeration<? extends Attribute> allAttributes = attrs.getAll();
        while (allAttributes.hasMoreElements()) {
            Attribute attribute = (Attribute)allAttributes.nextElement();
            if (!attribute.toString().contains("memberOf")) continue;
            System.out.println("\t" + attribute);
        }
    }

    public static interface LDAPAttributeMappingProvider {
        public String[] getLDAPAttributeMappingFor(String var1);
    }

    public static class LDAPAttributeMapping {
        public String shAttribute;
        public String[] ldapAttributes;

        public LDAPAttributeMapping(String shProperty, String[] ldapAttributes) {
            this.shAttribute = shProperty;
            this.ldapAttributes = ldapAttributes;
        }
    }

    public static class LDAPUser {
        public byte[] avatar;
        public String nameInNameSpace;
        public String displayName;
        public String emailAddress;

        public String toString() {
            if (this.avatar == null) {
                return this.nameInNameSpace + " [" + this.displayName + "][" + this.emailAddress + "]";
            }
            return this.nameInNameSpace + " [" + this.displayName + "][" + this.emailAddress + "][avatar=yes]";
        }
    }

    public static class LDAPSearchResult {
        public String CN;
        public String DN;

        public String toString() {
            return this.CN;
        }
    }
}

