/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import utils.progtools.ProcessPrinter;
import utils.string.CharStack;

public class WindowsFirewall {
    public static boolean isFirewallRunning() throws Exception {
        String[] outputs = WindowsFirewall.runCommandGetOutputThrowErrors(new String[]{"netsh", "firewall", "show", "opmode"});
        if (outputs != null && outputs.length >= 2) {
            String output = outputs[0];
            if (output.indexOf("current") != -1) {
                CharStack stack = new CharStack(output);
                stack.popUntil("current", false);
                stack.popUntil("Operational", false);
                stack.popUntil("=", false);
                String state = stack.popUntil("\n", true);
                return state.trim().equalsIgnoreCase("enable");
            }
            return false;
        }
        return false;
    }

    public static boolean isFirewallRunningOn(String ip) throws Exception {
        if (ip == null) {
            return false;
        }
        String name = (String)WindowsFirewall.getNetworkNameToIPAddressMap().get(ip.trim());
        String[] outputs = WindowsFirewall.runCommandGetOutputThrowErrors(new String[]{"netsh", "firewall", "show", "opmode"});
        if (outputs != null && outputs.length >= 2) {
            String output = outputs[0];
            if (output.indexOf(name) != -1) {
                CharStack stack = new CharStack(output);
                stack.popUntil(name, false);
                stack.popUntil("Operational", false);
                stack.popUntil("=", false);
                String state = stack.popUntil("\n", true);
                return state.trim().equalsIgnoreCase("enable");
            }
            return false;
        }
        return false;
    }

    public static boolean isPortOpen(int port) throws Exception {
        String[] outputs = WindowsFirewall.runCommandGetOutputThrowErrors(new String[]{"netsh", "firewall", "show", "portopening"});
        if (outputs != null && outputs.length >= 2) {
            String output = outputs[0];
            CharStack stack = new CharStack(output);
            while (!stack.isEmpty()) {
                stack.popUntil('\n', false);
                if (stack.isEmpty()) continue;
                stack.popWhitespace();
                String firstEntry = stack.popText(true);
                if (!firstEntry.trim().equals("" + port)) continue;
                stack.popWhitespace();
                String protocol = stack.popText(true);
                if (!protocol.equalsIgnoreCase("tcp")) continue;
                stack.popWhitespace();
                String state = stack.popText(true);
                if (!state.equalsIgnoreCase("enable")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSimpleHelpExcepted(File serverInstallDir) throws Exception {
        String[] outputs = WindowsFirewall.runCommandGetOutputThrowErrors(new String[]{"netsh", "firewall", "show", "allowedprogram"});
        if (outputs != null && outputs.length >= 2) {
            String stdout = outputs[0];
            CharStack stack = new CharStack(stdout);
            stack.popUntil("Enable", false);
            while (!stack.isEmpty()) {
                stack.popUntil('/', false);
                try {
                    String executable = stack.popUntil("\n", true).trim();
                    executable = executable.substring(0, executable.lastIndexOf(92));
                    File parent = new File(executable);
                    if (parent.equals(serverInstallDir)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                stack.popUntil("Enable", false);
            }
        }
        return false;
    }

    private static HashMap getNetworkNameToIPAddressMap() throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String[] outputs = WindowsFirewall.runCommandGetOutputThrowErrors(new String[]{"ipconfig"});
        if (outputs != null && outputs.length >= 2) {
            String stdout = outputs[0];
            CharStack stack = new CharStack(stdout);
            stack.popUntil("adapter", false);
            while (!stack.isEmpty()) {
                String name = stack.popUntil(':', true);
                name = name.trim();
                String content = stack.popUntil("adapter", true);
                int IPLabelIndex = content.indexOf("IP Address");
                if (IPLabelIndex == -1) continue;
                int nextColon = content.indexOf(58, IPLabelIndex);
                int nextNewLine = content.indexOf(10, IPLabelIndex);
                String IP = content.substring(nextColon + 1, nextNewLine).trim();
                returnMap.put(name, IP);
                returnMap.put(IP, name);
            }
        }
        return returnMap;
    }

    public static void main(String[] args) throws Exception {
        File testFile = new File("C:\\WINDOWS\\system32");
        System.out.println(WindowsFirewall.isSimpleHelpExcepted(testFile));
    }

    private static String[] runCommandGetOutputThrowErrors(String[] cmd) throws Exception {
        Process p = Runtime.getRuntime().exec(cmd);
        p.getOutputStream().close();
        ByteArrayOutputStream sout = new ByteArrayOutputStream();
        ByteArrayOutputStream eout = new ByteArrayOutputStream();
        ProcessPrinter pp = new ProcessPrinter(p, (OutputStream)sout, (OutputStream)eout);
        p.waitFor();
        pp.waitForAllOutput();
        return new String[]{new String(sout.toByteArray()), new String(eout.toByteArray())};
    }
}

