/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.LogicalArray;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NonNativeLogicalArray;
import java.io.File;

public class NativeLogicalArray
implements LogicalArray {
    int logicalWidth;
    int logicalHeight;
    int sourceWidth;
    int totalOffset;
    int myInstance = 0;
    int[] preFetch = new int[256];
    int preFetchStart = -999;
    int preFetchEnd = -999;

    long[] getSpeed() {
        int[] source = new int[100000];
        this.nativeSetSize(this.myInstance, 100000);
        this.nativeBlank(this.myInstance);
        long chunkScanlinesPerSecond = 0L;
        long t = System.currentTimeMillis() + 100L;
        while (System.currentTimeMillis() < t) {
            for (int i = 0; i < 1000; ++i) {
                this.nativeSetScanline(this.myInstance, source, 0, 0, 32);
                ++chunkScanlinesPerSecond;
            }
        }
        chunkScanlinesPerSecond *= 10L;
        long pixelOpsPerSecond = 0L;
        long t2 = System.currentTimeMillis() + 100L;
        while (System.currentTimeMillis() < t2) {
            for (int i = 0; i < 1000; ++i) {
                this.getXY(i, 0);
                ++pixelOpsPerSecond;
            }
        }
        System.out.println("[NativeLogicalArray] Approximately    " + chunkScanlinesPerSecond + " chunk scanlines per second");
        System.out.println("[NativeLogicalArray] Approximately    " + (pixelOpsPerSecond *= 10L) + " pixel ops per second");
        return new long[]{chunkScanlinesPerSecond, pixelOpsPerSecond};
    }

    public boolean workingOk() {
        try {
            long[] myspeed = this.getSpeed();
            return myspeed[0] > 125000L;
        }
        catch (Throwable t) {
            System.out.println("[NativeLogicalArray] speed test failed to run, assuming library not available");
            return false;
        }
    }

    public native void nativeSetSize(int var1, int var2);

    public native void nativeBlank(int var1);

    public native void nativeRelease(int var1);

    public native void nativeSetup();

    public native int nativeGet(int var1, int var2);

    public native void nativeGetScanline(int var1, int[] var2, int var3, int var4, int var5);

    public native void nativeSet(int var1, int var2, int var3);

    public native void nativeSetScanline(int var1, int[] var2, int var3, int var4, int var5);

    public native void nativeSetScanlineSlow(int var1, int[] var2, int var3, int var4, int var5);

    public void setSourceSize(int sourceSize) {
        this.nativeSetSize(this.myInstance, sourceSize);
    }

    public void blank() {
        this.nativeBlank(this.myInstance);
    }

    public void releaseMemory() {
        this.nativeRelease(this.myInstance);
    }

    public NativeLogicalArray(int INSTANCE, int logicalWidth, int logicalHeight, int sourceSize, int sourceWidth, int sourceX, int sourceY) {
        this(INSTANCE, logicalWidth, logicalHeight, sourceSize, sourceWidth, sourceX + sourceY * sourceWidth);
    }

    public NativeLogicalArray(int INSTANCE, int logicalWidth, int logicalHeight, int sourceSize, int sourceWidth, int totalOffset) {
        this.nativeSetup();
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.sourceWidth = sourceWidth;
        this.totalOffset = totalOffset;
        this.myInstance = INSTANCE;
        this.nativeSetSize(INSTANCE, sourceSize);
    }

    private NativeLogicalArray(int INSTANCE, int logicalWidth, int logicalHeight, NativeLogicalArray la, int sourceX, int sourceY) {
        this.nativeSetup();
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.sourceWidth = la.sourceWidth;
        this.totalOffset = la.getSourceOffset(sourceX, sourceY);
        this.myInstance = INSTANCE;
    }

    public NativeLogicalArray getSubArray(int sourceX, int sourceY, int logicalWidth, int logicalHeight) {
        return new NativeLogicalArray(this.myInstance, logicalWidth, logicalHeight, this, sourceX, sourceY);
    }

    public NativeLogicalArray getSubArray(int sourceX, int sourceY, int logicalWidth, int logicalHeight, NativeLogicalArray into) {
        into.logicalWidth = logicalWidth;
        into.logicalHeight = logicalHeight;
        into.sourceWidth = this.sourceWidth;
        into.totalOffset = this.getSourceOffset(sourceX, sourceY);
        into.myInstance = this.myInstance;
        return into;
    }

    @Override
    public int getWidth() {
        return this.logicalWidth;
    }

    @Override
    public int getHeight() {
        return this.logicalHeight;
    }

    @Override
    public int getYOffset(int y) {
        int off = this.totalOffset;
        return off += y * this.sourceWidth;
    }

    @Override
    public int getSourceOffset(int x, int y) {
        return this.getYOffset(y) + x;
    }

    @Override
    public int getXY(int x, int y) {
        int offset = this.getSourceOffset(x, y);
        if (offset < this.preFetchStart || offset >= this.preFetchEnd) {
            int fetchOffset = Math.max(0, offset - 128);
            this.nativeGetScanline(this.myInstance, this.preFetch, 0, fetchOffset, 256);
            this.preFetchStart = fetchOffset;
            this.preFetchEnd = fetchOffset + 256;
        }
        return this.preFetch[offset - this.preFetchStart];
    }

    @Override
    public void setXY(int x, int y, int val) {
        int index = this.getSourceOffset(x, y);
        this.nativeSet(this.myInstance, index, val);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                sb.append(this.getXY(x, y));
                if (x >= this.getWidth() - 1) continue;
                sb.append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        int i;
        NativeLibraryLoader.loadLibrary(new File("lib"));
        System.out.println("--Non-Native...");
        NonNativeLogicalArray.main(args);
        System.out.println("--Native...");
        int INST = 0;
        NativeLogicalArray ar = new NativeLogicalArray(INST, 10, 10, 300, 10, 0);
        ar.workingOk();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                ar.setXY(x, y, y * 10 + x);
            }
        }
        ar.preFetchStart = -999;
        ar.preFetchEnd = -999;
        System.out.println("Trying to break...");
        ar.nativeGetScanline(INST, new int[10], 1000, -55, 12);
        ar.nativeGetScanline(INST, new int[10], 1000000, 5, 12);
        for (i = -99; i < 1000; ++i) {
            try {
                ar.getXY(i, 0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (i = -99; i < 1000; ++i) {
            try {
                ar.setXY(i, 0, 99);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ar.nativeSetScanline(INST, new int[10], 1000, -55, 12);
        ar.nativeSetScanline(INST, new int[10], 1000000, 5, 12);
        ar.nativeSetScanline(INST, new int[1000], 0, -55, 12);
        ar.nativeSetScanline(INST, new int[1000], 100, 299, 12);
        ar.nativeSetScanline(INST, new int[1000], 100, 299, 100000);
        ar.nativeSetScanline(INST, new int[1000], 1000, 299, 1);
        System.out.println(new NativeLogicalArray(10, 10, 0, 10, 0, 0));
        System.out.println(new NativeLogicalArray(5, 5, 0, 10, 5, 5));
        System.out.println(new NativeLogicalArray(5, 5, 0, 10, 0, 0));
        System.out.println(new NativeLogicalArray(3, 3, 0, 10, 1, 1));
        System.out.println(new NativeLogicalArray(10, 10, 0, 10, 0, 0).getSubArray(1, 1, 8, 8));
    }
}

