/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.VersionUtil;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import utils.files.FileUtil;
import utils.message.Message;
import utils.swing.images.ImageHelper;

public class TestTreeModel {
    static boolean uniqueNames = false;
    static int c = 0;

    public static String[][] getMachineDetails() {
        return new String[][]{{"Servers/Website Host 2016", "testing/sample_screenshots/windows/windows_2016.png", "simplehelp", "shwebsite"}, {"Laptops/Antony's OS X MacBook Pro " + (uniqueNames ? "[" + c++ + "]" : ""), "testing/sample_screenshots/mac/elcap.png", "aemiguel", "aemmbp"}, {"Laptops/George's Mac", "testing/sample_screenshots/mac/mac snowleopard2.jpg", "gchristelis", "Lingo"}, {"Laptops/Support/Sarah's Mac ", "testing/sample_screenshots/mac/mac.jpg", "slacy", "Ratchet"}, {"Laptops/Support/Eleanor's Windows 7", "testing/sample_screenshots/windows/windows 7.jpg", "efrederici", "Harley"}, {"Laptops/Support/Nathan's Laptop", "testing/sample_screenshots/linux/Ubuntu 12.04 KDE.jpg", "nathan", "N's laptop"}, {"Laptops/Support/Roaming Laptop Windows 10", "testing/sample_screenshots/windows/windows_10_3.jpg", "secretary", "SH Secretary"}, {"Laptops/Support/Triage Windows 2008", "testing/sample_screenshots/windows/windows_10_2.jpg", "nathan", "N's laptop"}, {"Laptops/Support/George - Windows 10 ", "testing/sample_screenshots/windows/windows_10.jpg", "slacy", "Ratchet"}, {"Laptops/Testing/Ubuntu 10.04", "testing/sample_screenshots/linux/Ubuntu 10.04 1.jpg", "simplehelp", "test-ubuntu"}, {"Laptops/Testing/Ubuntu 12.04 w KDE", "testing/sample_screenshots/linux/Ubuntu 12.04 KDE.jpg", "shtest1", "test-ubuntu-kde"}, {"Laptops/Testing/Testing Windows XP SP3", "testing/sample_screenshots/windows/windows xp.jpg", "shtest", "test-windows-xp"}, {"Servers/Windows/Licensing Server 1", "testing/sample_screenshots/windows/windows 7 2.jpg", "licensing", "License Server"}, {"Servers/Windows/Active Directory Server 2012", "testing/sample_screenshots/windows/windows server 2003.jpg", "Administrator", "Windows AD"}, {"Servers/Windows/SMTP Server 2008", "testing/sample_screenshots/windows/windows xp.jpg", "Administrator", "smtp"}, {"Servers/Build/Mac Mini w VMWare", "testing/sample_screenshots/mac/mac snowleopard2.jpg", "simplehelp", "shmini"}, {"Servers/Build/Windows Server 2008 w Visual Studio", "testing/sample_screenshots/windows/windows server 2008.jpg", "simplehelp", "SH build server"}, {"Servers/Email/CentOS 6", "testing/sample_screenshots/linux/centos 2.jpg", "email", "email server"}, {"Trial Servers/Ready IT Windows 8", "testing/sample_screenshots/windows/windows 7 2.jpg", "trialserver1", "Trial Server"}, {"Trial Servers/DGS", "testing/sample_screenshots/windows/windows server 2003.jpg", "Administrator", "Windows AD"}, {"Trial Servers/Alfresco", "testing/sample_screenshots/windows/windows xp.jpg", "Administrator", "smtp"}, {"Trial Servers/Enterprise Trial (23/06)", "testing/sample_screenshots/mac/mac snowleopard2.jpg", "simplehelp", "shmini"}, {"Trial Servers/Enterprise Trial (24/06)", "testing/sample_screenshots/windows/windows server 2008.jpg", "simplehelp", "SH build server"}, {"Trial Servers/Enterprise Trial (26/06)", "testing/sample_screenshots/linux/centos 2.jpg", "email", "email server"}};
    }

    public static String[][] getAlertDetails() {
        return new String[][]{{"Uptime Alerts/Websites/www.simple-help.com", "false"}, {"Uptime Alerts/Email Servers", "false"}, {"Uptime Alerts/Database Backends", "false"}, {"Antivirus Monitors", "false"}, {"Disk Space Alerts", "false"}};
    }

    public static void initialiseAlertsTestModel(TechClient client, AlertTreeModel model) {
        Random r = new Random();
        String[][] details = TestTreeModel.getAlertDetails();
        ArrayList<LocatedAlert> alerts = new ArrayList<LocatedAlert>();
        for (int i = 0; i < details.length; ++i) {
            LocatedAlert alert = LocatedAlert.createTestAlert();
            alert.setActive(true);
            alert.setName(MachineName.extractFromNameWithGroup(details[i][0]));
            alerts.add(alert);
            int machineCount = r.nextInt(5) + 1;
            int triggerCount = 0;
            if (machineCount > 0) {
                triggerCount = r.nextInt(machineCount + 1);
            }
            ArrayList<String> machines = new ArrayList<String>();
            for (int ii = 0; ii < triggerCount; ++ii) {
                machines.add("123-" + ii);
            }
            alert.setTriggeredMachines(machines);
            client.debug_addAlertTargetCount(alert.getID(), machineCount);
        }
        model.addElements(alerts.toArray(new LocatedAlert[0]));
    }

    public static ArrayList<Machine> initialiseTestModel(MachineTreeModel model, boolean allUpToDate, boolean largeScale) throws Exception {
        String[][] machineDetails = TestTreeModel.getMachineDetails();
        byte[][] jpgs = new byte[machineDetails.length][];
        for (int i = 0; i < machineDetails.length; ++i) {
            if (machineDetails[i][1] == null) continue;
            jpgs[i] = FileUtil.readFile((File)new File(machineDetails[i][1]));
            jpgs[i] = ImageHelper.scaleDownToFitInside((byte[])jpgs[i], (int)300, (int)200, (boolean)true);
        }
        ArrayList<Machine> machines = new ArrayList<Machine>();
        Random r = new Random();
        for (int i = 0; i < machineDetails.length; ++i) {
            String name = machineDetails[i][0];
            Machine machine = Machine.createTestMachine();
            if (i == 0) {
                machine.debug_clearSessions();
            }
            machine.getMachineInfo().setOverwriteName(MachineName.extractFromNameWithGroup(name));
            machine.setAvailable(r.nextInt(6) != 0);
            if (name.toLowerCase().contains("windows")) {
                if (name.toLowerCase().contains("10") || name.toLowerCase().contains("2016")) {
                    switch (r.nextInt(4)) {
                        case 0: {
                            machine.getMachineInfo().setOS(0, 6, r.nextBoolean(), "Windows 10 (Anniversary Update)");
                            break;
                        }
                        case 1: {
                            machine.getMachineInfo().setOS(0, 6, r.nextBoolean(), "Windows 10 (Fall Creators Update)");
                            break;
                        }
                        case 2: {
                            machine.getMachineInfo().setOS(0, 6, r.nextBoolean(), "Windows 10 (Creators Update)");
                            break;
                        }
                        case 3: {
                            machine.getMachineInfo().setOS(0, 6, r.nextBoolean(), "Windows 10 (November Update)");
                        }
                    }
                } else if (name.toLowerCase().contains("xp")) {
                    machine.getMachineInfo().setOS(0, 3, r.nextBoolean(), "Windows XP");
                } else if (name.toLowerCase().contains("2008") || name.toLowerCase().contains("Server")) {
                    machine.getMachineInfo().setOS(0, 6, r.nextBoolean(), "Windows Server 2008");
                } else if (name.toLowerCase().contains(" 8")) {
                    machine.getMachineInfo().setOS(0, 6, r.nextBoolean(), "Windows 8");
                } else {
                    machine.getMachineInfo().setOS(0, 7, r.nextBoolean(), "Windows 7");
                }
            } else if (name.toLowerCase().contains("mac")) {
                machine.getMachineInfo().setOS(1, 2, r.nextBoolean(), "Mac OS X 10." + (r.nextInt(10) + 5) + "." + r.nextInt(3));
            } else if (r.nextBoolean()) {
                if (r.nextBoolean()) {
                    machine.getMachineInfo().setOS(2, 2, true, "Linux x64 (Ubuntu 16.04.3 LTS)");
                } else {
                    machine.getMachineInfo().setOS(2, 2, true, "Linux x64 (CentOS 7)");
                }
            } else {
                machine.getMachineInfo().setOS(2, 2, true, "Linux x64 (Debian 6)");
            }
            if (allUpToDate) {
                machine.setAccessServiceBuild(Version.getSsuiteFullBuildVersion());
                machine.setAccessServiceVersion(VersionUtil.getShortVersionWithSub());
                machine.getMachineInfo().setAllowMonitoring(true);
            }
            machine.getMachineInfo().setConsoleUser(machineDetails[i][2]);
            machine.getMachineInfo().setHostname(machineDetails[i][3]);
            if (r.nextBoolean()) {
                machine.getMachineInfo().setWifiStats(78 + r.nextInt(150), 80 + r.nextInt(20));
            }
            Message disk = new Message();
            disk.append("C:");
            disk.append(81.0);
            disk.append("D:");
            disk.append(11.0);
            Message procs = new Message();
            procs.append("svchost.exe");
            procs.append(74.0);
            machine.getMachineInfo().setOsDetailedStats(disk, procs);
            machines.add(machine);
            machine.getMachineInfo().setSmallScreenJpeg(jpgs[i]);
        }
        model.addElements(machines.toArray(new Machine[0]));
        Thread.sleep(2000L);
        if (largeScale) {
            AccessSession testSession;
            TreeElement[] bulk = new Machine[10000];
            for (int i = 0; i < bulk.length; ++i) {
                bulk[i] = Machine.createTestMachine();
            }
            model.addElements(bulk);
            Machine[] array = machines.toArray(new Machine[0]);
            for (int i = 0; i < array.length; ++i) {
                array[i] = new Machine(array[i].toMessage(true));
            }
            ArrayList<AccessSession> sessions = new ArrayList<AccessSession>();
            for (int i = 0; i < 10; ++i) {
                testSession = AccessSession.createTestSession(array[0]);
                sessions.add(testSession);
            }
            for (AccessSession s : sessions) {
                model.addSessions(new AccessSession[]{s});
                Thread.sleep(500L);
            }
            for (AccessSession s : sessions) {
                model.removeSessions(new AccessSession[]{s});
                Thread.sleep(500L);
            }
            for (int i = 0; i < 100; ++i) {
                testSession = AccessSession.createTestSession(array[r.nextInt(array.length)]);
                model.addSessions(new AccessSession[]{testSession});
                Thread.sleep(100L);
            }
        }
        return machines;
    }
}

