/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.ostools.OS;
import utils.ostools.OSDirs;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.progtools.arrays.ArrayUtils;
import utils.stream.StreamPiper;
import utils.string.CharStack;

public class TechLaunchUtility {
    public static void main(String[] args) throws Exception {
        System.out.println("Usage: TechLaunchUtility <serverURL> <user> <pass> <sgid>");
        TechLaunchUtility.launchSession(args[0], args[1], args[2], args[3], true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launchSession(String serverURL, String username, String password, String sgid, boolean online) throws Exception {
        File launcher;
        block24: {
            File tmpDownload;
            File parentDir;
            block25: {
                String[] lines;
                block23: {
                    String downloadFilename;
                    String downloadPath;
                    String type;
                    if (!serverURL.startsWith("http")) {
                        throw new Exception("Server URL must be of the form http[s]://host[:port] and must not include /tech");
                    }
                    serverURL = PathUtil.ensureTrailingFwd((String)serverURL);
                    String string = type = online ? "online" : "offline";
                    if (OS.isWindows()) {
                        downloadPath = serverURL + "technician/SimpleHelp%20Technician-windows64-" + type + ".exe?language=en&hostname=" + URLEncoder.encode(serverURL);
                        downloadFilename = "tech.exe";
                    } else if (OS.isMacOS()) {
                        downloadPath = serverURL + "technician/SimpleHelp%20Technician-macos64-" + type + ".dmg?language=en&hostname=" + URLEncoder.encode(serverURL);
                        downloadFilename = "tech.dmg";
                    } else if (OS.isLinux64bit()) {
                        downloadPath = serverURL + "technician/SimpleHelp%20Technician-linux64-" + type + ".tar?language=en&hostname=" + URLEncoder.encode(serverURL);
                        downloadFilename = "tech.tar";
                    } else if (OS.isLinux()) {
                        downloadPath = serverURL + "technician/SimpleHelp%20Technician-linux32-" + type + ".tar?language=en&hostname=" + URLEncoder.encode(serverURL);
                        downloadFilename = "tech.tar";
                    } else {
                        throw new Exception("We do not support this OS");
                    }
                    System.out.println("[TechLaunchUtility] Download path is " + downloadPath);
                    URL url = new URL(downloadPath);
                    parentDir = OSDirs.getTempDir();
                    tmpDownload = new File(parentDir, downloadFilename);
                    System.out.println("[TechLaunchUtility] Downloading to " + tmpDownload);
                    InputStream in = url.openStream();
                    FileOutputStream fout = new FileOutputStream(tmpDownload);
                    StreamPiper.pipe((InputStream)in, (OutputStream)fout);
                    in.close();
                    fout.close();
                    System.out.println("[TechLaunchUtility] Download finished, will extract (if necessary)");
                    if (!OS.isWindows()) break block23;
                    launcher = tmpDownload;
                    break block24;
                }
                if (!OS.isMacOS()) break block25;
                RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand((String[])new String[]{"hdiutil", "attach", tmpDownload.getCanonicalPath()});
                if (response.returnCode != 0) {
                    System.out.println("hdiutil output:\n" + response.stdout);
                    System.out.println("hdiutil errors:\n" + response.stderr);
                    throw new IOException("hdiutil returned non-zero return code");
                }
                String diskPath = null;
                String volumePath = null;
                for (String line : lines = response.stdout.trim().split("\n")) {
                    System.out.println("Line: " + line);
                    int maxIndex = Math.max(line.indexOf(" /"), line.indexOf("\t/"));
                    if (maxIndex == -1) continue;
                    volumePath = line.substring(++maxIndex).trim();
                    diskPath = new CharStack(line).popText(true);
                }
                try {
                    if (volumePath == null) {
                        System.out.println("hdiutil output:\n" + response.stdout);
                        System.out.println("hdiutil errors:\n" + response.stderr);
                        throw new IOException("unable to get volume path from hdiutil output");
                    }
                    if (volumePath.endsWith("/")) {
                        volumePath = volumePath.substring(0, volumePath.length() - 1);
                    }
                    File target = PathUtil.replaceSuffix((File)tmpDownload, (String)".app");
                    File volume = new File(volumePath);
                    File[] files = volume.listFiles();
                    if (files == null) {
                        throw new IOException("Unable to list volume provided by hdiutil " + volumePath);
                    }
                    File source = null;
                    for (File file : files) {
                        if (!file.getName().endsWith(".app")) continue;
                        source = file;
                    }
                    if (source == null) {
                        throw new IOException("Couldn't find .app file in volume provided by hdiutil " + volumePath);
                    }
                    FileUtil.deleteDir((File)target);
                    System.out.println("Clearing " + target);
                    System.out.println("Copying " + source + " to " + target);
                    if (target.exists()) {
                        System.out.println("ERROR unable to delete " + target);
                    }
                    RunCommandGetOutput.runCommand((String[])new String[]{"cp", "-r", source.getCanonicalPath(), target.getCanonicalPath()});
                    System.out.println("Copying finished");
                    System.out.println("chmodding " + target);
                    RunCommandGetOutput.runCommand((String[])new String[]{"chmod", "777", target.getCanonicalPath()});
                    launcher = new File(target, "Contents");
                    launcher = new File(launcher, "MacOS");
                    launcher = new File(launcher, "osxwrapper");
                }
                catch (Throwable throwable) {
                    RunCommandGetOutput.runCommand((String[])new String[]{"hdiutil", "detach", diskPath});
                    throw throwable;
                }
                RunCommandGetOutput.runCommand((String[])new String[]{"hdiutil", "detach", diskPath});
                break block24;
            }
            if (OS.isLinux()) {
                File subFolder = new File(parentDir, "tempExtract" + System.currentTimeMillis());
                subFolder.mkdirs();
                File subFile = new File(subFolder, tmpDownload.getName());
                RunCommandGetOutput.runCommand((String[])new String[]{"mv", tmpDownload.getAbsolutePath(), subFile.getAbsolutePath()});
                RunCommandGetOutput.runCommand((String[])new String[]{"tar", "-xf", subFile.getName()}, (File)subFolder);
                subFile.delete();
                File[] files = subFolder.listFiles();
                launcher = null;
                for (File file : files) {
                    if (file.getName().startsWith(".")) continue;
                    subFile = file;
                    launcher = new File(parentDir, file.getName());
                    RunCommandGetOutput.runCommand((String[])new String[]{"mv", file.getAbsolutePath(), launcher.getAbsolutePath()});
                    FileUtil.deleteDir((File)subFolder);
                }
                if (launcher == null) {
                    throw new Exception("Unable to find executable file extracted from TAR");
                }
            } else {
                throw new Exception("We do not support this OS");
            }
        }
        System.out.println("[TechLaunchUtility] Launcher is " + launcher);
        Object[] command = new String[]{launcher.getCanonicalFile().getAbsolutePath(), "JWVAPP", "SessionUI", "JW_serverurl=" + serverURL, "JW_launchapi=yes", "JW_machine=" + sgid, "JW_technician=" + username, "JW_password=" + password};
        ArrayUtils.printArray((Object[])command);
        Process process = Runtime.getRuntime().exec((String[])command, null, launcher.getParentFile());
        ProcessPrinter.printAllOutputToStdout((Process)process);
        System.out.println("[TechLaunchUtility] Session launched");
    }
}

