/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import jwrapper.jwutils.test.JWTesting;
import utils.files.FileUtil;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.osstats.WindowsStats;

public class OsRestore {
    boolean requireMatch = false;
    Stats stats = OsStats.getOsStats();
    HashMap present = new HashMap();
    ArrayList<File> mustDelete = new ArrayList();

    public OsRestore() {
        this.setProcesses();
    }

    public void setProcesses() {
        System.out.println("[OsRestore] Capturing processes for restoration");
        this.stats.update();
        Stats.ProcessStatistic[] procs = this.stats.getProcessStatistics();
        this.present.clear();
        for (Stats.ProcessStatistic proc : procs) {
            System.out.println("[OsRestore] Existing process: [" + proc.id + "], " + proc.name + ", " + proc.cmdLineArgs);
            this.present.put(proc.id.trim(), proc.cmdLineArgs);
        }
    }

    public void setDelete(File file) {
        System.out.println("[OsRestore] Asked to delete file during restoration: " + file);
        this.mustDelete.add(file);
    }

    public void restoreAll() {
        System.out.println("[OsRestore] Restoring OS to previous point");
        System.out.println("[OsRestore] Restoring processes to previous point");
        this.stats.update();
        Stats.ProcessStatistic[] testprocs = this.stats.getProcessStatistics();
        for (Stats.ProcessStatistic proc : testprocs) {
            if (this.present.containsKey(proc.id.trim())) continue;
            String info = proc.name.toLowerCase() + " " + proc.cmdLineArgs.toLowerCase();
            String[] killprocs = new String[]{"session", "tech", "access", "simplegateway", "osxwrapper", "osxlauncher", "simple", "jwrapper", "jwvapp", "elev_win", "elev_mac", "-xmx", "-simpleservice"};
            for (int i = 0; i < killprocs.length; ++i) {
                killprocs[i] = killprocs[i].toLowerCase();
            }
            boolean matches = false;
            if (!this.requireMatch) {
                matches = true;
            } else {
                for (String kill : killprocs) {
                    if (info.indexOf(kill.toLowerCase()) == -1) continue;
                    matches = true;
                    break;
                }
            }
            if (!matches) continue;
            System.out.println("[OsRestore] Terminating new process [" + proc.id + "] / " + proc.cmdLineArgs);
            System.out.flush();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            OsStats.getOsStats().killProcess(proc.id);
        }
        System.out.println("[OsRestore] Restoring files to previous point");
        for (File file : this.mustDelete) {
            System.out.println("[OsRestore] Deleting file " + file);
            try {
                new WindowsStats(true, true).killProcessLaunchedFrom(file.getCanonicalFile().getAbsolutePath(), new String[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileUtil.robustDelete((File)file);
        }
        System.out.println("[OsRestore] Verifying restoration");
        this.stats.update();
        testprocs = this.stats.getProcessStatistics();
        boolean allOk = true;
        for (Stats.ProcessStatistic proc : testprocs) {
            if (this.present.containsKey(proc.id)) continue;
            System.out.println("[OsRestore] WARNING: process still exists " + proc.id + " / " + proc.cmdLineArgs);
            allOk = false;
        }
        for (File file : this.mustDelete) {
            if (!file.exists()) continue;
            JWTesting.reportStandaloneFail((String)("WARNING: file still exists " + file));
            System.out.println("[OsRestore] WARNING: file still exists " + file);
            allOk = false;
        }
        if (allOk) {
            System.out.println("[OsRestore] Restoration verified, all is as it was");
        }
    }

    public static void main(String[] args) throws Exception {
        File A2 = new File("/tmp/mustDelete.txt");
        A2.createNewFile();
        File B = new File("/tmp/mustDeleteAll");
        B.mkdirs();
        OsRestore restore = new OsRestore();
        restore.setProcesses();
        restore.setDelete(A2);
        restore.setDelete(B);
        Thread.sleep(60000L);
        restore.restoreAll();
    }
}

