/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.nodelink.utils.DataUtils;
import com.aem.tests.AccessLoad;
import com.aem.tests.HeadlessAccessAPI;
import com.aem.tests.TestUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.message.BasicMTTransactionServer;
import utils.message.Message;
import utils.message.TransactionListener;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.Counter;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.layout.GbPanel;
import utils.swing.listeners.SystemExitWindowListener;

public class AccessTest {
    static long GENERAL_TESTCASE_SLEEP = 100L;
    static long MIN = 60000L;
    static boolean DO_HPROF = false;
    static long HPROF_TIMEBOMB = 60L * MIN;
    static Random r;
    static Random rnew;
    static ArrayList<Method> tests;
    static Object counter_LOCK;
    static Counter counter;
    static JWTesting jwa;
    static int jwaport;
    static int overallMachines;
    static int totalMachines;
    static String baseurl;
    static JLabel tots;
    static HeadlessAPI api;
    static TestUI testui;
    static Object ipcs_LOCK;
    static ArrayList<JWSockIPC> ipcs;
    static String CONTROL_DEFERRED;
    static JToggleButton pollingonButton;
    static JToggleButton pollingoffButton;
    static JToggleButton pollingcycleButton;
    static JToggleButton timebombButton;

    public static void main(String[] args) throws Exception {
        boolean headless = false;
        String aes = null;
        if (args.length > 0 && args[0].equals("headless")) {
            headless = true;
            aes = args[1];
        }
        try {
            if (!headless) {
                SimpleHelpFrame.setLnf();
            }
            Method[] methods = AccessTest.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName();
                if (!name.startsWith("test")) continue;
                System.out.println("[Testcase] " + name.substring(4));
                tests.add(methods[i]);
            }
            File seedFile = new File(JWSystem.getAllAppVersionsSharedFolder(), "AccessTestSeed");
            if (!seedFile.exists()) {
                long seed = System.currentTimeMillis();
                FileUtil.writeFileAsStringUTF8((String)seedFile.getAbsolutePath(), (String)("" + seed));
            }
            r = new Random(Long.parseLong(FileUtil.readFileAsStringUTF8((File)seedFile)));
            rnew = new Random();
            for (int i = 0; i < 200; ++i) {
                try {
                    jwaport = TestUtils.RA_PORT + i;
                    jwa = JWTesting.createNewTest();
                    System.out.println("Test report server created on " + jwaport);
                    break;
                }
                catch (Exception x) {
                    if (i != 199) continue;
                    throw new Exception("Unable to claim any port for Test Report server");
                }
            }
            if (!headless) {
                System.out.println("[Testing] Launching TestUI");
                testui = new TestUI();
            } else {
                System.out.println("[Testing] Launching HeadlessAPI");
                api = new HeadlessAPI(aes);
            }
        }
        catch (Throwable t) {
            System.out.println("[Testing] ***WARNING*** Exception in main thread, quitting now");
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void updateTotal() {
        if (testui != null) {
            testui.updateTotal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCommand(String command) throws Exception {
        Object object = ipcs_LOCK;
        synchronized (object) {
            for (int i = 0; i < ipcs.size(); ++i) {
                try {
                    JWSockIPC ipc = ipcs.get(i);
                    InputStream in = ipc.getInChannel((short)0);
                    OutputStream out = ipc.getOutChannel((short)0);
                    DataUtils.writeStringUTF8(out, command);
                    out.flush();
                    DataUtils.readNStringUTF8(in, 10000);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ipcs.remove(i--);
                }
            }
        }
        testui.updateTotal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOneTestcase(JWTesting jwa, String name, boolean ephemeral) throws Exception {
        String sgname;
        double N;
        Method method = null;
        if (name == null) {
            int choice = r.nextInt(tests.size());
            method = tests.get(choice);
        } else {
            for (int i = 0; i < tests.size() && !(method = tests.get(i)).getName().equalsIgnoreCase(name); ++i) {
            }
        }
        Object object = counter_LOCK;
        synchronized (object) {
            System.out.println("[Testing] running testcase " + method.getName().substring(4) + " (already run x" + counter.getInt((Object)method.getName(), 0) + ")");
            counter.add((Object)method.getName(), 1.0);
            N = counter.get((Object)method.getName());
        }
        Properties props = new Properties();
        props.setProperty("TEST_AM_TESTING", "true");
        jwa.prepareTestInstance(props);
        method.invoke((Object)new AccessTest(), props);
        if (ephemeral) {
            int mins = 6;
            int newrand = Math.abs(rnew.nextInt());
            props.setProperty("INFO_SG_NAME", "Transient Service " + mins + "m " + newrand);
            props.setProperty("INFO_SG_GROUP", AccessTest.getGroupFor(newrand));
            JWLaunchProperties.overrideProperty((String)"exit_timebomb", (String)("" + (long)mins * MIN));
        } else {
            JWLaunchProperties.deleteProperty((String)"exit_timebomb");
        }
        JWSockIPC.setupForIPC((Properties)props, (boolean)false);
        JWLaunchProperties.overrideProperty((String)"procpri_low", (String)"true");
        JWLaunchProperties.deleteProperty((String)"launch_in_session");
        JWLaunchProperties.deleteProperty((String)"xmx_override");
        JWLaunchProperties.deleteProperty((String)"xmx_pc_free");
        JWLaunchProperties.deleteProperty((String)"xmx_pc_phys");
        if ((N -= 1.0) < 3.0 || N % 50.0 == 0.0) {
            JWLaunchProperties.deleteProperty((String)"logging_mute");
        } else {
            JWLaunchProperties.overrideProperty((String)"logging_mute", (String)"true");
        }
        if (N == 0.0 || N % 30.0 == 0.0) {
            JWLaunchProperties.deleteProperty((String)"headless_jvm_jvmargs");
            sgname = props.getProperty("INFO_SG_NAME");
            props.setProperty("INFO_SG_NAME", "GUI " + sgname);
        } else {
            JWLaunchProperties.overrideProperty((String)"headless_jvm_jvmargs", (String)"true");
            sgname = props.getProperty("INFO_SG_NAME");
            props.setProperty("INFO_SG_NAME", "Headless " + sgname);
        }
        JWLaunchProperties.overrideProperty((String)"xmx_override", (String)"75");
        if (DO_HPROF) {
            JWLaunchProperties.overrideProperty((String)"xmx_override", (String)"120");
            JWLaunchProperties.overrideProperty((String)"exit_timebomb", (String)("" + HPROF_TIMEBOMB));
            JWLaunchProperties.overrideProperty((String)"jip_options", (String)"xml");
        }
        JWSystem.forkVirtualApp((String)"Remote Access Service", (Properties)props, (String[])new String[0]);
        JWSockIPC ipc = JWSockIPC.connectParent((Properties)props);
        ipc.setupMultipleChannels();
        Object object2 = ipcs_LOCK;
        synchronized (object2) {
            ipcs.add(ipc);
        }
        AccessTest.updateTotal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureService(Properties props, boolean http, boolean https) {
        int myrand;
        String tmp = baseurl.substring(baseurl.indexOf(58));
        tmp = https ? "https" + tmp : (http ? "http" + tmp : "udp" + tmp);
        System.out.println("URL will be " + tmp);
        props.setProperty("INFO_SG_URL", tmp);
        Object object = counter_LOCK;
        synchronized (object) {
            myrand = Math.abs(r.nextInt());
        }
        props.setProperty("INFO_SG_NAME", "Test Service " + myrand);
        props.setProperty("INFO_SG_GROUP", AccessTest.getGroupFor(myrand));
        props.setProperty("INFO_SG_ACCEPT_ALL_SSL", "true");
        if (CONTROL_DEFERRED != null) {
            props.setProperty("INFO_SG_DEFER", CONTROL_DEFERRED);
        }
        if (pollingonButton == null) {
            props.setProperty("INFO_SG_BEGIN_POLLING", "true");
        } else if (pollingonButton.isSelected()) {
            props.setProperty("INFO_SG_BEGIN_POLLING", "true");
        } else if (!pollingoffButton.isSelected() && pollingcycleButton.isSelected()) {
            props.setProperty("INFO_SG_BEGIN_POLLING", "true");
            props.setProperty("INFO_SG_POLLING_CYCLE", "true");
        }
    }

    public void testHttpService(Properties props) {
        this.configureService(props, true, false);
        JWTesting.reportAttempt((String)"Remote Access Service Launch", (String)"", (int)120000);
    }

    public void testHttpsService(Properties props) {
        this.configureService(props, true, true);
        JWTesting.reportAttempt((String)"Remote Access Service Launch", (String)"", (int)120000);
    }

    public void testUdpService(Properties props) {
        this.configureService(props, false, false);
        JWTesting.reportAttempt((String)"Remote Access Service Launch", (String)"", (int)120000);
    }

    private static String getGroupFor(int abs) {
        int country = abs % 100 / 10;
        int city = abs % 10;
        String group = "";
        if (country >= 0 && country <= 4) {
            group = "Brazil/";
            group = city >= 0 && city <= 4 ? group + "Sao Paolo/" : (city >= 5 && city <= 7 ? group + "Rio de Janeiro/" : (city == 8 ? group + "Salvador/" : group + "Fortaleza/"));
        } else if (country >= 5 && country <= 7) {
            group = "Germany/";
            group = city >= 0 && city <= 4 ? group + "Berlin/" : (city >= 5 && city <= 7 ? group + "Hamburg/" : (city == 8 ? group + "Munich/" : group + "Frankfurt/"));
        } else if (country == 8) {
            group = "Italy/";
            group = city >= 0 && city <= 4 ? group + "Rome/" : (city >= 5 && city <= 7 ? group + "Milan/" : (city == 8 ? group + "Naples/" : group + "Turin/"));
        } else {
            group = "Greece/";
            group = city >= 0 && city <= 4 ? group + "Athens/" : (city >= 5 && city <= 7 ? group + "Thessalonika/" : (city == 8 ? group + "Patras/" : group + "Heraklion/"));
        }
        return group;
    }

    static {
        tests = new ArrayList();
        counter_LOCK = new Object();
        counter = new Counter();
        ipcs_LOCK = new Object();
        ipcs = new ArrayList();
        CONTROL_DEFERRED = null;
    }

    static class Driver
    extends Thread {
        String mode;
        boolean sel;

        public Driver(String mode, boolean sel) {
            this.mode = mode;
            this.sel = sel;
        }

        @Override
        public void run() {
            try {
                if (this.mode.contains("Random Mix")) {
                    for (int i = 0; i < totalMachines; ++i) {
                        Thread.sleep(2500L);
                        AccessTest.runOneTestcase(jwa, null, false);
                    }
                } else if (this.mode.contains("Transient Mix")) {
                    for (int i = 0; i < totalMachines; ++i) {
                        Thread.sleep(2500L);
                        AccessTest.runOneTestcase(jwa, null, true);
                    }
                } else if (this.mode.contains("Polling On")) {
                    AccessTest.sendCommand("COM_RA_START");
                    AccessTest.sendCommand("COM_RA_NOCYCLE");
                } else if (this.mode.contains("Polling Off")) {
                    AccessTest.sendCommand("COM_RA_STOP");
                    AccessTest.sendCommand("COM_RA_NOCYCLE");
                } else if (this.mode.contains("Polling Cycle")) {
                    AccessTest.sendCommand("COM_RA_START");
                    AccessTest.sendCommand("COM_RA_CYCLE");
                } else if (this.mode.contains("Renegotiate")) {
                    AccessTest.sendCommand("COM_RA_RENEGOTIATE");
                } else if (this.mode.contains("HTTP Socket")) {
                    AccessTest.sendCommand("COM_RA_KILL_HTTP");
                } else if (this.mode.contains("Test Service Liveness")) {
                    AccessTest.sendCommand("COM_RA_NOOP");
                } else {
                    for (int i = 0; i < totalMachines; ++i) {
                        Thread.sleep(GENERAL_TESTCASE_SLEEP);
                        AccessTest.runOneTestcase(jwa, this.mode, false);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            JWAutomate.sleep((long)20000L);
            System.out.println("[Testing] All Testing FINISHED");
        }
    }

    static class TestUI
    extends JFrame
    implements ActionListener,
    JWTestable {
        JTabbedPane tabs = new JTabbedPane();
        GbPanel main = new GbPanel();
        JTextField jpw = new JTextField();
        JTextField url = new JTextField();
        JTextField tchost = new JTextField("localhost");
        Insets is = new ScaledInsets(3, 3, 3, 3);
        int H = 0;
        GbPanel tcon = new GbPanel();

        public TestUI() {
            JPanel big = new JPanel();
            this.getContentPane().add(big);
            big.setLayout(new BorderLayout());
            big.add("Center", this.tabs);
            JLabel labl = new JLabel("Test server available on: " + jwaport);
            labl.setOpaque(true);
            labl.setHorizontalAlignment(0);
            labl.setHorizontalTextPosition(0);
            labl.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
            labl.setBackground(new Color(195, 218, 243));
            big.add("South", labl);
            this.tabs.addTab("Manual Control", new JScrollPane((Component)this.main));
            this.tabs.addTab("Test Control", (Component)this.tcon);
            this.tcon.add((Component)new JLabel("Defer control to"), 0, 0, 1, 1, 1, 1, 18, 0, this.is);
            this.tcon.add((Component)this.tchost, 1, 0, 1, 1, 1, 1, 18, 2, this.is);
            JButton defer = new JButton("Defer Control");
            defer.addActionListener(this);
            this.tcon.add((Component)defer, 1, 1, 1, 1, 1, 1, 13, 0, this.is);
            this.tcon.add((Component)new JPanel(), 1, 2, 1, 1, 100, 100, 10, 1, this.is);
            String upd = JWSystem.getUpdateURL();
            if (upd.endsWith("access/")) {
                upd = upd.substring(0, upd.length() - "access/".length());
            }
            if (upd.endsWith("access")) {
                upd = upd.substring(0, upd.length() - "access".length());
            }
            this.url.setText(upd);
            tots = new JLabel("", 0);
            tots.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
            tots.setOpaque(true);
            tots.setBackground(new Color(195, 218, 243));
            this.main.add((Component)tots, 1, this.H, 1, 1, 1, 1, 17, 2, this.is);
            ++this.H;
            this.main.add((Component)new JLabel("New Machines"), 0, this.H, 1, 1, 1, 1, 17, 0, this.is);
            this.main.add((Component)this.jpw, 1, this.H, 1, 1, 100, 1, 17, 2, this.is);
            ++this.H;
            this.jpw.setText("1");
            this.main.add((Component)new JLabel("Server URL"), 0, this.H, 1, 1, 1, 1, 17, 0, this.is);
            this.main.add((Component)this.url, 1, this.H, 1, 1, 100, 1, 17, 2, this.is);
            ++this.H;
            this.addButton("Random Mix");
            this.addButton("Transient Mix");
            for (int i = 0; i < tests.size(); ++i) {
                Method m = tests.get(i);
                this.addButton(m.getName());
            }
            this.main.add((Component)new JLabel("(hit launch buttons multiple times for concurrent launching)"), 1, this.H++, 1, 1, 1, 1, 15, 3, this.is);
            this.main.add((Component)new JLabel("Test Controls", 0), 0, this.H, 1, 1, 1, 1, 17, 0, this.is);
            ++this.H;
            pollingonButton = this.addToggleButton("Polling On", true);
            pollingoffButton = this.addToggleButton("Polling Off", true);
            pollingcycleButton = this.addToggleButton("Polling Cycle Continuously", true);
            ButtonGroup bg = new ButtonGroup();
            bg.add(pollingonButton);
            bg.add(pollingoffButton);
            bg.add(pollingcycleButton);
            this.addSpacer();
            this.addButton("Renegotiate SecMsg");
            this.addButton("Nuke HTTP Socket");
            this.addButton("Test Service Liveness");
            this.main.add((Component)new JPanel(), 0, this.H++, 1, 1, 1, 1000, 15, 3, this.is);
            this.updateTotal();
            this.setBounds(50, 50, 480, 600);
            this.setVisible(true);
            this.addWindowListener((WindowListener)new SystemExitWindowListener());
            if (JWLaunchProperties.getBooleanProperty((String)"AUTO_DEFER_CONTROL", (boolean)false)) {
                System.out.println("[Testing] Will automatically defer test control if possible");
                new ShareThread().start();
            }
        }

        void removeManual() {
            this.tabs.removeTabAt(1);
        }

        public JToggleButton addToggleButton(String s, boolean state) {
            JToggleButton button = new JToggleButton(s, state);
            button.addActionListener(this);
            this.main.add((Component)button, 1, this.H++, 1, 1, 1, 1, 10, 2, this.is);
            return button;
        }

        public void addSpacer() {
            this.main.add((Component)new JSeparator(), 1, this.H++, 1, 1, 1, 1, 10, 2, this.is);
        }

        public void addButton(String s) {
            JButton button = new JButton(s);
            button.addActionListener(this);
            this.main.add((Component)button, 1, this.H++, 1, 1, 1, 1, 10, 2, this.is);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            String text = button.getText();
            totalMachines = Integer.parseInt(this.jpw.getText());
            baseurl = this.url.getText();
            if (text.contains("Defer Control")) {
                String host = this.tchost.getText();
                try {
                    JWTestControl.shareJWT((JWTestable)this, (String)host, (int)TestUtils.TESTCONTROL_PORT);
                    CONTROL_DEFERRED = host;
                    this.removeManual();
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)this, (String)("Deferring control to " + host), (String)"Deferring Control", null, (String)"Close");
                }
                catch (IOException x) {
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)this, (String)("Failed to defer control to " + host + " (" + x + ")"), (String)"Failed to defer control", null, (String)"Close");
                }
            } else {
                new Driver(text, button.isSelected()).start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTotal() {
            Object object = ipcs_LOCK;
            synchronized (object) {
                tots.setText("(" + ipcs.size() + " simulated machines)");
            }
            tots.repaint();
        }

        public String getTestableAppName() {
            return TestUtils.APP_RA_TEST;
        }

        public void call(String str, Message m) throws IOException {
            try {
                baseurl = this.url.getText();
                if (str.contains(TestUtils.RAT_CMD_startThinHttpService)) {
                    AccessLoad.startup(baseurl);
                    AccessLoad.addSim(false);
                } else if (str.contains(TestUtils.RAT_CMD_startThinHttpsService)) {
                    AccessLoad.startup(baseurl);
                    AccessLoad.addSim(true);
                } else if (str.contains(TestUtils.RAT_CMD_startHttpService)) {
                    AccessTest.runOneTestcase(jwa, "testHttpService", false);
                } else if (str.contains(TestUtils.RAT_CMD_startHttpsService)) {
                    AccessTest.runOneTestcase(jwa, "testHttpsService", false);
                } else if (str.contains(TestUtils.RAT_CMD_startUdpService)) {
                    AccessTest.runOneTestcase(jwa, "testUdpService", false);
                }
            }
            catch (Exception x) {
                IOException tmp = new IOException("Failed " + x);
                tmp.initCause(x);
                throw tmp;
            }
        }

        public void testControlConnectionFailed() {
            System.out.println("[Testing] ***WARNING*** JWTestControl connection failed, exiting");
            try {
                JWTesting.reportFail((String)"JWTestControl connection failed to AccessTest", (String)"");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("[Testing] Exiting (test control connection failed)");
            System.exit(1);
        }

        class ShareThread
        extends Thread {
            ShareThread() {
            }

            @Override
            public void run() {
                try {
                    CONTROL_DEFERRED = JWTestControl.shareJWT((JWTestable)TestUI.this, (int)TestUtils.TESTCONTROL_MCPORT);
                    TestUI.this.removeManual();
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)TestUI.this, (String)("Deferring control to " + CONTROL_DEFERRED), (String)"Deferring Control", null);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }
    }

    static class HeadlessAPI
    implements JWSockIPCListener,
    TransactionListener {
        JWSockIPC ipc;
        BasicMTTransactionServer mtserver;
        String url;

        public HeadlessAPI(String aes) throws Exception {
            System.out.println("[Testing] Headless API listening for incoming socket on " + HeadlessAccessAPI.PORT);
            ServerSocket ssock = new ServerSocket(HeadlessAccessAPI.PORT);
            Socket sock = ssock.accept();
            System.out.println("[Testing] Got socket, creating IPC");
            this.ipc = JWSockIPC.createNewIPC((Socket)sock);
            System.out.println("[Testing] Setting up multiple channels");
            this.ipc.setupMultipleChannels();
            this.ipc.setupPingsAndReportClosure((JWSockIPCListener)this, HeadlessAccessAPI.IPC_KEEPALIVE, (long)HeadlessAccessAPI.IPC_TIMEOUT);
            System.out.println("[Testing] Starting MTServer");
            this.mtserver = new BasicMTTransactionServer(this.ipc.getInChannel(HeadlessAccessAPI.IPC_TRANS), this.ipc.getOutChannel(HeadlessAccessAPI.IPC_TRANS), this, 25, 50, false);
            this.mtserver.setAutoHandleExceptions(true);
            System.out.println("[Testing] HeadlessAccessAPI ready");
        }

        public void ipcClosed() {
            System.out.println("[Testing] Exiting (Headless API IPC closed)");
            System.exit(0);
        }

        @Override
        public Message doTransaction(Message m) throws Exception {
            if (m.getType() == HeadlessAccessAPI.MSG_RUN) {
                String cmd = m.getNextString();
                String[] output = RunCommandGetOutput.runCommandGetOutput((String)cmd);
                Message ok = new Message(HeadlessAccessAPI.MSG_OK);
                ok.append(output[0]);
                ok.append(output[1]);
                return ok;
            }
            if (m.getType() == HeadlessAccessAPI.MSG_SET_URL) {
                new URL(m.getNextString());
                baseurl = this.url = m.getAsString(0);
            } else if (m.getType() == HeadlessAccessAPI.MSG_LAUNCH) {
                if (this.url == null) {
                    throw new Exception("Server URL has not been set!");
                }
                String str = m.getNextString();
                int count = m.getNextInt();
                System.out.println("[AccessTest] Received command " + str);
                if (str.contains(TestUtils.RAT_CMD_startThinHttpService)) {
                    AccessLoad.startup(baseurl);
                    for (int i = 0; i < count; ++i) {
                        AccessLoad.addSim(false);
                    }
                } else if (str.contains(TestUtils.RAT_CMD_startThinHttpsService)) {
                    AccessLoad.startup(baseurl);
                    for (int i = 0; i < count; ++i) {
                        AccessLoad.addSim(true);
                    }
                } else {
                    String type;
                    if (str.contains(TestUtils.RAT_CMD_startHttpService)) {
                        type = "testHttpService";
                    } else if (str.contains(TestUtils.RAT_CMD_startHttpsService)) {
                        type = "testHttpsService";
                    } else if (str.contains(TestUtils.RAT_CMD_startUdpService)) {
                        type = "testUdpService";
                    } else {
                        throw new Exception("Test command not recognised: " + str);
                    }
                    for (int i = 0; i < count; ++i) {
                        Thread.sleep(GENERAL_TESTCASE_SLEEP);
                        AccessTest.runOneTestcase(jwa, type, false);
                    }
                }
            } else if (m.getType() == HeadlessAccessAPI.MSG_SERVICES_CMD) {
                if (this.url == null) {
                    throw new Exception("Server URL has not been set!");
                }
                String str = m.getNextString();
                System.out.println("[AccessTest] Sending command to services: " + str);
                AccessTest.sendCommand(str);
            }
            return new Message(HeadlessAccessAPI.MSG_OK);
        }
    }
}

