/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.swing;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class IconPicker {
    private FixedWidthPanel rootComponent = new FixedWidthPanel((LayoutManager)new GridLayout(1, 1));
    private JScrollPane pane = new JScrollPane();
    private GbPanel mainContent = new GbPanel();
    private IconChoice selection;
    private final ArrayList<IconSelectionListener> listeners = new ArrayList();

    public static IconPicker newToolIconPicker() {
        IconPicker picker = new IconPicker();
        picker.loadToolIcons();
        return picker;
    }

    public IconPicker() {
        this.initUI();
    }

    private void initUI() {
        this.mainContent.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.pane.setViewportView((Component)this.mainContent);
        this.pane.setHorizontalScrollBarPolicy(31);
        this.rootComponent.add((Component)this.pane);
    }

    public void loadToolIcons() {
        Field[] fields;
        int x = 0;
        int y = 0;
        for (Field f : fields = Icons.class.getDeclaredFields()) {
            if (!f.getName().startsWith("TOOL_OPTION_")) continue;
            try {
                String iconName = (String)f.get(null);
                String sizedIcon = iconName + "," + 32;
                Icon imageIcon = ImageLoader.getImageIcon((String)sizedIcon);
                this.mainContent.add((Component)new IconChoice(iconName, imageIcon), x, y, 1, 1, 1, 1, 10, 1);
                if (++x <= 5) continue;
                x = 0;
                ++y;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mainContent.revalidate();
        this.mainContent.repaint();
    }

    public void addSelectionListener(IconSelectionListener listener) {
        this.listeners.add(listener);
    }

    public static String showPickerDialog(RootPaneContainer rpc) {
        IconPicker rootComponent = IconPicker.newToolIconPicker();
        SwingUtil.setHeight((JComponent)rootComponent.getRootComponent(), (int)SimpleHelpLookAndFeel.scale((int)300));
        OKCancelDialogPanel adp = new OKCancelDialogPanel(Language.get("CLOSE"));
        adp.setContent((FixedWidthComponent)rootComponent.getRootComponent());
        final AbstractGlassDialog glassDialog = new AbstractGlassDialog(rpc, 480, (AbstractDialogPanel)adp);
        glassDialog.setTitle(Language.get("TOOL_ICON_SELECT"));
        rootComponent.addSelectionListener(new IconSelectionListener(){

            @Override
            public void iconSelected(Icon icon, String iconFieldName) {
                glassDialog.okPressed();
            }
        });
        glassDialog.showDialog();
        if (rootComponent.selection != null) {
            return rootComponent.selection.iconName;
        }
        return null;
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setSize(800, 500);
        frame.setVisible(true);
        IconPicker.showPickerDialog((RootPaneContainer)frame);
    }

    private FixedWidthPanel getRootComponent() {
        return this.rootComponent;
    }

    class IconChoice
    extends JLabel
    implements MouseListener {
        private final Icon imageIcon;
        private final String iconName;

        public IconChoice(String iconName, Icon icon) {
            this.imageIcon = icon;
            this.iconName = iconName;
            this.setIcon(icon);
            this.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            IconPicker.this.selection = this;
            for (IconSelectionListener listener : IconPicker.this.listeners) {
                listener.iconSelected(this.imageIcon, this.iconName);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public static interface IconSelectionListener {
        public void iconSelected(Icon var1, String var2);
    }
}

