/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.feedback;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.feedback.MassJobListener;
import com.aem.shelp.util.feedback.MassStatus;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import utils.progtools.Counter;
import utils.string.StringReplace;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.icons.ProgressRef;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.CardPanel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.LinePanel;
import utils.swing.listeners.SystemExitWindowListener;

public class MassFeedbackPanel
extends BorderPanel
implements ActionListener {
    GbPanel status = new GbPanel();
    JLabel statusLabel;
    CircularProgressIcon progressIcon;
    JLabel progressLabel;
    LinePanel buts;
    JButton cancel;
    JButton close;
    LinePanel masses;
    JScrollPane massScroll;
    CardPanel cards = new CardPanel();
    BorderPanel areaPanel;
    JButton areaBack;
    JEditorPane area;
    JScrollPane areaScroll;
    MassJobListener listener;
    Object maps_LOCK = new Object();
    double jobCount = -1.0;
    ProgressRef ref = null;
    HashMap<String, JobStatus> jobs = new HashMap();
    HashMap<String, MassStatus> statusObjs = new HashMap();

    public MassFeedbackPanel(String title) {
        this.init(title);
    }

    public void setStatusTitle(String title) {
        this.statusLabel.setText(title);
    }

    private void init(String title) {
        SwingUtil.padWithEmptyBorder((JComponent)this.status, (int)9);
        this.statusLabel = new JLabel(title);
        this.statusLabel.setFont(SHStyle.largeFont);
        this.progressIcon = SHProgressIcons.getCircularInfinite(SHProgressIcons.SIZE_72);
        this.progressLabel = new JLabel((Icon)this.progressIcon);
        this.progressIcon.setUpdateComponent((Component)this.progressLabel);
        this.status.add((Component)this.statusLabel, 0, 0, 1, 1, 100, 1, 10, 0);
        this.status.add((Component)this.progressLabel, 0, 1, 1, 1, 100, 100, 10, 0);
        this.addNorth((JComponent)this.status);
        this.masses = new LinePanel(0, false, true);
        this.massScroll = new JScrollPane((Component)this.masses);
        SwingUtil.padWithEmptyBorder((JComponent)this.masses, (int)2);
        this.masses.setGridLayoutSpacing(SimpleHelpLookAndFeel.scale((int)3), SimpleHelpLookAndFeel.scale((int)3));
        this.cards.add(this.massScroll);
        this.areaPanel = new BorderPanel();
        this.area = new JEditorPane("text/html", "");
        this.area.setEditable(false);
        SwingUtil.padWithEmptyBorder((JComponent)this.area, (int)7);
        this.areaScroll = new JScrollPane(this.area);
        LinePanel lp = new LinePanel(1, false, true);
        this.areaBack = new JButton(Language.get("BACK"));
        lp.add((Component)this.areaBack);
        SwingUtil.padWithEmptyBorder((JComponent)lp, (int)7);
        this.areaBack.addActionListener(this);
        this.areaPanel.addNorth((JComponent)lp);
        this.areaPanel.addCenter((JComponent)this.areaScroll);
        this.cards.add((Component)this.areaPanel);
        this.addCenter(this.cards);
        this.buts = new LinePanel(1, true, false);
        SwingUtil.padWithEmptyBorder((JComponent)this.buts, (int)7);
        this.buts.setGridLayoutSpacing(SimpleHelpLookAndFeel.scale((int)7), SimpleHelpLookAndFeel.scale((int)7));
        this.cancel = new JButton(Language.get("CANCEL"));
        this.close = new JButton(Language.get("CLOSE"));
        this.cancel.addActionListener(this);
        this.close.addActionListener(this);
        SHButtonUI.makeButtonBlue((JButton)this.close);
        this.buts.add((Component)this.cancel);
        this.buts.add((Component)this.close);
        this.cancel.setEnabled(false);
        this.cancel.setVisible(false);
        this.close.setEnabled(false);
        this.addSouth((JComponent)this.buts);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.areaBack) {
            this.cards.showCard(this.massScroll);
        } else if (src == this.cancel) {
            this.listener.cancelled();
        } else if (src == this.close) {
            this.listener.closed();
        }
    }

    public void setAllowCancel(boolean b) {
        this.cancel.setVisible(b);
    }

    public void setMassJobListener(MassJobListener listener) {
        this.listener = listener;
        this.cancel.setVisible(true);
        this.cancel.setEnabled(true);
    }

    public void setJobCount(int jobs) {
        this.jobCount = jobs;
        this.ref = new ProgressRef();
        this.ref.useSmoothing(true);
        this.progressIcon = SHProgressIcons.getCircular(SHProgressIcons.SIZE_72);
        this.progressIcon.addProgressRef(this.ref);
        this.progressLabel.setIcon((Icon)this.progressIcon);
        this.progressIcon.setUpdateComponent((Component)this.progressLabel);
        this.progressIcon.setRemoveWhenDone(false);
    }

    public void markJobsRunning() {
        this.cancel.setEnabled(true);
        this.close.setEnabled(false);
        if (!this.isFinite()) {
            this.progressIcon.switchOn();
        }
    }

    public void allJobsComplete() {
        this.cancel.setEnabled(false);
        this.close.setEnabled(true);
        if (!this.isFinite()) {
            this.progressIcon.switchOff();
        }
    }

    private boolean isFinite() {
        return this.ref != null;
    }

    private void updateProgress() {
        SwingUtilities.invokeLater(new Update());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobCompleted(String jobID, String translatedName, String details, MassStatus status) {
        JobStatus job = new JobStatus(jobID, translatedName, details, status);
        Object object = this.maps_LOCK;
        synchronized (object) {
            this.jobs.put(jobID, job);
        }
        object = this.maps_LOCK;
        synchronized (object) {
            this.statusObjs.put(status.id, status);
        }
        this.updateProgress();
    }

    public static void main(String[] args) throws Exception {
        int i;
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        MassFeedbackPanel mfp = new MassFeedbackPanel("Processing, please wait...");
        frame.setBounds(0, 0, 450, 450);
        frame.getContentPane().add((Component)((Object)mfp));
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new SystemExitWindowListener());
        Random r = new Random();
        ArrayList<MassStatus> list = new ArrayList<MassStatus>();
        MassStatus ok = new MassStatus("a_ok", "Successful", ImageLoader.getImageIcon((String)"images/48/general/tick.png"), false);
        for (i = 0; i < 7; ++i) {
            list.add(ok);
        }
        MassStatus internet = new MassStatus("b_internet", "Internet connection failed", ImageLoader.getImageIcon((String)"images/48/general/internet.png"), true);
        for (i = 0; i < 2; ++i) {
            list.add(internet);
        }
        MassStatus fail = new MassStatus("z_failed", "An unknown error occurred", ImageLoader.getImageIcon((String)"images/48/general/error.png"), true);
        for (i = 0; i < 1; ++i) {
            list.add(fail);
        }
        MassRetry retry = new MassRetry(mfp, (MassStatus)list.get(0));
        mfp.setMassJobListener(retry);
        mfp.setJobCount(1000);
        for (i = 0; i < 1000; ++i) {
            if (i < 20) {
                Thread.sleep(100L);
            } else {
                Thread.sleep(10L);
            }
            MassStatus status = (MassStatus)list.get(r.nextInt(list.size()));
            mfp.jobCompleted("" + i, "Job " + i, status.name, status);
        }
        mfp.allJobsComplete();
    }

    static class MassRetry
    implements MassJobListener {
        MassFeedbackPanel mfp;
        MassStatus retryStatus;

        public MassRetry(MassFeedbackPanel mfp, MassStatus retryStatus) {
            this.mfp = mfp;
            this.retryStatus = retryStatus;
        }

        @Override
        public void retry(ArrayList<String> jobIds) {
            for (String id : jobIds) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mfp.jobCompleted(id, "Job " + id, null, this.retryStatus);
            }
        }

        @Override
        public void cancelled() {
            System.exit(0);
        }

        @Override
        public void closed() {
            System.exit(0);
        }
    }

    class JobStatus {
        String jobID;
        String translatedName;
        String details;
        MassStatus status;

        public JobStatus(String jobID, String translatedName, String details, MassStatus status) {
            this.jobID = jobID;
            this.translatedName = translatedName;
            this.details = details;
            this.status = status;
        }
    }

    class MassStatusPanel
    extends BorderPanel
    implements ActionListener {
        MassStatus status;
        JLabel icon;
        JLabel text;
        JLabel count;
        LinePanel bp;
        JButton retry;
        JButton copyList;
        JButton details;
        boolean retryAdded;

        public MassStatusPanel() {
            super((Insets)new ScaledInsets(4, 4, 4, 4));
            this.retryAdded = false;
            this.icon = new JLabel();
            this.text = new JLabel("Nothing");
            this.count = new JLabel();
            this.count.setFont(SHStyle.largeFont);
            this.retry = new JButton(Language.get("RETRY"));
            this.retry.addActionListener(this);
            this.copyList = new JButton(Language.get("COPY_LIST"));
            this.copyList.addActionListener(this);
            this.details = new JButton(Language.get("DETAILS"));
            this.details.addActionListener(this);
            this.bp = new LinePanel(1, true, false);
            this.bp.setGridLayoutSpacing(SimpleHelpLookAndFeel.scale((int)7), SimpleHelpLookAndFeel.scale((int)7));
            this.bp.add((Component)this.copyList);
            this.bp.add((Component)this.details);
            this.bp.add((Component)this.retry);
            this.addWest(this.icon);
            this.addCenter(this.text);
            this.addEast(this.count);
        }

        public void setStatus(MassStatus status) {
            this.status = status;
            this.icon.setIcon(status.icon);
            this.text.setText(status.name);
            this.count.setText("" + status.transient_count);
            if (status.allowRetry && !this.retryAdded) {
                this.retryAdded = true;
                this.addSouth((JComponent)this.bp);
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.copyList) {
                StringBuffer sb = new StringBuffer();
                Object object = MassFeedbackPanel.this.maps_LOCK;
                synchronized (object) {
                    String[] jobIds;
                    for (String jobId : jobIds = MassFeedbackPanel.this.jobs.keySet().toArray(new String[0])) {
                        MassStatus jobStatus = MassFeedbackPanel.this.jobs.get((Object)jobId).status;
                        if (!this.status.id.equals(jobStatus.id)) continue;
                        sb.append(jobId + "\n");
                    }
                }
                try {
                    Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection sel = new StringSelection(sb.toString());
                    clipb.setContents(sel, sel);
                }
                catch (Exception clipb) {}
            } else if (o == this.retry) {
                ArrayList<String> jobList = new ArrayList<String>();
                Object clipb = MassFeedbackPanel.this.maps_LOCK;
                synchronized (clipb) {
                    String[] jobIds;
                    for (String jobId : jobIds = MassFeedbackPanel.this.jobs.keySet().toArray(new String[0])) {
                        MassStatus jobStatus = MassFeedbackPanel.this.jobs.get((Object)jobId).status;
                        if (!this.status.id.equals(jobStatus.id)) continue;
                        jobList.add(jobId);
                        MassFeedbackPanel.this.jobs.remove(jobId);
                    }
                }
                if (jobList.size() > 0) {
                    Retry retry = new Retry(jobList);
                    retry.start();
                    MassFeedbackPanel.this.updateProgress();
                }
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<body style='font-family: sans-serif; font-size: small'>");
                Object object = MassFeedbackPanel.this.maps_LOCK;
                synchronized (object) {
                    String[] jobIds;
                    for (String jobId : jobIds = MassFeedbackPanel.this.jobs.keySet().toArray(new String[0])) {
                        JobStatus jobStatus = MassFeedbackPanel.this.jobs.get(jobId);
                        if (!this.status.id.equals(jobStatus.status.id)) continue;
                        sb.append("<b style='font-size: medium'>");
                        sb.append(jobStatus.translatedName);
                        sb.append("</b><p>");
                        String details = StringReplace.replaceAll((String)jobStatus.details, (String)"\n", (String)"<br>");
                        sb.append(details);
                        sb.append("<p>");
                    }
                }
                MassFeedbackPanel.this.area.setText(sb.toString());
                MassFeedbackPanel.this.cards.showCard((Component)MassFeedbackPanel.this.areaPanel);
                MassFeedbackPanel.this.area.setCaretPosition(0);
            }
        }
    }

    class Retry
    extends Thread {
        ArrayList<String> jobIds;

        public Retry(ArrayList<String> jobs) {
            this.jobIds = jobs;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MassFeedbackPanel.this.progressIcon.switchOn();
                }
            });
            System.out.println("[MFP] Retry " + this.jobIds.size() + " jobs");
            MassFeedbackPanel.this.listener.retry(this.jobIds);
        }
    }

    class Update
    implements Runnable {
        Update() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = MassFeedbackPanel.this.maps_LOCK;
            synchronized (object) {
                String[] jobIds;
                double progress = Math.min(1.0, (double)MassFeedbackPanel.this.jobs.size() / MassFeedbackPanel.this.jobCount);
                if (MassFeedbackPanel.this.ref != null) {
                    MassFeedbackPanel.this.ref.setProgress(progress);
                }
                Object[] ids = MassFeedbackPanel.this.statusObjs.keySet().toArray(new String[0]);
                Arrays.sort(ids);
                Counter statusCounts = new Counter();
                for (String jobId : jobIds = MassFeedbackPanel.this.jobs.keySet().toArray(new String[0])) {
                    MassStatus status = MassFeedbackPanel.this.jobs.get((Object)jobId).status;
                    statusCounts.add((Object)status.id, 1.0);
                }
                int N = 0;
                for (Object id : ids) {
                    MassStatusPanel c = null;
                    try {
                        c = (MassStatusPanel)((Object)MassFeedbackPanel.this.masses.getComponentAt(N));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean create = false;
                    if (c == null) {
                        create = true;
                    } else if (!c.status.id.equals(id)) {
                        create = true;
                    }
                    if (create) {
                        c = new MassStatusPanel();
                        MassFeedbackPanel.this.masses.add((Component)((Object)c), N);
                    }
                    MassStatus status = MassFeedbackPanel.this.statusObjs.get(id);
                    try {
                        status.transient_count = statusCounts.getInt(id);
                    }
                    catch (Exception x) {
                        status.transient_count = 0;
                    }
                    c.setStatus(status);
                    ++N;
                }
            }
        }
    }
}

