/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.Node;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import com.aem.sdesktop.SessionDescription;
import com.aem.sdesktop.SessionPerformance;
import com.aem.shelp.common.PC;
import com.aem.shelp.common.properties.AbstractProperties;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.util.SHelpUdpNlNatHPFwdInterface;
import com.aem.shelp.util.WebTransactionToken;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.time.Times;
import utils.switches.Switches;

public class WebTransactor
implements Runnable,
PC,
AbstractProperties.PropertiesSaver {
    WebTransactionToken wtok;
    String server;
    int port;
    long dieAt = Long.MAX_VALUE;
    String sgID;
    Thread listenerThread;
    TechClientListener listener;

    public WebTransactor(WebTransactionToken wtok, String server, int port) {
        this.wtok = wtok;
        this.server = server;
        this.port = port;
    }

    public void listenForEvents(String sgID, TechClientListener tcl) {
        this.sgID = sgID;
        this.listener = tcl;
        this.listenerThread = new Thread(this);
        this.listenerThread.start();
    }

    public void stopPolling() {
        System.out.println("[WTrans] Stopping polling");
        this.dieAt = 0L;
        this.listenerThread = null;
    }

    public void ensurePolling() {
        this.dieAt = Long.MAX_VALUE;
        if (this.listenerThread == null) {
            System.out.println("[WTrans] Starting polling");
            this.listenerThread = new Thread(this);
            this.listenerThread.start();
        }
    }

    public void linkDied() {
        this.dieAt = SafeClock.currentTimeMillis() + Times.ONE_MINUTE * (long)Switches.SH_sessionRestartReconnectTimeoutMins;
    }

    @Override
    public void run() {
        while (SafeClock.currentTimeMillis() < this.dieAt) {
            System.out.println("[WTrans] checking for events");
            Message m = new Message(170003);
            m.append(this.wtok.ref);
            m.append(this.sgID);
            try {
                Message ret = this.doSecureWebTransaction(m);
                System.out.println("[WTrans] got events message: " + ret);
                if (SafeClock.currentTimeMillis() > this.dieAt) break;
                while (ret.hasNext()) {
                    Message sub = ret.getNextMessage();
                    if (sub.getType() == 10008000) {
                        if (this.listener == null) continue;
                        this.listener.machineOnline(new Machine(this.sgID));
                        continue;
                    }
                    if (sub.getType() == 10009000) {
                        if (this.listener == null) continue;
                        this.listener.machineOffline(new Machine(this.sgID));
                        continue;
                    }
                    System.out.println("[WTrans] Unrecognised event message " + sub);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                try {
                    System.out.println("[WTrans] Failed to check events " + x + " will sleep for 30s");
                    Thread.sleep(30000L);
                }
                catch (Exception exception) {}
            }
        }
        System.out.println("[WTrans] Finished");
        this.listenerThread = null;
    }

    public Message doSecureWebTransaction(Message msg) throws IOException {
        Message m = new Message(55430014);
        m.append(this.wtok.auth1);
        m.append(this.wtok.auth2);
        m.append(msg);
        System.out.println("[Wtok] Doing transaction " + msg.getType());
        Message enc = new Message(55430015);
        enc.append(this.wtok.ref);
        enc.append(this.wtok.bcu.wrap(MessageUtils.messageToBytes((Message)m)));
        URL url = new URL("http://" + this.server + ":" + this.port + "/wtranstok?rand=" + Math.random());
        System.out.println("[Wtok] URL is " + url);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        conn.setReadTimeout(120000);
        conn.setUseCaches(false);
        conn.connect();
        System.out.println("[Wtok] Connected");
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        DataUtils.writeBytes(out, MessageUtils.messageToBytes((Message)enc));
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        InputStream in = conn.getInputStream();
        byte[] dat = DataUtils.readAll(in);
        if (dat.length > 0) {
            Message res = MessageUtils.bytesToMessage((byte[])this.wtok.bcu.unwrap(dat));
            System.out.println("[Wtok] Response " + res.getType());
            return res;
        }
        return null;
    }

    public void clearAccessHandlerTimeout(String machineID) throws IOException {
        System.out.println("[Wtok] Clearing access handler timeout");
        Message m = new Message(130004);
        m.append(machineID);
        this.doSecureWebTransaction(m);
        System.out.println("[Wtok] Clearing access handler timeout complete");
    }

    public void deregister() throws Exception {
        System.out.println("[Wtok] Deregistering WebTransactor...");
        Message m = new Message(130003);
        this.doSecureWebTransaction(m);
        System.out.println("[Wtok] Deregistering complete");
    }

    public void sendSessionPerformance(SessionPerformance performance) throws Exception {
        Message m = new Message(68003);
        m.append(performance.toMessage());
        this.doSecureWebTransaction(m);
    }

    public void sendSessionSummary(SessionDescription sessionDescription, SessionPerformance performance) throws Exception {
        Message m = new Message(68000);
        m.append(sessionDescription.toMessage());
        Message mm = new Message(68003);
        mm.append(performance.toMessage());
        m.append(mm);
        this.doSecureWebTransaction(m);
    }

    @Override
    public void setTechProperties(String prefix, byte[] data) throws Exception {
        Message m = new Message(19100);
        m.append(prefix);
        m.append(data);
        this.doSecureWebTransaction(m);
    }

    @Override
    public void mergeTechProperties(String prefix, byte[] data) throws Exception {
        Message m = new Message(19200);
        m.append(prefix);
        m.append(data);
        this.doSecureWebTransaction(m);
    }

    public boolean checkRaConsoleIdChanged(String sgid, int consoleID) throws Exception {
        Message m = new Message(170001);
        m.append(sgid);
        m.append(consoleID);
        try {
            Message ret = this.doSecureWebTransaction(m);
            return ret.getNextBoolean();
        }
        catch (Exception x) {
            System.out.println("[RaConsoleCheck] web transactor timed out waiting for RA console check");
            return false;
        }
    }

    public SHelpUdpNlNatHPFwdInterface getNLForwardingAPI(Node assocNode) {
        return new NLForwardingAPI(assocNode);
    }

    class NLForwardingAPI
    implements SHelpUdpNlNatHPFwdInterface {
        Node assocNode;

        public NLForwardingAPI(Node assocNode) {
            this.assocNode = assocNode;
        }

        @Override
        public void cancelForwardingRule(int FID) throws Exception {
            Message m = new Message(68005);
            m.append(FID);
            WebTransactor.this.doSecureWebTransaction(m);
        }

        @Override
        public int createForwardingRule() throws Exception {
            Message m = new Message(68004);
            m.append(this.assocNode.getUID());
            Message ret = WebTransactor.this.doSecureWebTransaction(m);
            if (ret.getType() == 1) {
                return ret.getNextInt();
            }
            System.out.println(ret);
            throw new Exception("Unable to create forward rule on server");
        }
    }
}

