/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.nodelink.OrphanPacketListener;
import com.aem.nodelink.udp.UdpEndpoint;
import com.aem.nodelink.udp.UdpTransport;
import com.aem.nodelink.utils.DataUtils;
import com.aem.shelp.util.SHelpUdpNlNatHPFwdInterface;
import com.aem.shelp.util.security.SecurityUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.ProtectiveDrain;
import utils.message.ProtectiveDrainNowInstruction;
import utils.stream.IpQuery;
import utils.udp.bidirectional.StatelessUDPListener;
import utils.udp.bidirectional.UDPClient;

public class SHelpUdpNlNatHpMk2 {
    private static final boolean RESPOND_ONLY_TO_FIRST_INCOMING = false;
    private static final boolean CREATE_CLIENT_TARGET_NODE_WITH_HUMAN_KEY = false;
    private static final int MSG_MY_WAN = 100;
    private static final int MSG_MY_LAN = 200;
    private static final int MSG_RAND = 300;
    private static final int MSG_TALK_SYNC = 400;
    private static final int MSG_AUTH = 500;
    private static final int MSG_FID = 600;
    private static final int MSG_NL_FAILED = 700;
    private static final int MSG_NL_OK = 800;
    private static final boolean ACCEPT_2x_UNIDIRECTIONAL_UDP = false;

    public static NodeLink establishProxiedUDP(SHelpUdpNlNatHPFwdInterface fwdclient, String host, int http_port, InputStream in, OutputStream out) {
        if (in == null || out == null) {
            System.out.println("[NAT-HP] Central communications streams are null");
            return null;
        }
        ProtectiveDrain pd = new ProtectiveDrain(in, out);
        NodeLink nl = null;
        try {
            nl = SHelpUdpNlNatHpMk2.doBreakthroughUDP(fwdclient, host, http_port, pd, false, false);
        }
        catch (ProtectiveDrainNowInstruction t) {
            System.out.println("[NAT-HP] Remote side failed, entering recovery protocol");
        }
        catch (Throwable t) {
            System.out.println("[NAT-HP] Local side failed (" + t + "), entering recovery protocol");
            t.printStackTrace();
        }
        try {
            if (nl == null) {
                System.out.println("[NAT-HP] No UDP connection established, draining");
            }
            pd.finishWithProtectiveDrain();
            if (nl == null) {
                System.out.println("[NAT-HP] Drain complete");
            }
        }
        catch (IOException x) {
            System.out.println("[NAT-HP] Unexpected failure in protective drain");
            x.printStackTrace();
        }
        return nl;
    }

    public static NodeLink establishDirectUDP(SHelpUdpNlNatHPFwdInterface fwdclient, String host, int http_port, InputStream in, OutputStream out, boolean allowPortScan) {
        if (in == null || out == null) {
            System.out.println("[NAT-HP] Failed to establish UDP - central communications streams are null");
            return null;
        }
        System.out.println("[NAT-HP] Will try to establish Direct UDP");
        ProtectiveDrain pd = new ProtectiveDrain(in, out);
        NodeLink nl = null;
        try {
            nl = SHelpUdpNlNatHpMk2.doBreakthroughUDP(fwdclient, host, http_port, pd, true, allowPortScan);
        }
        catch (ProtectiveDrainNowInstruction t) {
            System.out.println("[NAT-HP] Remote side failed, entering recovery protocol");
        }
        catch (Throwable t) {
            System.out.println("[NAT-HP] Local side failed (" + t + "), entering recovery protocol");
            t.printStackTrace();
        }
        try {
            if (nl == null) {
                System.out.println("[NAT-HP] No UDP connection established, draining");
            }
            pd.finishWithProtectiveDrain();
            if (nl == null) {
                System.out.println("[NAT-HP] Drain complete");
            }
        }
        catch (IOException x) {
            System.out.println("[NAT-HP] Unexpected failure in protective drain");
            x.printStackTrace();
        }
        return nl;
    }

    private static NodeLink doBreakthroughUDP(SHelpUdpNlNatHPFwdInterface fwdclient, String host, int http_port, ProtectiveDrain pd, boolean direct, boolean allowDirectPortScan) throws ProtectiveDrainNowInstruction, Exception {
        int remport;
        String remip;
        int wanport;
        String wanip;
        if (CentralDebugging.NL_FORCE_HTTP_ONLY) {
            System.out.println("[NAT-HP] Forcing HTTP so NOT allowing any UDP connections");
            return null;
        }
        if (CentralDebugging.NL_FORCE_HTTPS_IF_POSSIBLE) {
            System.out.println("[NAT-HP] Forcing HTTPS so NOT allowing any UDP connections");
            return null;
        }
        System.out.println("[NAT-HP] Opening UDP client to " + host + ":" + http_port);
        StatelessUDPListener servListener = new StatelessUDPListener();
        UDPClient servClient = new UDPClient(host, http_port, servListener);
        System.out.println("[NAT-HP] Querying for self");
        Message m = new Message(2001000);
        servClient.send(MessageUtils.messageToBytes((Message)m));
        for (int i = 0; i < 25 && !servListener.hasData(); ++i) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            servClient.send(MessageUtils.messageToBytes((Message)m));
        }
        boolean noPortRewriting = false;
        boolean serverIpMatchesWanIp = false;
        if (servListener.hasData()) {
            System.out.println("[NAT-HP] got self");
            Message ret = MessageUtils.bytesToMessage((byte[])servListener.getAndClearData());
            wanip = (String)ret.get(0);
            wanport = ret.getAsInt(1);
            if (wanip.startsWith("127.")) {
                wanip = IpQuery.getOneLanIP().getHostAddress();
            }
            System.out.println("[NAT-HP] wan is " + wanip + ":" + wanport);
            boolean localNoPortRewriting = wanport == servClient.getLocalPort();
            Message wan = new Message(100);
            wan.append(wanip);
            wan.append(wanport);
            wan.append(localNoPortRewriting);
            pd.writeMessage(wan);
            wan = pd.readMessage();
            remip = wan.getAsString(0);
            remport = wan.getAsInt(1);
            boolean remoteNoPortRewriting = wan.getAsBoolean(2);
            if (localNoPortRewriting && remoteNoPortRewriting) {
                System.out.println("[NAT-HP] no port rewriting detected");
                noPortRewriting = true;
            } else {
                System.out.println("[NAT-HP] port rewriting detected (local=" + !localNoPortRewriting + ") (remote=" + !remoteNoPortRewriting + ")");
            }
            try {
                String serverIP = InetAddress.getByName(host).getHostAddress();
                if (serverIP.equals(wanip) || serverIP.equals(remip)) {
                    System.out.println("[NAT-HP] server matches one or more WANs");
                    serverIpMatchesWanIp = true;
                } else {
                    System.out.println("[NAT-HP] server does not match WANs");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (remip.length() == 0) {
                System.out.println("[NAT-HP] remote is unable to get self, cancelling");
                throw new Exception("[NAT-HP] remote side is unable to get self");
            }
        } else {
            System.out.println("[NAT-HP] unable to get self");
            Message wan = new Message(100);
            wan.append("");
            wan.append(-1);
            wan.append(false);
            pd.writeMessage(wan);
            wan = pd.readMessage();
            throw new Exception("[NAT-HP] unable to get self");
        }
        if (!CentralDebugging.DISABLE_CONNECTION_UDP) {
            int locport = servClient.getLocalPort();
            System.out.println("[NAT-HP] remote is " + remip + ":" + remport);
            if (direct) {
                boolean sameLAN = false;
                if (remip.equalsIgnoreCase(wanip)) {
                    wanip = IpQuery.getOneLanIP().getHostAddress();
                    wanport = servClient.getLocalPort();
                    System.out.println("[NAT-HP] wan snap, providing revised " + wanip + ":" + wanport);
                    sameLAN = true;
                    Message lan = new Message(200);
                    lan.append(wanip);
                    lan.append(wanport);
                    pd.writeMessage(lan);
                    lan = pd.readMessage();
                    remip = lan.getAsString(0);
                    remport = lan.getAsInt(1);
                    System.out.println("[NAT-HP] receiving revised remote " + remip + ":" + remport);
                }
                servClient.dieButLeaveSocket();
                if (allowDirectPortScan) {
                    System.out.println("[NAT-HP] Will try direct UDP with PS");
                    return SHelpUdpNlNatHpMk2.breakthroughDirectNlUDP(servClient.getUnderlyingSocket(), locport, remip, remport, pd, true);
                }
                if (noPortRewriting && !serverIpMatchesWanIp) {
                    System.out.println("[NAT-HP] Will try direct UDP without PS (noprw=" + noPortRewriting + ") (sipwip=" + serverIpMatchesWanIp + ")");
                    return SHelpUdpNlNatHpMk2.breakthroughDirectNlUDP(servClient.getUnderlyingSocket(), locport, remip, remport, pd, false);
                }
            }
        } else {
            System.out.println("[NAT-HP] UDP Direct connections disabled");
        }
        if (!CentralDebugging.DISABLE_CONNECTION_UDP_VIA_SERVER) {
            if (!direct) {
                servClient.die();
                return SHelpUdpNlNatHpMk2.breakthroughProxiedNlUDP(servClient.getUnderlyingSocket(), pd, host, http_port, fwdclient);
            }
        } else {
            System.out.println("[NAT-HP] UDP Proxied connections disabled");
        }
        return null;
    }

    private static Node getOrCreateNode(DatagramSocket dsock, HashMap nodes, Node home, String host, int port) {
        String key = "NODE_" + port + "_" + host;
        Node node = (Node)nodes.get(key);
        if (node == null) {
            node = new Node();
            System.out.println("[NLNatHP] Created " + node + " (=" + port + ")");
            UdpEndpoint ee = new UdpEndpoint(host, port);
            ee.setExistingDatagramSocket(dsock);
            home.setRemoteNodeAddress(node, ee);
            nodes.put(key, node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeLink breakthroughProxiedNlUDP(DatagramSocket dsock, ProtectiveDrain pd, String host, int http_port, SHelpUdpNlNatHPFwdInterface fwdclient) throws ProtectiveDrainNowInstruction {
        NodeLink.PACKET_LOSS_SIMULATE_FAILURE = false;
        System.out.println("[NAT-HP] attempting server proxied UDP connection");
        Node home = new Node();
        Node shserver = new Node();
        home.setSingleUse(true);
        home.setNoRetryOnBrokenTransport(true);
        UdpEndpoint ee = new UdpEndpoint(host, http_port);
        home.setRemoteNodeAddress(shserver, ee);
        NodeLinkConversation fwdIgnoredConv = new NodeLinkConversation(-7777);
        home.DEBUG_SHOW_ALL_PACKETS = false;
        try {
            NodeLink nlforwarded;
            if (fwdclient != null) {
                int fid = fwdclient.createForwardingRule();
                System.out.println("[NAT-HP] Got rule " + fid);
                Message mfid = new Message(600);
                mfid.append(-fid);
                pd.writeMessage(mfid);
                ee.setForwardingID((short)fid);
                for (int i = 0; i < 3; ++i) {
                    home.sendToSpecific(new byte[0], shserver, fwdIgnoredConv);
                    Thread.sleep(200L);
                }
                pd.writeMessage(new Message(400));
                pd.readMessage();
                Thread.sleep(200L);
                nlforwarded = null;
                try {
                    nlforwarded = new NodeLink(home, shserver, true, false);
                }
                finally {
                    if (nlforwarded == null) {
                        System.out.println("[NAT-HP] NL failed, informing remote side");
                        pd.writeMessage(new Message(700));
                        Message i = pd.readMessage();
                    } else {
                        System.out.println("[NAT-HP] NL OK, checking remote side...");
                        pd.writeMessage(new Message(800));
                        Message remoteSide = pd.readMessage();
                        if (remoteSide.getType() == 700) {
                            System.out.println("[NAT-HP] Remote NL failed");
                            try {
                                nlforwarded.stop("nathp direct/proxied udp aborted - remote side failed");
                            }
                            catch (Exception exception) {}
                            throw new Exception("[NAT-HP] Had to abort NL - remote side NL failed");
                        }
                        System.out.println("[NAT-HP] Remote NL OK");
                    }
                }
            }
            Message mfid = pd.readMessage();
            int fid = mfid.getAsInt(0);
            System.out.println("[NAT-HP] Read rule " + fid);
            ee.setForwardingID((short)fid);
            for (int i = 0; i < 3; ++i) {
                home.sendToSpecific(new byte[0], shserver, fwdIgnoredConv);
                Thread.sleep(200L);
            }
            pd.readMessage();
            pd.writeMessage(new Message(400));
            nlforwarded = null;
            try {
                nlforwarded = new NodeLink(home, true, false);
            }
            finally {
                if (nlforwarded == null) {
                    System.out.println("[NAT-HP] NL failed, informing remote side");
                    pd.writeMessage(new Message(700));
                    Message i = pd.readMessage();
                } else {
                    System.out.println("[NAT-HP] NL OK, checking remote side...");
                    pd.writeMessage(new Message(800));
                    Message remoteSide = pd.readMessage();
                    if (remoteSide.getType() == 700) {
                        System.out.println("[NAT-HP] Remote NL failed");
                        try {
                            nlforwarded.stop("nathp direct/proxied udp aborted - remote side failed");
                        }
                        catch (Exception exception) {}
                        throw new Exception("[NAT-HP] Had to abort NL - remote side NL failed");
                    }
                    System.out.println("[NAT-HP] Remote NL OK");
                }
            }
            nlforwarded.setFriendlyName("EOL / TemporaryPatchShellUDP");
            home.DEBUG_SHOW_ALL_PACKETS = false;
            nlforwarded.getStats().type = 3;
            return nlforwarded;
        }
        catch (Exception x) {
            x.printStackTrace();
            home.shutdownTransports();
            System.out.println("[NAT-HP] FAIL - NL failed to connect forwarded " + x);
            home.DEBUG_SHOW_ALL_PACKETS = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static NodeLink breakthroughDirectNlUDP(DatagramSocket useSock, int locport, String targetIp, int targetPort, ProtectiveDrain pd, boolean scanPorts) throws Exception, ProtectiveDrainNowInstruction {
        System.out.println("[NAT-HP] attempting direct UDP connection (ps=" + scanPorts + ")");
        home = new Node();
        home.setSingleUse(true);
        home.setNoRetryOnBrokenTransport(true);
        replacement = new UdpEndpoint("localhost", locport);
        replacement.setExistingDatagramSocket(useSock);
        System.out.println("[NAT-HP] Will use DG socket on " + useSock);
        transport = (UdpTransport)home.acceptIncomingOn(replacement);
        ops = new PacketListener();
        home.setOrphanPacketListener(ops);
        nodes = new HashMap<K, V>();
        MAX_PING = 2000;
        SPREAD = 30;
        T = 20;
        N = MAX_PING * 2 / T;
        System.out.println("[NAT-HP] starting direct");
        key = new NodeLinkConversation(-8888);
        target = SHelpUdpNlNatHpMk2.getOrCreateNode(useSock, nodes, home, targetIp, targetPort);
        mtype = 2002000;
        origPort = targetPort;
        talking = false;
        targetSet = false;
        if (!CentralDebugging.DISABLE_CONNECTION_UDP) {
            for (i = 1; i <= N; ++i) {
                if (ops.hasData()) {
                    System.out.println("[NAT-HP] got data...");
                    var24_28 = ops.getLOCK();
                    synchronized (var24_28) {
                        data = ops.getData();
                        fromNode = ops.getDataFromNode();
                    }
                    ret = MessageUtils.bytesToMessage((byte[])data);
                    if (ret.getType() == 2002000) {
                        mtype = 2003000;
                        target = fromNode;
                        if (!targetSet) {
                            targetSet = true;
                        }
                        System.out.println("[NAT-HP] got data from " + target);
                    } else if (ret.getType() == 2003000 || ret.getType() == 2004000) {
                        System.out.println("[NAT-HP] talking to " + target + " (extending time x2)");
                        if (!talking) {
                            talking = true;
                            N *= 2;
                        }
                        if (mtype != 2004000) {
                            // empty if block
                        }
                        mtype = 2004000;
                        target = fromNode;
                        if (!targetSet) {
                            targetSet = true;
                        }
                        if (ret.getType() == 2004000) {
                            System.out.println("[NAT-HP] received finish request, sending standard response...");
                            m = new Message(mtype);
                            for (k = 0; k < 5; ++k) {
                                home.sendToSpecific(MessageUtils.messageToBytes((Message)m), target, key);
                                try {
                                    Thread.sleep(50L);
                                    continue;
                                }
                                catch (Exception var27_34) {
                                    // empty catch block
                                }
                            }
                            break;
                        }
                    } else {
                        System.out.println("[NAT-HP] not useful data (" + ret.getType() + ")");
                    }
                }
                try {
                    Thread.sleep(T);
                }
                catch (Exception fromNode) {
                    // empty catch block
                }
                addport = scanPorts != false ? i % SPREAD - SPREAD / 2 : 0;
                if (targetSet) {
                    // empty if block
                }
                modTarget = SHelpUdpNlNatHpMk2.getOrCreateNode(useSock, nodes, home, targetIp, origPort + addport);
                System.out.println("[NAT-HP] Sending to scan target " + modTarget);
                m = new Message(mtype);
                home.sendToSpecific(MessageUtils.messageToBytes((Message)m), modTarget, key);
                System.out.println("[NAT-HP] Sending most valid target " + target);
                m = new Message(mtype);
                home.sendToSpecific(MessageUtils.messageToBytes((Message)m), target, key);
            }
        }
        if (talking) {
            System.out.println("[NAT-HP] success (target=" + target + "), synchronising...");
            pd.writeMessage(new Message(2004000));
            pd.readMessage();
            System.out.println("[NAT-HP] ready");
            myrand = Math.random();
            mran = new Message(300);
            mran.append(myrand);
            pd.writeMessage(mran);
            mran = pd.readMessage();
            theirrand = mran.getAsDouble(0);
            try {
                if (myrand > theirrand) {
                    System.out.println("[NAT-HP] adopting server side, listening on " + locport);
                    pd.readMessage();
                    pd.writeMessage(new Message(400));
                    nldirect = null;
                    try {
                        nldirect = new NodeLink(home, true, CentralDebugging.UDP_VERIFY_PACKET_LOSS_UNDER_DIRECT_UDP);
                    }
                    catch (Exception x) {
                        nldirect = null;
                        if (x == null) ** GOTO lbl170
                        home.shutdownTransports();
                        xx = new Exception("[NAT-HP] FAIL - NL failed to connect " + x);
                        xx.initCause(x);
                        throw xx;
                    }
                    finally {
                        if (nldirect == null) {
                            System.out.println("[NAT-HP] NL failed, informing remote side");
                            pd.writeMessage(new Message(700));
                            x = pd.readMessage();
                        } else {
                            System.out.println("[NAT-HP] NL OK, checking remote side...");
                            pd.writeMessage(new Message(800));
                            remoteSide = pd.readMessage();
                            if (remoteSide.getType() == 700) {
                                System.out.println("[NAT-HP] Remote NL failed");
                                try {
                                    nldirect.stop("nathp direct/proxied udp aborted - remote side failed");
                                }
                                catch (Exception xx) {}
                                throw new Exception("[NAT-HP] Had to abort NL - temote side NL failed");
                            }
                            System.out.println("[NAT-HP] Remote NL OK");
                        }
                    }
                } else {
                    pd.writeMessage(new Message(400));
                    pd.readMessage();
                    Thread.sleep(200L);
                    System.out.println("[NAT-HP] adopting client side, connecting to " + target + " from " + locport);
                    unidirectionalEndpointUID = home.getUID();
                    nldirect = null;
                    try {
                        home.setNewUID();
                        nldirect = new NodeLink(home, target, true, CentralDebugging.UDP_VERIFY_PACKET_LOSS_UNDER_DIRECT_UDP);
                    }
                    catch (Exception x) {
                        nldirect = null;
                        if (x != null) {
                            home.shutdownTransports();
                            xx = new Exception("[NAT-HP] FAIL - NL failed to connect " + x);
                            xx.initCause(x);
                            throw xx;
                        }
                    }
                    finally {
                        if (nldirect == null) {
                            System.out.println("[NAT-HP] NL failed, informing remote side");
                            pd.writeMessage(new Message(700));
                            x = pd.readMessage();
                        } else {
                            System.out.println("[NAT-HP] NL OK, checking remote side...");
                            pd.writeMessage(new Message(800));
                            remoteSide = pd.readMessage();
                            if (remoteSide.getType() == 700) {
                                System.out.println("[NAT-HP] Remote NL failed");
                                try {
                                    nldirect.stop("nathp direct/proxied udp aborted - remote side failed");
                                }
                                catch (Exception var29_54) {}
                                throw new Exception("[NAT-HP] Had to abort NL - temote side NL failed");
                            }
                            System.out.println("[NAT-HP] Remote NL OK");
                        }
                    }
                }
                SHelpUdpNlNatHpMk2.doAuth(pd, nldirect);
                System.out.println("[NAT-HP] got direct connection");
                nldirect.getStats().type = 4;
                return nldirect;
            }
            catch (Throwable t) {
                t.printStackTrace();
                xx = new Exception("[NAT-HP] error creating direct connection " + t);
                xx.initCause(t);
                throw xx;
            }
        }
        try {
            home.shutdownTransports();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        throw new Exception("[NAT-HP] failed - no initial communication made it through");
    }

    private static void doAuth(ProtectiveDrain pd, NodeLink nldirect) throws IOException, ProtectiveDrainNowInstruction {
        byte[] mykey = SecurityUtil.generateSymmetricKey();
        Message mkeys = new Message(500);
        mkeys.append(mykey);
        pd.writeMessage(mkeys);
        mkeys = pd.readMessage();
        byte[] theirkey = (byte[])mkeys.get(0);
        OutputStream dout = nldirect.getOutputStream();
        DataUtils.writeBytes(dout, theirkey);
        dout.flush();
        InputStream din = nldirect.getInputStream();
        byte[] echokey = DataUtils.readNBytes(din, 10000);
        if (!Arrays.equals(mykey, echokey)) {
            throw new IOException("Direct authentication failed");
        }
    }

    private static class PacketListener
    implements OrphanPacketListener {
        Object LOCK = new Object();
        byte[] data;
        Node fromNode;

        private PacketListener() {
        }

        @Override
        public long getMaxRegularityInMs() {
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processOrphanPacket(byte[] dat, int conversation, Node fromNode, Node receivedBy) {
            Object object = this.LOCK;
            synchronized (object) {
                System.out.println("[NAT-HP Listener] Packet " + dat.length + " on " + conversation + " from " + fromNode);
                this.fromNode = fromNode;
                this.data = dat;
            }
        }

        public boolean hasData() {
            return this.data != null;
        }

        public Object getLOCK() {
            return this.LOCK;
        }

        public byte[] getData() {
            return this.data;
        }

        public Node getDataFromNode() {
            return this.fromNode;
        }

        public void clearData() {
            this.data = null;
        }
    }
}

