/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import bcutil.BCUMTInputStream;
import bcutil.BCUMTOutputStream;
import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.tcp.TcpEndpoint;
import com.aem.nodelink.tcp.TcpTransport;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import jwrapper.jwutils.JWWindowsOS;
import utils.message.Message;
import utils.multiplex.FastMxInputStream;
import utils.multiplex.FastMxOutputStream;
import utils.osstats.ip.IpStats;
import utils.ostools.OS;
import utils.stream.StreamCloseDetector;
import utils.stream.StreamCloseListener;

public class P2PSock
implements StreamCloseListener {
    public static int SCAN_LIMIT = 30;
    public static int PORT_RA_P2P = 15330;
    public static int PORT_TC_P2P = PORT_RA_P2P + SCAN_LIMIT;
    public static int PORT_TSES_P2P = 15330;
    public static int PORT_CSES_P2P = PORT_TSES_P2P + SCAN_LIMIT;
    private boolean VERBOSE = false;
    long straw = BCUtil.getNextAbsID();
    FastMxInputStream xin;
    FastMxOutputStream xout;
    OutputStream bcout;
    InputStream bcin;
    Object connect_NOTIFY = new Object();
    Object setsock_LOCK = new Object();
    ServerSocket ssock;
    Socket sock;
    NodeLink nodelink;
    TcpTransport nltransport;
    boolean successOutgoing;
    String successHost;
    int successPort;

    public static Message getMyHostsList() {
        Object[] pairs = null;
        if (OS.isWindows()) {
            try {
                JWWindowsOS.NetworkAdapterInfo[] networkInfo = JWWindowsOS.getWindowsInstance().getNetworkInfo();
                if (networkInfo != null) {
                    int i;
                    pairs = new String[networkInfo.length];
                    int index = 0;
                    for (i = 0; i < pairs.length; ++i) {
                        if (networkInfo[i].description != null && (networkInfo[i].description.toLowerCase().contains("virtual") || networkInfo[i].description.toLowerCase().contains("vmware"))) continue;
                        pairs[index++] = networkInfo[i].ipAddress + "/" + networkInfo[i].macAddress + "/" + networkInfo[i].description;
                    }
                    for (i = 0; i < pairs.length; ++i) {
                        if (networkInfo[i].description == null || !networkInfo[i].description.toLowerCase().contains("virtual") && !networkInfo[i].description.toLowerCase().contains("vmware")) continue;
                        pairs[index++] = networkInfo[i].ipAddress + "/" + networkInfo[i].macAddress + "/" + networkInfo[i].description;
                    }
                }
            }
            catch (Throwable t) {
                System.out.println("[MonitoringMessage] Unable to use native API query for network stats");
                pairs = null;
            }
        }
        if (pairs == null) {
            try {
                pairs = IpStats.getIpMacPairs();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (pairs == null) {
            pairs = new String[]{};
        }
        Arrays.sort(pairs);
        Message nets = new Message();
        for (Object net : pairs) {
            int slash = ((String)net).indexOf(47);
            if (slash == -1) continue;
            net = ((String)net).substring(0, slash);
            nets.append((String)net);
        }
        return nets;
    }

    public int listenOn(int portStart, int portEnd) throws IOException {
        for (int i = portStart; i <= portEnd; ++i) {
            try {
                new Incoming(i).start();
                return i;
            }
            catch (Exception x) {
                if (!this.VERBOSE) continue;
                System.out.println("[P2PSock] Unable to listen on " + i);
                continue;
            }
        }
        throw new IOException("Unable to listen on specified ports " + portStart + " to " + portEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Message remoteHostList, int remotePort, long maxMs) throws IOException {
        Object object = this.connect_NOTIFY;
        synchronized (object) {
            if (this.sock == null) {
                remoteHostList.resetIndex();
                while (remoteHostList.hasNext()) {
                    String ip = remoteHostList.getNextString();
                    new Outgoing(ip, remotePort).start();
                }
                try {
                    System.out.println("[P2PSock] Waiting for connection (max " + maxMs + ")");
                    this.connect_NOTIFY.wait(maxMs);
                    System.out.println("[P2PSock] Finished waiting");
                }
                catch (Exception x) {
                    System.out.println("[P2PSock] Exception while waiting - " + x);
                }
            }
        }
        if (this.sock == null) {
            throw new IOException("Unable to connect direct");
        }
    }

    public FastMxInputStream getSecureXin() {
        return this.xin;
    }

    public FastMxOutputStream getSecureXout() {
        return this.xout;
    }

    public void switchToBasicNL() throws Exception {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ssock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Node me = new Node();
        me.setSingleUse(true);
        if (this.successOutgoing) {
            TcpEndpoint ep = new TcpEndpoint(this.successHost, this.successPort);
            Node remote = new Node();
            me.setRemoteNodeAddress(remote, ep);
            Thread.sleep(200L);
            this.nodelink = new NodeLink(me, remote);
        } else {
            TcpEndpoint ep = new TcpEndpoint("localhost", this.successPort);
            this.nltransport = (TcpTransport)me.acceptIncomingOn(ep);
            this.nodelink = new NodeLink(me);
            this.nodelink.addLinkStatusListener(new TransportClose(this.nltransport, ep));
        }
    }

    public void multiplexSock() throws Exception {
        this.xin = new FastMxInputStream(new BufferedInputStream(this.sock.getInputStream()), "P2PSockPlain");
        this.xout = new FastMxOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
    }

    public void multiplexNL() throws Exception {
        this.xin = new FastMxInputStream(new BufferedInputStream(this.nodelink.getInputStream()), "P2PSockPlainNL");
        this.xout = new FastMxOutputStream(new BufferedOutputStream(this.nodelink.getOutputStream()));
    }

    public boolean isLocal() {
        InetAddress addr = ((InetSocketAddress)this.sock.getRemoteSocketAddress()).getAddress();
        return addr.isSiteLocalAddress() || addr.isLinkLocalAddress() || addr.isAnyLocalAddress() || addr.isLoopbackAddress();
    }

    public void switchToSecureParallelNL(BCUtil bcu) throws Exception {
        this.switchToBasicNL();
        this.bcout = new BCUMTOutputStream(new BufferedOutputStream(this.nodelink.getOutputStream()), bcu);
        this.bcin = new BCUMTInputStream(new BufferedInputStream(this.nodelink.getInputStream()), bcu);
        this.xin = new FastMxInputStream(new BufferedInputStream(this.bcin), "P2PSockSecureNL");
        this.xout = new FastMxOutputStream(new BufferedOutputStream(this.bcout));
    }

    public void switchToSecureNL(BCUtil bcu) throws Exception {
        this.switchToBasicNL();
        this.bcout = new BCUtilOutputStream((OutputStream)new BufferedOutputStream(this.nodelink.getOutputStream()), bcu);
        this.bcin = new BCUtilInputStream((InputStream)new BufferedInputStream(this.nodelink.getInputStream()), bcu);
        this.xin = new FastMxInputStream(new BufferedInputStream(this.bcin), "P2PSockSecureNL");
        this.xout = new FastMxOutputStream(new BufferedOutputStream(this.bcout));
    }

    public void secureAndMonitor(BCUtil bcu) throws IOException {
        this.bcout = new BCUtilOutputStream((OutputStream)new BufferedOutputStream(this.sock.getOutputStream()), bcu);
        this.bcin = new BCUtilInputStream((InputStream)new BufferedInputStream(this.sock.getInputStream()), bcu);
        this.xin = new FastMxInputStream(new BufferedInputStream(this.bcin), "P2PSockTCP");
        this.xout = new FastMxOutputStream(new BufferedOutputStream(this.bcout));
        StreamCloseDetector closey = new StreamCloseDetector(this.xin.getInputStream((short)-31223, "P2PStreamMonitoring"), this.xout.getOutputStream((short)-31223), (StreamCloseListener)this, 180000L);
    }

    public OutputStream getSecureOutputStream(short index) {
        return this.xout.getOutputStream(index);
    }

    public InputStream getSecureInputStream(short index) {
        return this.xin.getInputStream(index, "P2PSockInStream" + index);
    }

    public void streamClosed(String reason) {
        try {
            System.out.println("[P2PSock] Stream close detected " + this.sock + " (" + reason + ")");
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("P2PSock ");
        if (this.nodelink != null) {
            sb.append("NL ");
        }
        sb.append(this.successHost).append(':').append(this.successPort);
        return sb.toString();
    }

    public NodeLink getRawNL() {
        return this.nodelink;
    }

    public Socket getRawSocket() {
        return this.sock;
    }

    public static void main(String[] args) {
        Message m = P2PSock.getMyHostsList();
        while (m.hasNext()) {
            System.out.println(m.getNextString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSock(Socket sock, boolean outgoing, String host, int port) {
        block37: {
            try {
                sock.setSoTimeout(6000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                boolean close;
                block36: {
                    boolean decider = false;
                    try {
                        System.out.println("[P2PSock] Writing straw " + this.straw + " into " + host + ":" + port);
                        StreamUtils.writeLong(sock.getOutputStream(), this.straw);
                        sock.getOutputStream().flush();
                        System.out.println("[P2PSock] Waiting for remote straw from " + host + ":" + port);
                        long remoteStraw = StreamUtils.readLong(sock.getInputStream());
                        System.out.println("[P2PSock] Got remote straw " + remoteStraw + " from " + host + ":" + port);
                        if (this.straw > remoteStraw) {
                            decider = true;
                        }
                    }
                    catch (IOException remoteStraw) {
                        // empty catch block
                    }
                    close = false;
                    Object object = this.setsock_LOCK;
                    synchronized (object) {
                        System.out.println("[P2PSock] Processing for " + host + ":" + port + " has the lock (decider: " + decider + ")");
                        if (decider && this.sock == null) {
                            System.out.println("[P2PSock] Chosen socket is " + host + ":" + port);
                            this.sock = sock;
                        }
                    }
                    try {
                        if (decider) {
                            if (this.sock == sock) {
                                sock.setTcpNoDelay(true);
                                this.successOutgoing = outgoing;
                                this.successHost = host;
                                this.successPort = port;
                                try {
                                    this.ssock.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                StreamUtils.writeBoolean(sock.getOutputStream(), true);
                                sock.getOutputStream().flush();
                                System.out.println("[P2PSock] Decided to keep " + sock);
                                object = this.connect_NOTIFY;
                                synchronized (object) {
                                    this.connect_NOTIFY.notifyAll();
                                    break block36;
                                }
                            }
                            System.out.println("[P2PSock] Decided to close " + sock);
                            close = true;
                            break block36;
                        }
                        boolean bl = close = !StreamUtils.readBoolean(sock.getInputStream());
                        if (!close) {
                            System.out.println("[P2PSock] Told to keep " + sock);
                            if (this.sock != null) {
                                System.out.println("[P2PSock] WARNING sock exists!?");
                            }
                            sock.setTcpNoDelay(true);
                            this.sock = sock;
                            this.successOutgoing = outgoing;
                            this.successHost = host;
                            this.successPort = port;
                            try {
                                this.ssock.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            object = this.connect_NOTIFY;
                            synchronized (object) {
                                this.connect_NOTIFY.notifyAll();
                                break block36;
                            }
                        }
                        System.out.println("[P2PSock] Told to close " + sock);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
                if (!close) break block37;
                try {
                    StreamUtils.writeBoolean(sock.getOutputStream(), false);
                    sock.getOutputStream().flush();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                try {
                    sock.setSoTimeout(0);
                }
                catch (Exception exception) {}
            }
        }
    }

    class Incoming
    extends Thread {
        int port;

        public Incoming(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            try {
                if (P2PSock.this.VERBOSE) {
                    System.out.println("[P2PSock] Attempting " + this.port);
                }
                P2PSock.this.ssock = new ServerSocket(this.port);
                try {
                    Socket sock = P2PSock.this.ssock.accept();
                    if (P2PSock.this.VERBOSE) {
                        System.out.println("[P2PSock] Got " + this.port);
                    }
                    P2PSock.this.setSock(sock, false, "localhost", this.port);
                }
                catch (Exception exception) {
                }
                finally {
                    P2PSock.this.ssock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Outgoing
    extends Thread {
        String ip;
        int port;

        public Outgoing(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }

        @Override
        public void run() {
            try {
                if (P2PSock.this.VERBOSE) {
                    System.out.println("[P2PSock] Attempting " + this.ip + ":" + this.port);
                }
                Socket sock = new Socket(this.ip, this.port);
                if (P2PSock.this.VERBOSE) {
                    System.out.println("[P2PSock] Got " + this.ip + ":" + this.port);
                }
                P2PSock.this.setSock(sock, true, this.ip, this.port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class TransportClose
    implements NodeLinkStatusListener {
        TcpTransport me;
        TcpEndpoint ep;

        public TransportClose(TcpTransport me, TcpEndpoint ep) {
            this.me = me;
            this.ep = ep;
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
        }

        @Override
        public void linkOK(NodeLink link) {
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            try {
                System.out.println("[P2PSock] Shutting down NL listening on " + this.ep);
                this.me.stopAcceptingOn(this.ep);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

