/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;

public class ListDialog
extends ScaledGlassDialog
implements ActionListener {
    private Object[] listData;
    private String message;

    public ListDialog(RootPaneContainer rootPane, ArrayList listData, String title, String message) {
        super(rootPane, 450, 400, false, true, false);
        this.setTitle(title);
        this.listData = listData.toArray();
        this.message = message;
        this.initGraphics();
    }

    private void initGraphics() {
        this.setModal(false);
        JPanel main = new JPanel();
        main.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        main.setLayout(new BorderLayout(5, 5));
        JList<Object> list = new JList<Object>(this.listData);
        main.add((Component)new JScrollPane(list), "Center");
        JWrapLabel label = new JWrapLabel("<html>" + this.message + "</html>");
        main.add((Component)label, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new ScaledFlowLayout());
        JButton closeButton = new JButton();
        closeButton.setText(Language.get("OK"));
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        main.add((Component)buttonPanel, "South");
        this.getContentPane().add(main);
        if (CentralDebugging.GLASS_DIALOGS_VERBOSE) {
            System.out.println("Setting list dialog visible");
        }
        this.setVisible(true);
        if (CentralDebugging.GLASS_DIALOGS_VERBOSE) {
            System.out.println("Set list dialog visible");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

