/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.common.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.swing.SafeDialogIcon;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.cui.types.fields.TextAreaField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ErrorDialogs {
    protected JPanel main = new JPanel();
    protected JButton bclose;
    protected JButton bmore;
    protected JButton brestart;
    protected JWrapLabel descriptionLabel;
    protected JWrapLabel titleLabel;
    protected TextAreaField moreInfo;
    private JPanel paddy;

    protected void flipMoreOn() {
        this.moreInfo.getComponent().setVisible(true);
        this.paddy.setVisible(false);
        this.bmore.setVisible(false);
    }

    protected ScaledInsets getFieldInsets() {
        return new ScaledInsets(5, 10, 5, 10);
    }

    private void initUI(Icon icon, boolean showRestart) {
        this.main.setLayout(new BorderLayout());
        this.descriptionLabel = new JWrapLabel();
        this.titleLabel = new JWrapLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.moreInfo = new TextAreaField(null, null);
        this.paddy = new JPanel();
        GbPanel mainContent = new GbPanel(this.getFieldInsets());
        mainContent.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        mainContent.add((Component)this.titleLabel, 0, 0, 1, 1, 1, 0, 10, 2);
        mainContent.add((Component)this.descriptionLabel, 0, 1, 1, 1, 1, 0, 10, 2);
        mainContent.add((Component)this.moreInfo.getComponent(), 0, 2, 1, 1, 1, 100, 10, 1, (Insets)new ScaledInsets(5, 10, 0, 10));
        mainContent.add((Component)this.paddy, 0, 3, 1, 1, 1, 1, 10, 1);
        this.moreInfo.getTextArea().setBorder(null);
        this.moreInfo.getComponent().setVisible(false);
        this.moreInfo.getTextArea().setEditable(false);
        this.main.add("Center", (Component)mainContent);
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)0));
            iconLabel.setVerticalAlignment(1);
            this.main.add("West", iconLabel);
        }
        this.main.add("South", this.initButtonsPanel(showRestart));
    }

    public void setText(String heading, String message, String moreInfoText) {
        if (heading == null) {
            this.titleLabel.setVisible(false);
        } else {
            this.titleLabel.setText("<html>" + heading + "</html>");
        }
        if (message == null) {
            this.descriptionLabel.setVisible(false);
        } else {
            this.descriptionLabel.setText("<html>" + message + "</html>");
        }
        if (moreInfoText == null) {
            this.bmore.setVisible(false);
        } else {
            this.moreInfo.setDefaultValue(moreInfoText);
        }
    }

    private JPanel initButtonsPanel(boolean showRestart) {
        this.brestart = new JButton(Language.get("RESTART"));
        this.bclose = new JButton(Language.get("CLOSE"));
        this.bmore = new JButton(Language.get("MORE_DETAILS"));
        SHButtonUI.makeButtonBlue((JButton)this.bclose);
        GbPanel buttons = new GbPanel(new ScaledInsets(10, 10, 10, 10));
        buttons.add((Component)new JPanel(), 0, 0, 1, 1, 1000, 1, 17, 2);
        buttons.add((Component)this.bmore, 1, 0, 1, 1, 1, 1, 17, 0);
        if (showRestart) {
            buttons.add((Component)this.brestart, 2, 0, 1, 1, 1, 1, 13, 0);
            buttons.add((Component)this.bclose, 3, 0, 1, 1, 1, 1, 13, 0);
            SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.bmore, this.brestart, this.bclose});
        } else {
            buttons.add((Component)this.bclose, 2, 0, 1, 1, 1, 1, 13, 0);
            SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.bmore, this.bclose});
        }
        return buttons;
    }

    public static class ErrorDialog
    extends JDialog
    implements ActionListener {
        ErrorDialogs util = new ErrorDialogs();

        public ErrorDialog(RootPaneContainer rootPane, String title) {
            this(rootPane, title, null);
        }

        public ErrorDialog(RootPaneContainer rootPane, String title, ImageIcon icon) {
            super((Frame)null);
            this.setSize(480, 120 + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT);
            this.setModal(true);
            this.setLocationRelativeTo(rootPane.getContentPane());
            if (icon == null) {
                this.util.initUI(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), false);
            } else {
                this.util.initUI(ImageLoader.getOverlayedIcon((Icon)icon, (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16")), false);
            }
            this.getContentPane().add(this.util.main);
            SafeDialogIcon.setDialogIcon((JDialog)this, ImageLoader.getAsImage((String)"images/svg/dialogs/error.svg,16"));
            this.util.bmore.addActionListener(this);
            this.util.bclose.addActionListener(this);
            this.setTitle(title);
        }

        public void showDialog() {
            this.setVisible(true);
        }

        public void setText(String heading, String message, String moreInfoText) {
            this.util.setText(heading, message, moreInfoText);
        }

        protected void okPressed() {
            this.setVisible(false);
        }

        protected void morePressed() {
            this.util.flipMoreOn();
            this.setSize(this.getSize().width, SimpleHelpLookAndFeel.scale((int)300));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.util.bclose) {
                this.okPressed();
            } else if (e.getSource() == this.util.bmore) {
                this.morePressed();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.okPressed();
            } else if (e.getKeyCode() == 27) {
                this.okPressed();
            }
        }
    }

    public static class ErrorGlassDialog
    extends ScaledGlassDialog
    implements ActionListener {
        ErrorDialogs util = new ErrorDialogs();

        public ErrorGlassDialog(RootPaneContainer rootPane, String title) {
            this(rootPane, title, null);
        }

        public ErrorGlassDialog(RootPaneContainer rootPane, String title, ImageIcon icon) {
            this(rootPane, title, icon, true);
        }

        public ErrorGlassDialog(RootPaneContainer rootPane, String title, Icon icon, boolean overlayError) {
            this(rootPane, title, icon, overlayError, false);
        }

        public ErrorGlassDialog(RootPaneContainer rootPane, String title, Icon icon, boolean overlayError, boolean showRestart) {
            super(rootPane, 480, 170, true, true, false);
            this.setModal(true);
            if (icon == null) {
                this.util.initUI(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), showRestart);
            } else if (overlayError) {
                this.util.initUI(ImageLoader.getOverlayedIcon((Icon)icon, (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16")), showRestart);
            } else {
                this.util.initUI(icon, showRestart);
            }
            this.getContentPane().add(this.util.main);
            this.util.bmore.addActionListener(this);
            this.util.bclose.addActionListener(this);
            this.util.brestart.addActionListener(this);
            this.setTitle(title);
        }

        public void showDialog() {
            this.setVisible(true);
        }

        protected void okPressed() {
            this.setVisible(false);
        }

        protected void morePressed() {
            this.util.flipMoreOn();
            this.setHeight(SimpleHelpLookAndFeel.scale((int)300));
        }

        protected void restartPressed() {
            try {
                JWSystem.forkVirtualApp((String)JWSystem.getMyAppName(), (Properties)new Properties(), (String[])new String[0], (boolean)false, (boolean)true);
                Thread.sleep(300L);
                System.exit(0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.util.bclose) {
                this.okPressed();
            } else if (e.getSource() == this.util.bmore) {
                this.morePressed();
            } else if (e.getSource() == this.util.brestart) {
                this.restartPressed();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.okPressed();
            } else if (e.getKeyCode() == 27) {
                this.okPressed();
            }
        }

        public void setText(String heading, String message, String moreInfoText) {
            this.util.setText(heading, message, moreInfoText);
        }
    }
}

